/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.data.providers.olap.essbase.EssbaseConnection;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseSubstitutionVariable;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseWrappers;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.metadata.record.MacroRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.essbase.api.datasource.IEssCube;

public class EssbaseMacro
extends EssbaseSubstitutionVariable {
    private static final String STR_SINGLEQUOTATION = "'";
    private static final String STR_DOUBLEQUOTATION = "\"";
    private MacroRecord macroRecord = null;

    public EssbaseMacro(EssbaseConnection connection, String[] substVariable) {
        super(substVariable);
        this.createMacroRecord(connection);
    }

    private void createMacroRecord(EssbaseConnection connection) {
        this.macroRecord = new MacroRecord();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        IEssCube essCube = connection.getMetadataCache().getEssConnectionCube();
        this.macroRecord.setName(this.getSvName());
        this.macroRecord.setUniqueName(this.getSvName());
        this.macroRecord.setCaption(this.getSvName());
        this.macroRecord.setCatalogName(essbaseAPI.getCatalogName(essCube));
        this.macroRecord.setCubeName(essbaseAPI.getCubeName(essCube));
        this.macroRecord.setUniqueId(RecordType.MACRO, this.macroRecord.getUniqueName());
        this.macroRecord.setDataType(this.getMacroDataType());
    }

    private IDataType getMacroDataType() {
        StringType resultType = DataTypeFactory.getStringType();
        String expression = this.getSvValue().trim();
        if (expression.startsWith(STR_DOUBLEQUOTATION) && expression.endsWith(STR_DOUBLEQUOTATION)) {
            if ((expression = expression.substring(1, expression.length() - 1)).contains(STR_DOUBLEQUOTATION)) {
                expression = this.getSvValue();
            } else {
                this.setSvValue(expression);
                resultType = this.checkForNumericType(expression);
            }
        }
        if (resultType.equals(DataTypeFactory.getStringType())) {
            StringBuilder buf = new StringBuilder(STR_SINGLEQUOTATION);
            buf.append(this.getSvValue()).append(STR_SINGLEQUOTATION);
            this.macroRecord.setExpression(buf.toString());
        } else {
            this.macroRecord.setExpression(expression);
        }
        return resultType;
    }

    private IDataType checkForNumericType(String expression) {
        try {
            Long.parseLong(expression);
            return DataTypeFactory.getIntegerType();
        }
        catch (NumberFormatException eInteger) {
            try {
                Double.parseDouble(expression);
                return DataTypeFactory.getFloatType();
            }
            catch (NumberFormatException eFloat) {
                return DataTypeFactory.getStringType();
            }
        }
    }

    public void updateMacroIfRequired(String[] substVariable) {
        if (this.updateIfRequired(substVariable)) {
            this.macroRecord.setDataType(this.getMacroDataType());
        }
    }

    public void refreshCachedValue(EssbaseConnection connection) {
        this.refreshSVValue(connection);
        this.macroRecord.setDataType(this.getMacroDataType());
    }

    public MacroRecord getMacroRecord() {
        return this.macroRecord;
    }
}

