/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseConnection;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseDimensionCacheItem;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseLocalizedString;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMessageKeys;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataCache;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataNames;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseRuntimeException;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseUtil;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseWrappers;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.essbase.api.base.IEssIterator;
import com.essbase.api.datasource.IEssCube;
import com.essbase.api.metadata.IEssMember;
import com.essbase.api.metadata.IEssMemberSelection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class EssbaseMemberCacheItem {
    private String catalogName = null;
    private String cubeName = null;
    private String name = null;
    private String uniqueName = null;
    Map<String, String> cachedAliasNames = new HashMap<String, String>();
    private String description = null;
    private String dimensionName = null;
    private String levelName = null;
    private int levelNumber = -1;
    private String parentUniqueName = null;
    private boolean isMemberFormula = false;
    private RollupTypeEnum rollupType = RollupTypeEnum.ROLLUP;
    private int cardinality = 0;
    private String formatString = null;
    private AggregateTypeEnum regularAggregate = AggregateTypeEnum.UNKNOWN;
    private AggregateTypeEnum semiAggregate = AggregateTypeEnum.UNKNOWN;
    private final EssbaseConnection connection;
    private final EssbaseWrappers essbaseAPI;

    EssbaseMemberCacheItem(EssbaseConnection theConnection) {
        this.connection = theConnection;
        this.essbaseAPI = this.connection.getEssAPI();
    }

    public final void setCatalogName(String theCatalogName) {
        this.catalogName = theCatalogName;
    }

    public final void setCubeName(String theCubeName) {
        this.cubeName = theCubeName;
    }

    public final void setName(String theName) {
        this.name = theName;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public final void setUniqueName(String theUniqueName) {
        this.uniqueName = theUniqueName;
    }

    public final void setDescription(String theDescription) {
        this.description = theDescription;
    }

    public final void setDimensionName(String theDimensionName) {
        this.dimensionName = theDimensionName;
    }

    public final void setLevelName(String theLevelName) {
        this.levelName = theLevelName;
    }

    public final int getLevelNumber() {
        return this.levelNumber;
    }

    public final void setLevelNumber(int theLevelNumber) {
        this.levelNumber = theLevelNumber;
    }

    public final void setRollupType(RollupTypeEnum theRollupType) {
        this.rollupType = theRollupType;
    }

    public final int getCardinality() {
        return this.cardinality;
    }

    public final void setCardinality(int theCardinality) {
        this.cardinality = theCardinality;
    }

    public final String getParentUniqueName() {
        return this.parentUniqueName;
    }

    public final void setParentUniqueName(String theParentUniqueName) {
        this.parentUniqueName = theParentUniqueName;
    }

    public final void setRegularAggregate(AggregateTypeEnum theRegularAggregate) {
        this.regularAggregate = theRegularAggregate;
    }

    public final void setSemiAggregate(AggregateTypeEnum theSemiAggregate) {
        this.semiAggregate = theSemiAggregate;
    }

    public void setCacheMember(IEssMemberSelection essMbrSelection, IEssMember theEssMember, String theMemberName, String theDimensionName) {
        EssbaseMetadataCache metadataCache = this.connection.getMetadataCache();
        IEssCube essCube = metadataCache.getEssConnectionCube();
        IEssMember essMember = theEssMember;
        String dimName = theDimensionName;
        if (essMember == null) {
            this.essbaseAPI.executeQuery(essMbrSelection, theMemberName, 11, dimName, theMemberName, "");
            IEssIterator essMembers = this.essbaseAPI.getMembers(essMbrSelection);
            if (essMembers == null) {
                throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_MEMBER_NAME, theMemberName);
            }
            essMember = (IEssMember)this.essbaseAPI.getAt(essMembers, 0);
        }
        if (dimName == null) {
            dimName = this.essbaseAPI.getDimensionName(essMember);
        }
        EssbaseDimensionCacheItem cachedDimension = metadataCache.getDimension(dimName);
        boolean isMeasure = false;
        if (cachedDimension.getType() == DimensionTypeEnum.MEASURE) {
            isMeasure = true;
        }
        this.setName(theMemberName.intern());
        this.setDimensionName(dimName.intern());
        int generationNumber = this.essbaseAPI.getGenerationNumber(essMember);
        if (isMeasure) {
            this.setLevelNumber(generationNumber - 2);
        } else {
            this.setLevelNumber(generationNumber - 1);
        }
        this.getAliasNames(essMember);
        String theDescription = this.essbaseAPI.getMemberDescription(essMember);
        if (theDescription != null) {
            this.setDescription(theDescription);
        }
        this.setCatalogName(this.essbaseAPI.getCatalogName(essCube));
        this.setCubeName(this.essbaseAPI.getCubeName(essCube));
        Set<LevelRecord> levelCache = metadataCache.getDimensionLevelCache(dimName);
        Iterator<LevelRecord> iter = levelCache.iterator();
        LevelRecord levelRecord = null;
        for (int i = 0; i < generationNumber; ++i) {
            levelRecord = iter.next();
        }
        if (levelRecord == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Error during creating and caching cache members: levelRecord here is null");
        }
        String theLevelName = levelRecord.getName();
        this.setLevelName(theLevelName);
        this.setCardinality(this.essbaseAPI.getChildCount(essMember));
        this.isMemberFormula = this.essbaseAPI.isFormula(essMember);
        if (isMeasure) {
            if (this.isMemberFormula) {
                this.setRollupType(RollupTypeEnum.COMPUTED);
                this.setRegularAggregate(AggregateTypeEnum.CALC);
            } else {
                this.setRollupType(RollupTypeEnum.ROLLUP);
                this.setRegularAggregate(AggregateTypeEnum.SUM);
            }
            AggregateTypeEnum timeBalanceOption = this.essbaseAPI.getTimeBalanceOption(essMember);
            this.setSemiAggregate(timeBalanceOption);
            String[] memberUDAs = this.essbaseAPI.getUDAs(essMember);
            this.formatString = EssbaseUtil.getUDAvalue(memberUDAs, "COGNOS_FORMAT");
        } else if (this.isRollupComputed(essMember, cachedDimension.getType())) {
            this.setRollupType(RollupTypeEnum.COMPUTED);
        } else {
            this.setRollupType(RollupTypeEnum.ROLLUP);
        }
        String localParentUniqueName = null;
        String memberUniqueName = null;
        if (generationNumber == 1) {
            memberUniqueName = UniqueNameGenerator.createUniqueName((String)theMemberName);
        } else {
            String parentName = this.essbaseAPI.getParentMemberName(essMember);
            if (parentName != null && parentName.length() > 0) {
                EssbaseMemberCacheItem parentMember = metadataCache.findMemberCacheItem(null, parentName);
                if (parentMember == null) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("@ALLANCESTORS (\"").append(theMemberName).append("\")");
                    this.essbaseAPI.executeQuery(essMbrSelection, " <OutputType Binary <SelectMbrInfo(MemberName,DimensionName,MemberGeneration,MemberLevel,Consolidation,MemberFormula,MemberAliasName,UDAList,Comment,ParentMemberName,ShareOption,ChildrenCount)", buf.toString());
                    IEssIterator essMemberAncs = this.essbaseAPI.getMembers(essMbrSelection);
                    int essMembersCount = this.essbaseAPI.getCount(essMemberAncs);
                    for (int i = essMembersCount - 1; i >= 0; --i) {
                        IEssMember essMbr = (IEssMember)this.essbaseAPI.getAt(essMemberAncs, i);
                        String mbrName = this.essbaseAPI.getMemberName(essMbr);
                        if (metadataCache.findMemberCacheItem(null, mbrName) != null) continue;
                        EssbaseMemberCacheItem cacheItem = new EssbaseMemberCacheItem(this.connection);
                        cacheItem.setCacheMember(essMbrSelection, essMbr, mbrName, dimName);
                        metadataCache.putMemberCacheItem(null, mbrName, cacheItem);
                    }
                    parentMember = metadataCache.findMemberCacheItem(null, parentName);
                }
                localParentUniqueName = parentMember.getUniqueName();
                memberUniqueName = UniqueNameGenerator.appendUniqueName((String)localParentUniqueName, (String)theMemberName);
            } else {
                localParentUniqueName = null;
                memberUniqueName = UniqueNameGenerator.createUniqueName((String)dimName, (String)theMemberName);
            }
        }
        this.setParentUniqueName(localParentUniqueName);
        this.setUniqueName(memberUniqueName);
    }

    private void getAliasNames(IEssMember essMember) {
        EssbaseMetadataCache metadataCache = this.connection.getMetadataCache();
        if (this.name.equals(this.dimensionName)) {
            Map<String, String> rootMemberCaptions = metadataCache.getRootMemberAliasNames(this.dimensionName);
            this.cachedAliasNames.putAll(rootMemberCaptions);
        } else {
            String[] aliasTableNames;
            for (String aliasTableName : aliasTableNames = metadataCache.getEssAliasTableNames()) {
                String captionName = this.essbaseAPI.getAlias(essMember, aliasTableName);
                if (captionName == null) {
                    captionName = this.essbaseAPI.getMemberName(essMember);
                }
                this.cachedAliasNames.put(aliasTableName, captionName);
            }
        }
    }

    private boolean isRollupComputed(IEssMember essMember, DimensionTypeEnum dimensionType) {
        if (dimensionType != DimensionTypeEnum.SCENARIO) {
            return false;
        }
        if (this.essbaseAPI.getLevelNumber(essMember) == 0) {
            return false;
        }
        if (this.isMemberFormula) {
            return true;
        }
        String memberName = this.essbaseAPI.getMemberName(essMember);
        String dimName = this.essbaseAPI.getDimensionName(essMember);
        boolean foundNonSumRollup = false;
        IEssMemberSelection mbrSel = this.connection.openMbrSel();
        this.essbaseAPI.executeQuery(mbrSel, memberName, 1, dimName, "", "");
        IEssIterator essMembers = this.essbaseAPI.getMembers(mbrSel);
        int essMembersCount = this.essbaseAPI.getCount(essMembers);
        for (int i = 0; i < essMembersCount; ++i) {
            IEssMember essChild = (IEssMember)this.essbaseAPI.getAt(essMembers, i);
            int type = this.essbaseAPI.getConsolidationType(essChild);
            if (type == 0) continue;
            foundNonSumRollup = true;
            break;
        }
        this.connection.releaseMbrSel(mbrSel);
        return foundNonSumRollup;
    }

    public MemberRecord createMemberRecord(IEssMember essMember, Map<String, String> aliasTableNames, EssbaseLocalizedString localizedStringHelper) {
        EssbaseMetadataCache metadataCache = this.connection.getMetadataCache();
        if (metadataCache.getCancelManager() != null && metadataCache.getCancelManager().isRequestCancelled()) {
            throw new OperationCanceledException();
        }
        MemberRecord memberRec = new MemberRecord();
        memberRec.setName(this.name);
        memberRec.setUniqueName(this.uniqueName);
        LocalizedString caption = this.getCaptions(essMember, aliasTableNames, localizedStringHelper);
        memberRec.setCaption((ILocalizedString)caption);
        memberRec.setDescription(this.description);
        memberRec.setLevelNumber(this.levelNumber);
        if (this.levelNumber <= 0) {
            memberRec.setParentCount(0);
        } else {
            memberRec.setParentCount(1);
        }
        memberRec.setParentLevelNumber(this.levelNumber - 1);
        memberRec.setParentUniqueName(this.parentUniqueName);
        memberRec.setCatalogName(this.catalogName);
        memberRec.setCubeName(this.cubeName);
        String dun = EssbaseMetadataNames.createDimensionUniqueName(this.dimensionName);
        memberRec.setDimensionUniqueName(dun);
        String hun = EssbaseMetadataNames.createHierarchyUniqueName(this.dimensionName);
        memberRec.setHierarchyUniqueName(hun);
        String lun = EssbaseMetadataNames.createLevelUniqueName(this.dimensionName, this.levelName);
        memberRec.setLevelUniqueName(lun);
        if (this.isMemberFormula) {
            memberRec.setType(MemberTypeEnum.CALCULATED);
        } else {
            memberRec.setType(MemberTypeEnum.REGULAR);
        }
        memberRec.setUniqueId(memberRec.getName());
        memberRec.setChildCardinality(this.cardinality);
        memberRec.setRollupType(this.rollupType);
        return memberRec;
    }

    public MeasureRecord createMeasureRecord(IEssMember essMember, Map<String, String> aliasTableNames, EssbaseLocalizedString localizedStringHelper) {
        MeasureRecord measureRec = new MeasureRecord();
        measureRec.setName(this.name);
        measureRec.setUniqueName(this.uniqueName);
        measureRec.setDescription(this.description);
        LocalizedString caption = this.getCaptions(essMember, aliasTableNames, localizedStringHelper);
        measureRec.setCaption((ILocalizedString)caption);
        measureRec.setCatalogName(this.catalogName);
        measureRec.setCubeName(this.cubeName);
        String dun = UniqueNameGenerator.createUniqueName((String)this.dimensionName);
        measureRec.setDimensionUniqueName(dun);
        String hun = UniqueNameGenerator.createUniqueName((String)this.dimensionName, (String)this.dimensionName);
        measureRec.setHierarchyUniqueName(hun);
        String lun = UniqueNameGenerator.createUniqueName((String)this.dimensionName, (String)this.levelName);
        measureRec.setLevelUniqueName(lun);
        measureRec.setDataType((IDataType)DataTypeFactory.getDoubleType());
        measureRec.setUniqueId(measureRec.getName());
        measureRec.setRegularAggregate(this.regularAggregate);
        measureRec.setSemiAggregate(this.semiAggregate);
        return measureRec;
    }

    public LocalizedString getCaptions(IEssMember essMember, Map<String, String> aliasTableNames, EssbaseLocalizedString localizedStringHelper) {
        return localizedStringHelper.getLocalizedCaptions(this.connection, this.name, this.dimensionName, essMember, aliasTableNames, this.cachedAliasNames);
    }

    public String getFormatString() {
        return this.formatString;
    }
}

