/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.ast.maExp.MABlockConstraint;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseWrappers;
import com.cognos.xqe.transformation.ma.provider.MASearchCriteria;
import com.essbase.api.metadata.IEssMember;
import java.util.ArrayList;
import java.util.List;

public class EssbaseMemberSearch {
    private final MASearchCriteria.SearchCondition searchCondition;
    private List<String> searchValues;
    private MABlockConstraint.Operation searchOperation;
    private final boolean searchCaseInsensitive;
    private final EssbaseWrappers essbaseAPI;
    String runLocaleAiasTable = null;

    EssbaseMemberSearch(EssbaseWrappers theAPI, String aiasTableName, MASearchCriteria theSearchCriteria) {
        this.essbaseAPI = theAPI;
        this.runLocaleAiasTable = aiasTableName;
        this.searchCondition = theSearchCriteria.getSearchCondition();
        this.searchValues = theSearchCriteria.getSearchValues();
        this.searchOperation = theSearchCriteria.getOperator();
        this.searchCaseInsensitive = theSearchCriteria.getCaseInsensitive();
        if (this.searchCaseInsensitive) {
            ArrayList<String> newValues = new ArrayList<String>(this.searchValues.size());
            for (String searchValue : this.searchValues) {
                String newValue = searchValue.toUpperCase();
                newValues.add(newValue);
            }
            this.searchValues = newValues;
        }
    }

    public boolean isMemberFound(IEssMember essMember) {
        String name = null;
        if (this.runLocaleAiasTable == null) {
            name = this.essbaseAPI.getMemberName(essMember);
        } else {
            name = this.essbaseAPI.getAlias(essMember, this.runLocaleAiasTable);
            if (name == null) {
                name = this.essbaseAPI.getMemberName(essMember);
            }
        }
        return this.findIn(name);
    }

    public boolean findIn(String inputString) {
        String caption = inputString;
        if (this.searchCaseInsensitive) {
            caption = caption.toUpperCase();
        }
        boolean patternFound = false;
        for (String pattern : this.searchValues) {
            patternFound = false;
            if (this.searchCondition == MASearchCriteria.SearchCondition.EQUALS) {
                if (caption.equals(pattern)) {
                    patternFound = true;
                }
            } else if (this.searchCondition == MASearchCriteria.SearchCondition.STARTS_WITH) {
                if (caption.startsWith(pattern)) {
                    patternFound = true;
                }
            } else if (this.searchCondition == MASearchCriteria.SearchCondition.ENDS_WITH) {
                if (caption.endsWith(pattern)) {
                    patternFound = true;
                }
            } else if (this.searchCondition == MASearchCriteria.SearchCondition.CONTAINS && caption.contains(pattern)) {
                patternFound = true;
            }
            if (patternFound && this.searchOperation == MABlockConstraint.Operation.OR) {
                return true;
            }
            if (!patternFound && this.searchOperation == MABlockConstraint.Operation.AND) {
                return false;
            }
            if (this.searchOperation != MABlockConstraint.Operation.NOT_DEFINED) continue;
            return patternFound;
        }
        return patternFound;
    }
}

