/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseWrappers;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.essbase.api.datasource.IEssCube;
import com.essbase.api.metadata.IEssMemberSelection;
import java.util.HashMap;
import java.util.Map;

public class EssbaseMemberSelection {
    final int initialCapacity = 3;
    private Map<IEssMemberSelection, Boolean> mbrSelMap = new HashMap<IEssMemberSelection, Boolean>(3);
    private IEssCube essCube = null;
    private EssbaseWrappers essbaseAPI = null;
    private XQELogger logger = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"Essbase", (String)"Resources", (LogLevel)LogLevel.INFO);

    EssbaseMemberSelection(EssbaseWrappers theEssbaseAPI, IEssCube theEssCube) {
        this.essbaseAPI = theEssbaseAPI;
        this.essCube = theEssCube;
    }

    public IEssMemberSelection getMbrSelection() {
        if (!this.mbrSelMap.isEmpty()) {
            for (Map.Entry<IEssMemberSelection, Boolean> entry : this.mbrSelMap.entrySet()) {
                boolean isEntryAvailable = entry.getValue();
                if (!isEntryAvailable) continue;
                return entry.getKey();
            }
        }
        IEssMemberSelection essMbrSel = this.essbaseAPI.openMemberSelection(this.essCube);
        this.mbrSelMap.put(essMbrSel, Boolean.FALSE);
        if (this.logger.isOn()) {
            this.logger.log("Member selection object handler borrowed.");
        }
        return essMbrSel;
    }

    public void releaseMbrSelection(IEssMemberSelection mbrSel) {
        this.mbrSelMap.put(mbrSel, Boolean.TRUE);
        if (this.logger.isOn()) {
            this.logger.log("Member selection object handler released.");
        }
    }

    public void closeMbrSelection() {
        for (IEssMemberSelection essMbrSel : this.mbrSelMap.keySet()) {
            this.essbaseAPI.closeMbrSel(essMbrSel);
        }
        this.mbrSelMap.clear();
    }
}

