/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.data.providers.olap.essbase.EssbaseMessageKeys;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseRuntimeException;
import com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParser;
import com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParserException;
import java.util.ArrayList;

public final class EssbaseMetadataNames {
    public static final String OPEN_BRACKET = "[";
    public static final String CLOSE_BRACKET = "]";
    public static final String MUN_PART_SEPARATOR = "].[";

    private EssbaseMetadataNames() {
    }

    public static String createDimensionUniqueName(String dimensionName) {
        StringBuilder result = new StringBuilder();
        result.append(OPEN_BRACKET);
        result.append(dimensionName);
        result.append(CLOSE_BRACKET);
        return result.toString();
    }

    public static String createHierarchyUniqueName(String hierarchyName) {
        StringBuilder result = new StringBuilder();
        result.append(OPEN_BRACKET);
        result.append(hierarchyName);
        result.append(CLOSE_BRACKET);
        return result.toString();
    }

    public static String createLevelUniqueName(String dimensionName, String levelName) {
        StringBuilder result = new StringBuilder();
        result.append(OPEN_BRACKET);
        result.append(dimensionName);
        result.append(MUN_PART_SEPARATOR);
        result.append(levelName);
        result.append(CLOSE_BRACKET);
        return result.toString();
    }

    public static String[] parseUniqueName(String uniqueName) {
        if (uniqueName == null) {
            return null;
        }
        UniqueNameParser parser = new UniqueNameParser();
        try {
            return parser.parse(uniqueName);
        }
        catch (UniqueNameParserException e) {
            return null;
        }
    }

    private static char nextChar(String uniqueName, int index) {
        if (index >= uniqueName.length()) {
            return '\u0000';
        }
        return uniqueName.charAt(index++);
    }

    public static String[] parseAncestorNames(String inputStr) {
        ArrayList<String> names = new ArrayList<String>(10);
        char ch = EssbaseMetadataNames.nextChar(inputStr, 0);
        int chIndex = 1;
        while (ch != '\u0000' && ch <= ' ') {
            ch = EssbaseMetadataNames.nextChar(inputStr, chIndex);
            ++chIndex;
        }
        if (ch == '\u0000') {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_ANCESTOR_NAMES_STRING_1, inputStr);
        }
        if (ch != '\"') {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_ANCESTOR_NAMES_STRING_2, inputStr);
        }
        int start = 0;
        int end = 0;
        boolean newToken = true;
        while (ch != '\u0000') {
            if (newToken) {
                if (ch != '\"') {
                    throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_ANCESTOR_NAMES_STRING_3, inputStr);
                }
                end = start = chIndex;
                newToken = false;
            } else if (ch == '\"') {
                ch = EssbaseMetadataNames.nextChar(inputStr, chIndex);
                if (ch != '\u0000' && ch != ' ') {
                    ++end;
                } else {
                    String identifier = inputStr.substring(start, end);
                    names.add(0, identifier);
                    ++chIndex;
                    newToken = true;
                }
            } else {
                ++end;
            }
            ch = EssbaseMetadataNames.nextChar(inputStr, chIndex);
            ++chIndex;
        }
        if (!newToken) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_ANCESTOR_NAMES_STRING_4, inputStr);
        }
        return names.toArray(new String[0]);
    }
}

