/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.data.providers.olap.essbase.EssbaseConnection;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseSubstitutionVariable;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseWrappers;
import com.cognos.xqe.metadata.record.NamedSetRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.essbase.api.datasource.IEssCube;

public class EssbaseNamedSet
extends EssbaseSubstitutionVariable {
    private NamedSetRecord namedSetRecord = null;

    public EssbaseNamedSet(EssbaseConnection connection, String[] substVariable, String dimensionName) {
        super(substVariable);
        this.createNamedSetRecord(connection, dimensionName);
    }

    private void createNamedSetRecord(EssbaseConnection connection, String dimensionName) {
        this.namedSetRecord = new NamedSetRecord();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        IEssCube essCube = connection.getMetadataCache().getEssConnectionCube();
        String uniqueName = UniqueNameGenerator.createUniqueName((String)this.getSvName());
        this.namedSetRecord.setName(uniqueName);
        this.namedSetRecord.setUniqueName(uniqueName);
        this.namedSetRecord.setCaption(this.getSvName());
        this.namedSetRecord.setCatalogName(essbaseAPI.getCatalogName(essCube));
        this.namedSetRecord.setCubeName(essbaseAPI.getCubeName(essCube));
        this.namedSetRecord.setExpression(this.getSvValue());
        this.namedSetRecord.setUniqueId(RecordType.NAMEDSET, this.namedSetRecord.getUniqueName());
    }

    public void updateNamedSetIfRequired(String[] substVariable) {
        if (this.updateIfRequired(substVariable)) {
            this.namedSetRecord.setExpression(this.getSvValue());
        }
    }

    public void refreshCachedValue(EssbaseConnection connection) {
        this.refreshSVValue(connection);
        this.namedSetRecord.setExpression(this.getSvValue());
    }

    public NamedSetRecord getNamedSetRecord() {
        return this.namedSetRecord;
    }

    public String getExpression() {
        return this.getSvValue();
    }
}

