/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.data.providers.olap.essbase.EssbaseDimensionCacheItem;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseLocalizedString;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataNames;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.Map;

public class EssbasePropertyCacheItem {
    private static final String STR_PPDS_CODE = "PPDS_CODE";
    private static final String STR_MEMBER_NAME = "MEMBER_NAME";
    PropertyRecord cachedPropertyRecord = new PropertyRecord();
    boolean isBooleanType = false;

    public String getName() {
        if (this.cachedPropertyRecord == null) {
            return null;
        }
        return this.cachedPropertyRecord.getName();
    }

    public void setCacheProperty(String[] attributeInfo, EssbaseDimensionCacheItem dimension, EssbaseDimensionCacheItem attrDimension, LevelRecord levelRec) {
        String currentDimName = dimension.getName();
        String attrName = attributeInfo[0];
        this.cachedPropertyRecord.setName(attrName);
        String propertyUN = UniqueNameGenerator.createUniqueName((String)currentDimName, (String)attrName);
        this.cachedPropertyRecord.setUniqueName(propertyUN);
        this.cachedPropertyRecord.setUniqueId(RecordType.PROPERTY, this.cachedPropertyRecord.getUniqueName());
        if (levelRec != null) {
            String currentLevelName = levelRec.getName();
            String lun = EssbaseMetadataNames.createLevelUniqueName(currentDimName, currentLevelName);
            this.cachedPropertyRecord.setLevelUniqueName(lun);
        }
        this.cachedPropertyRecord.setCatalogName(dimension.getCatalogName());
        this.cachedPropertyRecord.setCubeName(dimension.getCubeName());
        this.cachedPropertyRecord.setDimensionUniqueName(dimension.getUniqueName());
        this.cachedPropertyRecord.setHierarchyUniqueName(dimension.getDefaultHierarchyUniqueName());
        String attrValueType = attributeInfo[2];
        if ("string".equals(attrValueType)) {
            this.cachedPropertyRecord.setDataType((IDataType)DataTypeFactory.getStringType());
        } else if ("double".equals(attrValueType)) {
            this.cachedPropertyRecord.setDataType((IDataType)DataTypeFactory.getDoubleType());
        } else if ("datetime".equals(attrValueType)) {
            this.cachedPropertyRecord.setDataType((IDataType)DataTypeFactory.getTimestampType());
        } else if ("boolean".equals(attrValueType)) {
            this.cachedPropertyRecord.setDataType((IDataType)DataTypeFactory.getIntegerType());
            this.isBooleanType = true;
        }
        this.cachedPropertyRecord.setDescription(attrDimension.getDescription());
    }

    public PropertyRecord createPropertyRecord(EssbaseDimensionCacheItem attrDimension, String levelUniqueName, Map<String, String> aliasTableNames, EssbaseLocalizedString localizedStringHelper) {
        PropertyRecord propertyRec = new PropertyRecord();
        propertyRec.setName(this.cachedPropertyRecord.getName());
        propertyRec.setUniqueName(this.cachedPropertyRecord.getUniqueName());
        propertyRec.setUniqueId(this.cachedPropertyRecord.getUniqueId());
        propertyRec.setLevelUniqueName(levelUniqueName);
        propertyRec.setCatalogName(this.cachedPropertyRecord.getCatalogName());
        propertyRec.setCubeName(this.cachedPropertyRecord.getCubeName());
        propertyRec.setDimensionUniqueName(this.cachedPropertyRecord.getDimensionUniqueName());
        propertyRec.setHierarchyUniqueName(this.cachedPropertyRecord.getHierarchyUniqueName());
        propertyRec.setDataType(this.cachedPropertyRecord.getDataType());
        propertyRec.setDescription(this.cachedPropertyRecord.getDescription());
        LocalizedString caption = attrDimension.getCaptions(null, aliasTableNames, localizedStringHelper);
        propertyRec.setCaption((ILocalizedString)caption);
        return propertyRec;
    }

    public PropertyRecord createPropertyRecord() {
        PropertyRecord propertyRec = new PropertyRecord();
        propertyRec.setName(this.cachedPropertyRecord.getName());
        if (this.isBooleanType) {
            propertyRec.setDataType((IDataType)DataTypeFactory.getBooleanType());
        } else {
            propertyRec.setDataType(this.cachedPropertyRecord.getDataType());
        }
        return propertyRec;
    }

    public static PropertyRecord getPropertyPPDSCode(String catalogName, String cubeName) {
        PropertyRecord propertyRec = new PropertyRecord();
        propertyRec.setCatalogName(catalogName);
        propertyRec.setCubeName(cubeName);
        propertyRec.setName(STR_PPDS_CODE);
        propertyRec.setCaption(STR_PPDS_CODE);
        propertyRec.setUniqueName(STR_PPDS_CODE);
        propertyRec.setDataType((IDataType)DataTypeFactory.getPPDSCodeType());
        propertyRec.setUniqueId(RecordType.PROPERTY, propertyRec.getUniqueName());
        propertyRec.setRoleType(RoleTypeEnum.PPDS_CODE);
        return propertyRec;
    }

    public static PropertyRecord getPropertyBusinessKey(String catalogName, String cubeName) {
        PropertyRecord propertyRec = new PropertyRecord();
        propertyRec.setCatalogName(catalogName);
        propertyRec.setCubeName(cubeName);
        propertyRec.setName("_businessKey");
        propertyRec.setCaption(STR_MEMBER_NAME);
        propertyRec.setUniqueName(STR_MEMBER_NAME);
        propertyRec.setDataType((IDataType)DataTypeFactory.getBusinessKeyType());
        propertyRec.setUniqueId(RecordType.PROPERTY, propertyRec.getUniqueName());
        propertyRec.setRoleType(RoleTypeEnum.BUSINESS_KEY);
        return propertyRec;
    }

    public static PropertyRecord getPropertyRollup(String catalogName, String cubeName) {
        PropertyRecord propertyRec = new PropertyRecord();
        propertyRec.setCatalogName(catalogName);
        propertyRec.setCubeName(cubeName);
        propertyRec.setName("_rollupType");
        propertyRec.setCaption("_rollupType");
        propertyRec.setUniqueName("_rollupType");
        propertyRec.setDataType((IDataType)DataTypeFactory.getMemberRollupType());
        propertyRec.setUniqueId(RecordType.PROPERTY, propertyRec.getUniqueName());
        propertyRec.setRoleType(RoleTypeEnum.MEMBER_ROLLUP);
        return propertyRec;
    }
}

