/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.data.providers.DataProviderBase;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseAxisIterator;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseCellIterator;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseConnection;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseDataProvider;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseFormatter;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMemberCacheKey;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMessageKeys;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseRuntimeException;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseWrappers;
import com.cognos.xqe.metadata.IAliasEntry;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.provider.Dimension;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.essbase.api.dataquery.IEssMdAxis;
import com.essbase.api.dataquery.IEssMdDataSet;
import com.essbase.api.dataquery.IEssMdMember;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EssbaseResultSet
extends ProviderResultSetBase
implements ICubeResultSet {
    private static final long serialVersionUID = 1L;
    static final String STR_GET_ALL_AXES = "getAllAxes";
    private final IEssMdAxis[] essmdAxes;
    private final IEssMdDataSet essmddata;
    private final IDimension[][] dimensions;
    private final ICube iCube;
    private final Map<EssbaseMemberCacheKey, Member> resultMemberCache = new HashMap<EssbaseMemberCacheKey, Member>();
    private IPooledConnection xqeConnection = null;
    private final EssbaseConnection essConnection;
    private final EssbaseWrappers essbaseAPI;
    private String aliasTableName = null;
    final EssbaseFormatter formatHelper;

    public EssbaseResultSet(EssbaseDataProvider provider, IPooledConnection theConnection, XDataContext xDataContext, MDXQueryArguments theQueryArguments, IEssMdDataSet inmddata) {
        super((DataProviderBase)provider, xDataContext, theQueryArguments.getRunLocale());
        this.essmddata = inmddata;
        this.essConnection = (EssbaseConnection)((Object)theConnection.getConnection());
        this.essbaseAPI = this.essConnection.getEssAPI();
        MDXQuery mdxQuery = theQueryArguments.getMDXQuery();
        this.iCube = mdxQuery.getReferencedCube();
        List aliasTable = mdxQuery.getAliasTable();
        if (aliasTable != null && !aliasTable.isEmpty()) {
            this.aliasTableName = ((IAliasEntry)aliasTable.get(0)).getValue();
        }
        this.essmdAxes = this.essbaseAPI.getAllAxes(inmddata);
        this.formatHelper = new EssbaseFormatter(this.essConnection, theQueryArguments.getRunLocale(), this.essmdAxes);
        this.dimensions = new IDimension[this.essmdAxes.length][];
        this.xqeConnection = theConnection;
    }

    public int getNumAxes() {
        int numAxes = 0;
        numAxes = this.isAxisSlicer(0) ? this.essmdAxes.length - 1 : this.essmdAxes.length;
        return numAxes;
    }

    public XIterator getAxisIterator(int axisNumber) {
        if (this.isAxisSlicer(0)) {
            ++axisNumber;
        }
        return new EssbaseAxisIterator(this, this.getDataContext(), this.iCube, axisNumber, this.nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITuple getSlicer() {
        ITuple result = null;
        int allAxes = this.getNumAxes();
        for (int i = 0; i < allAxes; ++i) {
            if (!this.isAxisSlicer(i)) continue;
            EssbaseAxisIterator it = new EssbaseAxisIterator(this, this.getDataContext(), this.iCube, i, this.nodeId);
            try {
                result = (ITuple)it.nextImpl();
                continue;
            }
            finally {
                it.release();
            }
        }
        return result;
    }

    public boolean isAxisSlicer(int axisno) {
        return this.essbaseAPI.isSlicerAxis(this.essmdAxes[axisno]);
    }

    public XCellIterator getCellIterator() {
        return new EssbaseCellIterator(this, this.getDataContext(), this.essmddata, this.formatHelper, this.nodeId);
    }

    public XScrollableIterator getScrollableAxisIterator(int axisNumber) {
        throw new UnsupportedOperationException();
    }

    public XScrollableCellIterator getScrollableCellIterator() {
        return new EssbaseCellIterator(this, this.getDataContext(), this.essmddata, this.formatHelper, this.nodeId);
    }

    public IDimension[] getDimensions(int axisNumber) {
        int nAxes = this.essmdAxes.length;
        if (this.isAxisSlicer(0)) {
            ++axisNumber;
        }
        if (axisNumber > nAxes - 1) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_AXIS_NUMBER);
        }
        if (null == this.dimensions[axisNumber]) {
            IEssMdAxis essAxis = this.essmdAxes[axisNumber];
            IEssMdMember[] dimensionMembers = this.essbaseAPI.getAllDimensions(essAxis);
            int count = dimensionMembers.length;
            this.dimensions[axisNumber] = new IDimension[count];
            for (int ii = 0; ii < count; ++ii) {
                IEssMdMember essmember = dimensionMembers[ii];
                Dimension dim = new Dimension(this.essbaseAPI.getMdMemberName(essmember));
                this.dimensions[axisNumber][ii] = dim;
            }
        }
        return this.dimensions[axisNumber];
    }

    public long getAxisSize(int axisNumber) {
        if (this.isAxisSlicer(0)) {
            ++axisNumber;
        }
        return this.essbaseAPI.getTupleCount(this.essmdAxes[axisNumber]);
    }

    public int getNumTabularMeasures() {
        return 0;
    }

    public int getNumDataItemForSummary(int rowsetId) {
        return 0;
    }

    public final EssbaseWrappers getEssAPI() {
        return this.essbaseAPI;
    }

    public final String getAliasTableName() {
        return this.aliasTableName;
    }

    public final IEssMdAxis[] getAxis() {
        return this.essmdAxes;
    }

    public final Map<EssbaseMemberCacheKey, Member> getResultMemberCache() {
        return this.resultMemberCache;
    }

    public final EssbaseConnection getConnection() {
        return this.essConnection;
    }

    public void releaseImpl() {
        try {
            if (null != this.xqeConnection) {
                this.xqeConnection.returnConnection();
                this.xqeConnection = null;
            }
            if (this.resultMemberCache != null) {
                this.resultMemberCache.clear();
            }
        }
        finally {
            super.releaseImpl();
        }
    }
}

