/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.ProviderException;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseUtil;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.essbase.api.base.EssException;

public final class EssbaseRuntimeException
extends ProviderException {
    private static final long serialVersionUID = 1L;

    public EssbaseRuntimeException(IMessageKey.Param0 messageKey) {
        super(messageKey);
        this.log();
    }

    public EssbaseRuntimeException(IMessageKey.Param1 messageKey, String firstArg) {
        super(messageKey, firstArg);
        this.log();
    }

    public EssbaseRuntimeException(IMessageKey.Param2 messageKey, String firstArg, String secondArg) {
        super(messageKey, firstArg, secondArg);
        this.log();
    }

    protected EssbaseRuntimeException(IMessageKey.Param0 messageKey, Throwable aCause) {
        super(messageKey, aCause);
        this.enhanceEssException(aCause);
        this.log();
    }

    protected EssbaseRuntimeException(IMessageKey.Param1 messageKey, Throwable aCause, String firstArg) {
        super(messageKey, aCause, firstArg);
        this.enhanceEssException(aCause);
        this.log();
    }

    protected EssbaseRuntimeException(IMessageKey.Param2 messageKey, Throwable aCause, String firstArg, String secondArg) {
        super(messageKey, aCause, (Object)firstArg, (Object)secondArg);
        this.enhanceEssException(aCause);
        this.log();
    }

    private void enhanceEssException(Throwable exception) {
        if (exception instanceof EssException) {
            EssException essException = (EssException)exception;
            String message = essException.getNativeMessage();
            String code = Integer.toString(essException.getNativeCode());
            if (EssbaseUtil.isEmpty(message) || code.equals("0")) {
                message = essException.getMessage();
                code = Integer.toString(essException.getCode());
            }
            StringBuilder buf = new StringBuilder("ESSBASE-");
            buf.append(code).append(" ").append(message).append(".");
            essException.setMessage(buf.toString());
        }
    }

    private void log() {
        XQELogger logger = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"Essbase", (String)"Metadata", (LogLevel)LogLevel.INFO);
        if (logger.isOn()) {
            logger.log((Throwable)((Object)this));
        }
    }
}

