/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.data.providers.olap.essbase.EssbaseConnection;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataCache;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseWrappers;
import com.essbase.api.datasource.IEssCube;
import com.essbase.api.datasource.IEssOlapApplication;

public class EssbaseSubstitutionVariable {
    public static final int NAMEINDEX = 0;
    public static final int VALUEINDEX = 1;
    public static final int APPLICATIONINDEX = 2;
    public static final int DATABASEINDEX = 3;
    private String applicationName = null;
    private String databaseName = null;
    private final String svName;
    private String svValue = null;

    public EssbaseSubstitutionVariable(String[] substVariable) {
        this.applicationName = substVariable[2];
        this.databaseName = substVariable[3];
        this.svName = substVariable[0];
        this.svValue = substVariable[1];
    }

    protected void updateSV(String[] substVariable) {
        this.applicationName = substVariable[2];
        this.databaseName = substVariable[3];
        this.svValue = substVariable[1];
    }

    protected String getSvName() {
        return this.svName;
    }

    protected String getSvValue() {
        return this.svValue;
    }

    protected void setSvValue(String value) {
        this.svValue = value;
    }

    public boolean updateIfRequired(String[] substVariable) {
        if (substVariable[2] == null) {
            return false;
        }
        if (substVariable[3] == null) {
            if (this.applicationName == null) {
                this.updateSV(substVariable);
                return true;
            }
            return false;
        }
        this.updateSV(substVariable);
        return true;
    }

    public void refreshSVValue(EssbaseConnection connection) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        IEssCube essCube = metadataCache.getEssConnectionCube();
        if (this.databaseName != null) {
            this.svValue = essbaseAPI.getCubeSubstitutionVariableValue(essCube, this.svName);
        } else if (this.applicationName != null) {
            IEssOlapApplication essCatalog = essbaseAPI.getApplication(essCube);
            this.svValue = essbaseAPI.getApplicationSubstitutionVariableValue(essCatalog, this.svName);
        } else {
            String[][] svList = essbaseAPI.getSubstitutionVariables(essCube);
            for (int svNo = 0; svNo < svList.length; ++svNo) {
                if (svList[svNo][2] != null || svList[svNo][3] != null || !this.svName.equals(svList[svNo][0])) continue;
                this.svValue = svList[svNo][1];
                break;
            }
        }
    }
}

