/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.odbo;

import com.cognos.xqe.data.olap.common.MSASCommonMemberTypes;
import com.cognos.xqe.data.providers.ProviderIteratorBase;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.odbo.ODBOConnection;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLog;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLogEnum;
import com.cognos.xqe.data.providers.olap.odbo.ODBOMessageKeys;
import com.cognos.xqe.data.providers.olap.odbo.ODBOResultSet;
import com.cognos.xqe.data.providers.olap.odbo.ODBORowset;
import com.cognos.xqe.data.providers.olap.odbo.ODBORuntimeException;
import com.cognos.xqe.data.providers.olap.odbo.concurrent.ODBOThreadContext;
import com.cognos.xqe.data.providers.secbridge.ErrorStatus;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.Tuple;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.context.ContextTransfer;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;

class ODBOAxisIterator
extends ProviderIteratorBase {
    ICube mCube = null;
    MetadataConnection metadataConnection = null;
    private static final String TUPLE_ORDINAL = "TUPLE_ORDINAL";
    String[] hierarchyUniqueNames;
    private static String[] stdPropertyNames = new String[]{"CAPTION", "CHILDREN_CARDINALITY", "DESCRIPTION", "DIMENSION_UNIQUE_NAME", "HIERARCHY_UNIQUE_NAME", "LEVEL_NUMBER", "LEVEL_UNIQUE_NAME", "MEMBER_CAPTION", "MEMBER_KEY", "MEMBER_NAME", "MEMBER_TYPE", "MEMBER_UNIQUE_NAME", "MEMBER_VALUE", "PARENT_COUNT", "PARENT_LEVEL", "PARENT_UNIQUE_NAME"};
    private static HashSet<String> stdPropertySet = new HashSet<String>(Arrays.asList(stdPropertyNames));
    private String[] columnPropertyNames;
    private ODBORowset iterator = null;
    private boolean mHasNext;
    private MDXQueryArguments.MDXAxisInfo axisInfo = null;
    protected ODBOConnection mODBOConnection;
    protected long startCacheIndex = -1L;
    protected long endCacheIndex = -1L;
    private static final int DEFAULT_CACHED_TUPLES = 100;
    protected int maxCachedTuples = 100;
    protected ArrayList<ITuple> cachedTuples;
    protected IHierarchy currentHierarchy;
    private boolean forceRollupToComputed = false;

    ODBOAxisIterator(ODBOResultSet resultSet, XDataContext xDataContext, ICube cube, ODBORowset rowset, Integer nodeId, int edgeO, ODBOConnection connection) {
        super((ProviderResultSetBase)resultSet, xDataContext, nodeId);
        super.setEdgeNumber(edgeO);
        this.mODBOConnection = connection;
        this.metadataConnection = cube.getConnection();
        try {
            this.nativeInitialize(rowset);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error constructing an axis iterator: ").append(status);
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
            }
            this.mODBOConnection.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
        this.axisInfo = this.getODBOResultSet().getQueryArguments().getMDXAxisInfo(this.getEdgeNumber());
        if (null == this.axisInfo) {
            this.mCube = cube;
        }
        this.cachedTuples = new ArrayList(this.maxCachedTuples);
        if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY)) {
            ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log("Constructing axis iterator.");
        }
    }

    private void initializeAxisIterator(ODBORowset rowset) {
        this.iterator = rowset;
        boolean bl = this.mHasNext = this.iterator.getColumnCount() > 0;
        if (this.mHasNext) {
            this.mHasNext = this.iterator.getNextRow();
        }
    }

    private void nativeInitialize(final ODBORowset rowset) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Object> task = new Callable<Object>(){

                @Override
                public Object call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        ODBOAxisIterator.this.initializeAxisIterator(rowset);
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                    return null;
                }
            };
            this.mODBOConnection.invokeNativeCall(task);
        } else {
            this.initializeAxisIterator(rowset);
        }
    }

    private void getHUNs() {
        if (this.hierarchyUniqueNames == null) {
            if (null != this.axisInfo) {
                this.getHUNsFromAxisInfo();
            } else {
                this.getHUNsFromOLEDB();
            }
        }
    }

    private void getHUNsFromOLEDB() {
        ArrayList<String> oldResult = new ArrayList<String>();
        HashSet<String> alreadySeen = new HashSet<String>();
        int oldColumnCount = this.iterator.getColumnCount();
        this.columnPropertyNames = new String[oldColumnCount];
        for (int i = 0; i < oldColumnCount; ++i) {
            String columnName = this.iterator.getColumnName(i);
            if (columnName == null || columnName.trim().length() <= 0 || columnName.startsWith(TUPLE_ORDINAL)) continue;
            try {
                String dimName;
                String[] parts = UniqueNameParser.parse((String)columnName);
                String columnPropertyName = parts[parts.length - 1];
                this.columnPropertyNames[i] = stdPropertySet.contains(columnPropertyName) ? columnPropertyName : columnName;
                if (!columnPropertyName.equals("LEVEL_UNIQUE_NAME") || (dimName = this.iterator.getColumnValue(i, true).getString()) == null || alreadySeen.contains(dimName = dimName.substring(0, dimName.lastIndexOf(46)))) continue;
                oldResult.add(dimName);
                alreadySeen.add(dimName);
                continue;
            }
            catch (UniqueNameParserException e) {
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log("Error parsing column name " + columnName);
                }
                throw new ODBORuntimeException(ODBOMessageKeys.RES_UNPARSEABLE_RESULTSET_COLUMN_NAME, columnName);
            }
        }
        this.hierarchyUniqueNames = oldResult.toArray(new String[0]);
    }

    private void getHUNsFromAxisInfo() {
        List infoList = this.axisInfo.getProjectedHierarchies();
        ArrayList<String> result = new ArrayList<String>(infoList.size());
        for (MDXQueryArguments.MDXHierarchyInfo currInfo : infoList) {
            result.add(currInfo.getHierarchy().getUniqueName());
        }
        int columnCount = this.iterator.getColumnCount();
        this.columnPropertyNames = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            String columnName = this.iterator.getColumnName(i);
            if (columnName == null || columnName.trim().length() <= 0 || columnName.startsWith(TUPLE_ORDINAL)) continue;
            try {
                String[] parts = UniqueNameParser.parse((String)columnName);
                String columnPropertyName = parts[parts.length - 1];
                if (stdPropertySet.contains(columnPropertyName)) {
                    this.columnPropertyNames[i] = columnPropertyName;
                    continue;
                }
                this.columnPropertyNames[i] = columnName;
                continue;
            }
            catch (UniqueNameParserException e) {
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log("Error parsing column " + columnName);
                }
                throw new ODBORuntimeException(ODBOMessageKeys.RES_UNPARSEABLE_RESULTSET_COLUMN_NAME, columnName);
            }
        }
        this.hierarchyUniqueNames = result.toArray(new String[0]);
    }

    private ILevel determineLevel(int hierIndex, IntegerValue levelNumberInt) {
        String hierarchyUniqueName = this.hierarchyUniqueNames[hierIndex];
        if (this.currentHierarchy == null || !this.currentHierarchy.getUniqueName().equals(hierarchyUniqueName)) {
            this.currentHierarchy = this.getProjectedHierarchy(hierIndex);
        }
        if (this.currentHierarchy == null) {
            if (ODBOLog.isOn(ODBOLogEnum.LOG_EXCEPTION_LOGGER, LogLevel.ERROR)) {
                ODBOLog.getLogger(ODBOLogEnum.LOG_EXCEPTION_LOGGER).log(LogLevel.ERROR, "Unable to locate hierarchy " + hierarchyUniqueName);
            }
            throw new ODBORuntimeException(ODBOMessageKeys.RES_CANT_LOCATE_HIERARCHY, hierarchyUniqueName, Integer.toString(this.getEdgeNumber()));
        }
        int levelNumber = 0;
        if (levelNumberInt != null) {
            levelNumber = levelNumberInt.getInteger();
        }
        ILevel level = this.currentHierarchy.getLevel(levelNumber);
        if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY)) {
            ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log("Level " + level.getUniqueName() + " found in hierarchy " + hierarchyUniqueName + " at level number " + levelNumberInt);
        }
        return level;
    }

    public Object nextImpl() {
        if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY)) {
            ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log("NextImpl called on axis iterator.");
        }
        ITuple result = null;
        try {
            if (this.startCacheIndex == -1L || this.currentIndex >= this.endCacheIndex) {
                this.nativeCacheTuples();
            }
            result = this.getTupleFromCache(this.currentIndex);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error calling axis iterator nextImpl: ").append(status);
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
            }
            this.mODBOConnection.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
        if (result != null) {
            ++this.currentIndex;
        }
        return result;
    }

    private ITuple getTupleFromCache(long currentIndex) {
        long cachePos = currentIndex - this.startCacheIndex + 1L;
        if (!this.cachedTuples.isEmpty()) {
            return this.cachedTuples.get((int)cachePos);
        }
        return null;
    }

    private void nativeCacheTuples() throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Object> task = new Callable<Object>(){

                @Override
                public Object call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        ODBOAxisIterator.this.internalCacheTuples();
                        Object var1_1 = null;
                        return var1_1;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            this.mODBOConnection.invokeNativeCall(task);
        } else {
            this.internalCacheTuples();
        }
    }

    private void internalCacheTuples() {
        ITuple tuple;
        this.cachedTuples.clear();
        this.startCacheIndex = this.endCacheIndex + 1L;
        for (int idx = 0; idx < this.maxCachedTuples && (tuple = this.getOneTuple()) != null; ++idx) {
            this.cachedTuples.add(tuple);
            ++this.endCacheIndex;
        }
    }

    protected ITuple getOneTuple() {
        Tuple result = null;
        if (!this.mHasNext) {
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY)) {
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log("No next item found.");
            }
            return result;
        }
        this.getHUNs();
        int dimCount = this.hierarchyUniqueNames.length;
        IMember[] tuple = new IMember[dimCount];
        int hierIndex = 0;
        Member currentMember = null;
        boolean buildCurrentMember = false;
        boolean setMemberLevel = false;
        int columnCount = this.iterator.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            String columnName = this.iterator.getColumnName(i);
            if (columnName == null || columnName.length() <= 0 || columnName.startsWith(TUPLE_ORDINAL)) continue;
            if (columnName.indexOf("MEMBER_UNIQUE_NAME") >= 0) {
                String currentMUN = this.iterator.getStringColumn(i, true);
                currentMember = this.getODBOResultSet().getCachedMember(currentMUN);
                if (currentMember == null) {
                    buildCurrentMember = true;
                    setMemberLevel = true;
                    currentMember = new Member();
                    currentMember.setUniqueName(currentMUN);
                    currentMember.setConnection(this.metadataConnection);
                    currentMember.setInitialised();
                    this.getODBOResultSet().putCachedMember(currentMUN, currentMember);
                } else {
                    buildCurrentMember = false;
                }
                if (currentMUN.indexOf(this.hierarchyUniqueNames[hierIndex]) < 0) {
                    ++hierIndex;
                }
                if (tuple[hierIndex] != null) continue;
                tuple[hierIndex] = currentMember;
                continue;
            }
            if (!buildCurrentMember) continue;
            String propertyName = this.columnPropertyNames[i];
            Value propertyValue = this.iterator.getColumnValue(i, true);
            if (ODBOLog.isOn()) {
                ODBOLog.getLogger().log(" Member info " + propertyName + " " + propertyValue);
            }
            if (propertyName.equals("MEMBER_CAPTION")) {
                currentMember.setName(propertyValue.getString());
                currentMember.setCaption(propertyValue.getString());
                continue;
            }
            if (propertyName.equals("PARENT_UNIQUE_NAME")) {
                if (propertyValue == null) continue;
                currentMember.setParentUniqueName(propertyValue.getString());
                continue;
            }
            if (propertyName.equals("LEVEL_NUMBER")) {
                ILevel level;
                if (!setMemberLevel || (level = this.determineLevel(hierIndex, (IntegerValue)propertyValue)) == null) continue;
                setMemberLevel = false;
                currentMember.setLevel(level);
                continue;
            }
            if (propertyName.equals("PARENT_LEVEL")) {
                currentMember.setParentLevelNumber(((IntegerValue)propertyValue).getInteger());
                continue;
            }
            if (propertyName.equals("KEY") || propertyName.equals("MEMBER_KEY")) {
                currentMember.setBusinessKey(propertyValue);
                currentMember.setProperty("MEMBER_KEY", (Object)propertyValue);
                continue;
            }
            if (propertyName.equals("MEMBER_TYPE")) {
                IntegerValue intValue = (IntegerValue)propertyValue;
                currentMember.setType(MSASCommonMemberTypes.convertIntToMemberType((int)intValue.getInteger()));
                continue;
            }
            currentMember.setProperty(propertyName, (Object)propertyValue);
        }
        if (buildCurrentMember) {
            if (this.forceRollupToComputed) {
                currentMember.setRollupType(RollupTypeEnum.COMPUTED);
            } else {
                IHierarchy hier = this.getProjectedHierarchy(hierIndex);
                if (hier == null) {
                    if (ODBOLog.isOn(ODBOLogEnum.LOG_EXCEPTION_LOGGER, LogLevel.ERROR)) {
                        ODBOLog.getLogger(ODBOLogEnum.LOG_EXCEPTION_LOGGER).log(LogLevel.ERROR, "Unable to find hierarchy " + this.hierarchyUniqueNames[hierIndex]);
                    }
                    throw new ODBORuntimeException(ODBOMessageKeys.RES_CANT_LOCATE_HIERARCHY, this.hierarchyUniqueNames[hierIndex], Integer.toString(this.getEdgeNumber()));
                }
                IDimension dim = hier.getDimension();
                DimensionTypeEnum dimType = dim.getType();
                if (dimType == DimensionTypeEnum.ACCOUNT || dimType == DimensionTypeEnum.SCENARIO) {
                    currentMember.setRollupType(RollupTypeEnum.COMPUTED);
                } else {
                    currentMember.setRollupType(RollupTypeEnum.ROLLUP);
                }
            }
        }
        result = new Tuple(tuple, false);
        if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY)) {
            ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log("Retrieved tuple[" + hierIndex + "]=" + result.toString());
        }
        this.mHasNext = this.iterator.getNextRow();
        return result;
    }

    private IHierarchy getProjectedHierarchy(int hierIndex) {
        MDXQueryArguments.MDXHierarchyInfo hierInfo;
        IHierarchy hier = null != this.axisInfo ? (null != (hierInfo = this.axisInfo.getMDXHierarchyInfo(hierIndex)) ? hierInfo.getHierarchy() : this.mCube.getHierarchy(this.hierarchyUniqueNames[hierIndex])) : this.mCube.getHierarchy(this.hierarchyUniqueNames[hierIndex]);
        return hier;
    }

    public void releaseImpl() {
        try {
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY)) {
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log("Release called on AxisIterator.");
            }
            if (null != this.iterator) {
                this.iterator.close();
            }
        }
        catch (Exception e) {
            if (ODBOLog.isOn(LogLevel.ERROR)) {
                ODBOLog.getLogger().log(LogLevel.ERROR, (Throwable)e);
            }
        }
        finally {
            this.iterator = null;
            this.mODBOConnection = null;
            this.cachedTuples.clear();
            this.cachedTuples = null;
        }
    }

    private ODBOResultSet getODBOResultSet() {
        return (ODBOResultSet)this.getResultSet();
    }
}

