/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.odbo;

import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.olap.odbo.ODBOConfiguration;
import org.apache.commons.lang.builder.ToStringBuilder;

public class ODBOCapabilities {
    private static final String FAKE_MEMBER_KEY = "olap.metadata.fakeMemberKey";
    private static final String FORCE_PARENT_CHILD_TO_UNBALANCED = "olap.metadata.forceParentChildToUnbalanced";
    private static final String FORCE_RAGGED_TO_UNBALANCED = "olap.metadata.forceRaggedToUnbalanced";
    private static final String DETERMINE_PARENT_CHILD_BY_LEVEL_NAMES = "olap.metadata.determineParentChildByLevelNames";
    private static final String USE_MUNS_FOR_ACTION_RESTRICTIONS = "olap.metadata.useMUNsForActionRestrictions";
    private static final String APPLY_NEW_RANK_TO_HIERARCHIES = "olap.metadata.applyNewRankToHierarchies";
    private static final String SUPPORT_CURRENCY_UNITS = "olap.data.supportCurrencyUnits";
    public static final String SUPPORT_CASE_INSENSITIVE_CATALOG = "olap.metadata.caseInsensitiveCatalog";
    public static final String DISABLE_DIM_FOR_PROPERTIES = "olap.metadata.disableDimForProperties";
    public static final String SUPPORTS_TRUSTED_CONNECTIONS = "olap.connection.supportsTrustedConnections";
    public static final String SUPPORTS_CAM_AUTHENTICATION = "olap.connection.supportsCAMAuthentication";
    public static final String SUPPORTS_USER_IMPERSONATE = "olap.connection.supportsUserImpersonate";
    private static final String USE_TABULAR_FORMATTER = "olap.data.useTabularFormatter";
    private static final String SKIP_VALIDATE_VERSIONS = "olap.connection.skipValidateVersions";
    private boolean fakeMemberKey = false;
    private boolean forceParentChildToUnbalanced = false;
    private boolean forceRaggedToUnbalanced = false;
    private boolean determineParentChildByLevelNames = true;
    private boolean useMUNsForActionRestrictions = true;
    private boolean applyNewRankToHierarchies = false;
    private boolean supportCurrencyUnits = false;
    private boolean caseInsensitiveCatalog = false;
    private boolean disableDimForProperties = false;
    private boolean supportTrustedConnections = true;
    private boolean supportCAMAuthentication = true;
    private boolean supportUserImpersonate = true;
    private boolean useTabularFormtter = true;
    private boolean skipValidateVersion = false;

    public final boolean canFakeMemberKey() {
        return this.fakeMemberKey;
    }

    public final boolean canForceParentChildToUnbalanced() {
        return this.forceParentChildToUnbalanced;
    }

    public final boolean canForceRaggedToUnbalanced() {
        return this.forceRaggedToUnbalanced;
    }

    public final boolean canDetermineParentChildByLevelNames() {
        return this.determineParentChildByLevelNames;
    }

    public final boolean canUseMUNsForActionRestrictions() {
        return this.useMUNsForActionRestrictions;
    }

    public final boolean canApplyNewRankToHierarchies() {
        return this.applyNewRankToHierarchies;
    }

    public final boolean canSupportCurrencyUnits() {
        return this.supportCurrencyUnits;
    }

    public final boolean canSupportCaseInsensitiveCatalog() {
        return this.caseInsensitiveCatalog;
    }

    public final boolean canUseTabularFormtter() {
        return this.useTabularFormtter;
    }

    public final boolean canSkipValidateVersion() {
        return this.skipValidateVersion;
    }

    public final void setFakeMemberKey(boolean canFakeMemberKey) {
        this.fakeMemberKey = canFakeMemberKey;
    }

    public final void setUseMUNsForActionRestrictions(boolean canUseMUNsForActionRestrictions) {
        this.useMUNsForActionRestrictions = canUseMUNsForActionRestrictions;
    }

    public final void setApplyNewRankToHierarchies(boolean canApplyNewRankToHierarchies) {
        this.applyNewRankToHierarchies = canApplyNewRankToHierarchies;
    }

    public final void setForceParentChildToUnbalanced(boolean canForceParentChildToUnbalanced) {
        this.forceParentChildToUnbalanced = canForceParentChildToUnbalanced;
    }

    public final void setForceRaggedToUnbalanced(boolean canForceRaggedToUnbalanced) {
        this.forceRaggedToUnbalanced = canForceRaggedToUnbalanced;
    }

    public final void setDetermineParentChildByLevelNames(boolean canDetermineParentChildByLevelNames) {
        this.determineParentChildByLevelNames = canDetermineParentChildByLevelNames;
    }

    public final void setSupportCurrencyUnits(boolean canSupportCurrencyUnits) {
        this.supportCurrencyUnits = canSupportCurrencyUnits;
    }

    public final void setDisableDimForProperties(boolean canDisableDimForProperties) {
        this.disableDimForProperties = canDisableDimForProperties;
    }

    public final void setSupportTrustedConnections(boolean canSupportTrustedConnections) {
        this.supportTrustedConnections = canSupportTrustedConnections;
    }

    public final void setSupportCAMAuthentication(boolean canSupportCAMAuthentication) {
        this.supportCAMAuthentication = canSupportCAMAuthentication;
    }

    public final void setSupportUserImpersonate(boolean canSupportUserImpersonate) {
        this.supportUserImpersonate = canSupportUserImpersonate;
    }

    public final void setSupportCaseInsensitiveCatalog(boolean canSupportCaseInsensitiveCatalog) {
        this.caseInsensitiveCatalog = canSupportCaseInsensitiveCatalog;
    }

    public final void setUseTabularFormtter(boolean canUseTabularFormtter) {
        this.useTabularFormtter = canUseTabularFormtter;
    }

    public final void setSkipValidateVersion(boolean canSkipValidateVersion) {
        this.skipValidateVersion = canSkipValidateVersion;
    }

    public boolean canDisableDimForProperties() {
        return this.disableDimForProperties;
    }

    public boolean canSupportTrustedConnections() {
        return this.supportTrustedConnections;
    }

    public boolean canSupportCAMAuthentication() {
        return this.supportCAMAuthentication;
    }

    public boolean canSupportUserImpersonate() {
        return this.supportUserImpersonate;
    }

    public void initializeFrom(IDataSourceCapabilities dataSourceCapabilities) {
        this.setFakeMemberKey(dataSourceCapabilities.isSupported(FAKE_MEMBER_KEY));
        this.setForceParentChildToUnbalanced(dataSourceCapabilities.isSupported(FORCE_PARENT_CHILD_TO_UNBALANCED));
        this.setForceRaggedToUnbalanced(dataSourceCapabilities.isSupported(FORCE_RAGGED_TO_UNBALANCED));
        this.setDetermineParentChildByLevelNames(dataSourceCapabilities.isSupported(DETERMINE_PARENT_CHILD_BY_LEVEL_NAMES));
        this.setUseMUNsForActionRestrictions(dataSourceCapabilities.isSupported(USE_MUNS_FOR_ACTION_RESTRICTIONS));
        this.setApplyNewRankToHierarchies(dataSourceCapabilities.isSupported(APPLY_NEW_RANK_TO_HIERARCHIES));
        this.setSupportCurrencyUnits(dataSourceCapabilities.isSupported(SUPPORT_CURRENCY_UNITS));
        this.setSupportCaseInsensitiveCatalog(dataSourceCapabilities.isSupported(SUPPORT_CASE_INSENSITIVE_CATALOG));
        this.setDisableDimForProperties(dataSourceCapabilities.isSupported(DISABLE_DIM_FOR_PROPERTIES));
        this.setSupportTrustedConnections(dataSourceCapabilities.isSupported(SUPPORTS_TRUSTED_CONNECTIONS));
        this.setSupportCAMAuthentication(dataSourceCapabilities.isSupported(SUPPORTS_CAM_AUTHENTICATION));
        this.setSupportUserImpersonate(dataSourceCapabilities.isSupported(SUPPORTS_USER_IMPERSONATE));
        this.setUseTabularFormtter(dataSourceCapabilities.isSupported(USE_TABULAR_FORMATTER));
        this.setSkipValidateVersion(dataSourceCapabilities.isSupported(SKIP_VALIDATE_VERSIONS));
    }

    public ODBOConfiguration toConfiguration() {
        ODBOConfiguration result = new ODBOConfiguration();
        result.addProperty(FAKE_MEMBER_KEY, this.canFakeMemberKey());
        result.addProperty(FORCE_PARENT_CHILD_TO_UNBALANCED, this.canForceParentChildToUnbalanced());
        result.addProperty(FORCE_RAGGED_TO_UNBALANCED, this.canForceRaggedToUnbalanced());
        result.addProperty(DETERMINE_PARENT_CHILD_BY_LEVEL_NAMES, this.canDetermineParentChildByLevelNames());
        result.addProperty(USE_MUNS_FOR_ACTION_RESTRICTIONS, this.canUseMUNsForActionRestrictions());
        result.addProperty(APPLY_NEW_RANK_TO_HIERARCHIES, this.canApplyNewRankToHierarchies());
        result.addProperty(SUPPORT_CURRENCY_UNITS, this.canSupportCurrencyUnits());
        result.addProperty(SUPPORT_CASE_INSENSITIVE_CATALOG, this.canSupportCaseInsensitiveCatalog());
        result.addProperty(DISABLE_DIM_FOR_PROPERTIES, this.canDisableDimForProperties());
        result.addProperty(SUPPORTS_TRUSTED_CONNECTIONS, this.canSupportTrustedConnections());
        result.addProperty(SUPPORTS_CAM_AUTHENTICATION, this.canSupportCAMAuthentication());
        result.addProperty(SUPPORTS_USER_IMPERSONATE, this.canSupportUserImpersonate());
        result.addProperty(USE_TABULAR_FORMATTER, this.canUseTabularFormtter());
        result.addProperty(SKIP_VALIDATE_VERSIONS, this.canSkipValidateVersion());
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

