/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.odbo;

import com.cognos.xqe.data.olap.common.MSASCommonFormatInfo;
import com.cognos.xqe.data.olap.common.MSASTypeGroupEnum;
import com.cognos.xqe.data.providers.ProviderCellBase;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLog;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLogEnum;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.string.IFormatInfo;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.Locale;

public class ODBOCell
extends ProviderCellBase {
    public static final String VALUE = "VALUE";
    public static final String CELL_ORDINAL = "CELL_ORDINAL";
    public static final String FORMAT_STRING = "FORMAT_STRING";
    public static final String LANGUAGE = "LANGUAGE";
    private final Locale formatLocale;
    private String formatString;
    private int language;
    private boolean useTabularFormatter = false;

    public ODBOCell(Locale theFormatLocale) {
        this.formatLocale = theFormatLocale;
        this.ordinal = -1L;
        this.language = 0;
    }

    public ODBOCell(Locale theFormatLocale, boolean needUseTabularFormatter) {
        this.formatLocale = theFormatLocale;
        this.ordinal = -1L;
        this.language = 0;
        this.useTabularFormatter = needUseTabularFormatter;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public int getLanguage() {
        return this.language;
    }

    public boolean getUseTabularFormatter() {
        return this.useTabularFormatter;
    }

    public void copyFrom(IValue arg0) {
        if (arg0 instanceof ODBOCell) {
            super.copyFrom(arg0);
            ODBOCell copyMe = (ODBOCell)arg0;
            this.formatString = copyMe.formatString;
            this.language = copyMe.language;
            this.useTabularFormatter = copyMe.useTabularFormatter;
        } else {
            this.value = arg0;
        }
    }

    public Object copy() {
        ODBOCell result = new ODBOCell(this.formatLocale);
        result.copyFrom((IValue)this);
        return result;
    }

    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("Cell", -1);
        xmlWriter.attribute("CellOrdinal", (Object)new Long(this.ordinal));
        if (this.formatString != null && !this.formatString.isEmpty()) {
            xmlWriter.attribute("formatType", "MSAS");
            xmlWriter.attribute("formatString", this.formatString);
            xmlWriter.attribute("formatLocale", (Object)this.formatLocale);
            xmlWriter.attribute("language", this.language);
        }
        if (this.value != null) {
            this.value.toXML(xmlWriter);
        }
        xmlWriter.endElement();
    }

    public void convertFormat(MSASTypeGroupEnum typeGroup, boolean includeCurrencyUnit, String unknownCurr) {
        if (!this.useTabularFormatter) {
            if (this.formatString == null) {
                ((Value)this.getValue()).setFormatId(FormatId.EMPTY_FORMAT_FID);
            } else {
                MSASCommonFormatInfo info = new MSASCommonFormatInfo(typeGroup, includeCurrencyUnit, unknownCurr, this.getFormatString(), this.getLanguage());
                FormatId id = FormatService.getInstance().registerMSASFormat((IFormatInfo)info, this.formatLocale);
                ((Value)this.getValue()).setFormatId(id);
            }
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY)) {
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log("Converting MSAS format " + this.formatString + " to internal format.");
            }
        }
    }

    public void release() {
        super.release();
        this.formatString = null;
        this.language = 0;
    }

    public void setFormatString(String formatStringValue) {
        this.formatString = formatStringValue;
    }

    public void setLanguage(int languageValue) {
        this.language = languageValue;
    }

    public void setUseTabularFormatter(boolean needUseTabularFormatter) {
        this.useTabularFormatter = needUseTabularFormatter;
    }
}

