/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.odbo;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLogEnum;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQELoggerCppJni;

public class ODBOLog {
    private static final LogLevel ODBO_DEFAULT_LOG_LEVEL = LogLevel.INFO;
    private static final XQELogger CANCEL_LOGGER = ODBOLog.getODBOLogger("Cancel");
    private static final XQELogger METADATA_LOGGER = ODBOLog.getODBOLogger("Metadata");
    private static final XQELogger METADATA_CACHE_LOGGER = ODBOLog.getODBOLogger("Metadata.Cache");
    private static final XQELogger EXCEPTION_LOGGER = ODBOLog.getODBOLogger("Exception");
    private static final XQELogger DATA_QUERY_LOGGER = ODBOLog.getODBOLogger("DataQuery");
    private static final XQELogger CONFIGURATION_LOGGER = ODBOLog.getODBOLogger("Configuration");
    private static final XQELogger CONNECTION_LOGGER = ODBOLog.getODBOLogger("Connection");
    public static final String ODBO_DEV_EVENT_GROUP = "ODBODevEvent";
    public static final String ODBO_BINDING_GROUP = "ODBOBinding";
    public static final String ODBO_JNI_GROUP = "JNI";

    public static XQELogger getLogger(String eventGroup) {
        if (eventGroup.equals("Metadata")) {
            return METADATA_LOGGER;
        }
        if (eventGroup.equals("DataQuery")) {
            return DATA_QUERY_LOGGER;
        }
        if (eventGroup.equals("Configuration")) {
            return CONFIGURATION_LOGGER;
        }
        if (eventGroup.equals("Connection")) {
            return CONNECTION_LOGGER;
        }
        if (eventGroup.equals("Metadata.Cache")) {
            return METADATA_CACHE_LOGGER;
        }
        if (eventGroup.equals("Exception")) {
            return EXCEPTION_LOGGER;
        }
        return ODBOLog.getODBOLogger(eventGroup);
    }

    public static XQELogger getLogger(ODBOLogEnum logger) {
        switch (logger) {
            case LOG_PROVIDER_METADATA: {
                return METADATA_LOGGER;
            }
            case LOG_PROVIDER_DATA_QUERY: {
                return DATA_QUERY_LOGGER;
            }
            case LOG_CONFIGURATION: {
                return CONFIGURATION_LOGGER;
            }
            case LOG_CONNECTION: {
                return CONNECTION_LOGGER;
            }
            case LOG_PROVIDER_METADATA_CACHE: {
                return METADATA_CACHE_LOGGER;
            }
            case LOG_EXCEPTION_LOGGER: {
                return EXCEPTION_LOGGER;
            }
            case LOG_INIT_TERM: {
                return ODBOLog.getODBOLogger("InitTerm");
            }
            case LOG_RESOURCES: {
                return ODBOLog.getODBOLogger("Resources");
            }
            case LOG_PROVIDER_DATA_QUERY_RESULTSET: {
                return ODBOLog.getODBOLogger("DataQuery.ResultSet");
            }
            case LOG_PROVIDER_CANCEL: {
                return CANCEL_LOGGER;
            }
        }
        return null;
    }

    private static XQELogger getODBOLogger(String eventGroup) {
        return XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"ODBO", (String)eventGroup, (LogLevel)ODBO_DEFAULT_LOG_LEVEL);
    }

    public static void enableCppLogger(String eventGroup) {
        XQELogger logger = ODBOLog.getLogger(eventGroup);
        XQELoggerCppJni.enableLogger((XQELogger)logger);
    }

    public static boolean isOn(ODBOLogEnum logger, LogLevel logLevel) {
        return ODBOLog.getLogger(logger).isOn(logLevel);
    }

    public static boolean isOn(String eventGroup, LogLevel logLevel) {
        return ODBOLog.getLogger(eventGroup).isOn(logLevel);
    }

    public static boolean isOn(String eventGroup) {
        return ODBOLog.getLogger(eventGroup).isOn();
    }

    public static boolean isOn(ODBOLogEnum logger) {
        return ODBOLog.getLogger(logger).isOn();
    }

    public static XQELogger getLogger() {
        return ODBOLog.getLogger(ODBO_DEV_EVENT_GROUP);
    }

    public static boolean isOn() {
        return ODBOLog.getLogger(ODBO_DEV_EVENT_GROUP).isOn();
    }

    public static boolean isOn(LogLevel logLevel) {
        return ODBOLog.getLogger(ODBO_DEV_EVENT_GROUP).isOn(logLevel);
    }
}

