/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.odbo;

import com.cognos.xqe.data.providers.DataProviderBase;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.connection.parameters.ProviderTypeParameter;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.odbo.ODBOAxisIterator;
import com.cognos.xqe.data.providers.olap.odbo.ODBOCellIterator;
import com.cognos.xqe.data.providers.olap.odbo.ODBOCellset;
import com.cognos.xqe.data.providers.olap.odbo.ODBOConfig;
import com.cognos.xqe.data.providers.olap.odbo.ODBOConfigManager;
import com.cognos.xqe.data.providers.olap.odbo.ODBOConnection;
import com.cognos.xqe.data.providers.olap.odbo.ODBODataProvider;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLog;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLogEnum;
import com.cognos.xqe.data.providers.olap.odbo.ODBOMessageKeys;
import com.cognos.xqe.data.providers.olap.odbo.ODBORowset;
import com.cognos.xqe.data.providers.olap.odbo.ODBORuntimeException;
import com.cognos.xqe.data.providers.olap.odbo.concurrent.ODBOThreadContext;
import com.cognos.xqe.data.providers.secbridge.ErrorStatus;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.context.ContextTransfer;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public class ODBOResultSet
extends ProviderResultSetBase
implements ICubeResultSet {
    private static final long serialVersionUID = 1L;
    private static final String COLON_SPACE = ": ";
    public static final int BIND_NOTHING = 0;
    public static final int BIND_TUPLE_ORDINAL = 1;
    public static final int BIND_MUN = 2;
    public static final int BIND_CAPTION = 4;
    public static final int BIND_LUN = 8;
    public static final int BIND_LEVEL_NUMBER = 16;
    public static final int BIND_DISPLAY_INFO = 32;
    public static final int BIND_DEFAULT = 30;
    private final ICube mCube;
    private long mResultSetHandle = 0L;
    protected final ODBOConnection mODBOConnection;
    protected boolean mManagesConnection = false;
    private IDimension[][] dimensions = null;
    private int numAxesWithoutSlicer = 0;
    private Map<String, Member> memberCache = new HashMap<String, Member>();
    private boolean bCancelled = false;
    private MDXQueryArguments mQueryArguments = null;

    public ODBOResultSet(ODBODataProvider provider, ODBOConnection connection, XDataContext xDataContext, MDXQueryArguments queryArguments, ICube cube, long resultHandle, int numExpectedAxes) {
        super((DataProviderBase)provider, xDataContext, queryArguments.getRunLocale());
        if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY)) {
            ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log("Constructing result set.");
        }
        this.mQueryArguments = queryArguments;
        this.mODBOConnection = connection;
        this.mCube = cube;
        this.mResultSetHandle = resultHandle;
        this.numAxesWithoutSlicer = numExpectedAxes;
    }

    protected void afterExecute() {
        this.dimensions = new IDimension[this.getAxisCount()][];
    }

    public MDXQueryArguments getQueryArguments() {
        return this.mQueryArguments;
    }

    public final boolean isManagingConnection() {
        return this.mManagesConnection;
    }

    public final void setManagingConnection(boolean managingConnection) {
        this.mManagesConnection = managingConnection;
    }

    private static native void cReleaseResultSet(long var0) throws NativeException;

    private void nativeReleaseResultSet(final long resultSetHandle) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Object> task = new Callable<Object>(){

                @Override
                public Object call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        ODBOResultSet.cReleaseResultSet(resultSetHandle);
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                    return null;
                }
            };
            this.mODBOConnection.invokeNativeCall(task);
        } else {
            ODBOResultSet.cReleaseResultSet(resultSetHandle);
        }
    }

    private static native int cGetAxisCount(long var0) throws NativeException;

    private int nativeGetAxisCount(final long resultSetHandle) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Integer> task = new Callable<Integer>(){

                @Override
                public Integer call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        Integer n = ODBOResultSet.cGetAxisCount(resultSetHandle);
                        return n;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return this.mODBOConnection.invokeNativeCall(task);
        }
        return ODBOResultSet.cGetAxisCount(resultSetHandle);
    }

    private static native long cGetAxisRowset(long var0, int var2, int var3) throws NativeException;

    private long nativeGetAxisRowset(final long resultSetHandle, final int axisIndex, final int bindingBitmask) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Long> task = new Callable<Long>(){

                @Override
                public Long call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        Long l = ODBOResultSet.cGetAxisRowset(resultSetHandle, axisIndex, bindingBitmask);
                        return l;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return this.mODBOConnection.invokeNativeCall(task);
        }
        return ODBOResultSet.cGetAxisRowset(resultSetHandle, axisIndex, bindingBitmask);
    }

    private static native long cGetCellRowset(long var0, int var2) throws NativeException;

    private long nativeGetCellRowset(final long resultSetHandle, final int bindingBitmask) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Long> task = new Callable<Long>(){

                @Override
                public Long call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        Long l = ODBOResultSet.cGetCellRowset(resultSetHandle, bindingBitmask);
                        return l;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return this.mODBOConnection.invokeNativeCall(task);
        }
        return ODBOResultSet.cGetCellRowset(resultSetHandle, bindingBitmask);
    }

    public int getAxisCount() {
        ODBOResultSet.assertResultSetHandleIsValid(this.mResultSetHandle);
        try {
            return this.nativeGetAxisCount(this.mResultSetHandle);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Error occurred while getting axis count: ").append(status);
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, buffer.toString());
            }
            this.mODBOConnection.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.mResultSetHandle != 0L) {
            try {
                this.memberCache.clear();
                try {
                    this.nativeReleaseResultSet(this.mResultSetHandle);
                }
                catch (NativeException ex) {
                    ErrorStatus status = ex.getErrorStatus();
                    if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                        StringBuilder msgBuffer = new StringBuilder();
                        msgBuffer.append("Error closing result set: ").append(status);
                        ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
                    }
                    this.mODBOConnection.checkForLostConnection(status);
                    throw new ODBORuntimeException(ODBOMessageKeys.RES_PROVIDER_ERROR_CLOSING_RESULTSET, ex);
                }
                finally {
                    this.returnConnectionToPool();
                }
            }
            finally {
                this.mResultSetHandle = 0L;
            }
        }
    }

    private void returnConnectionToPool() {
        if (this.isManagingConnection()) {
            this.mODBOConnection.returnToPool();
        }
    }

    public ODBORowset getAxisRowset(int axisIndex, int bindingBitmask) {
        ODBOResultSet.assertResultSetHandleIsValid(this.mResultSetHandle);
        long rowsetHandle = 0L;
        try {
            rowsetHandle = this.nativeGetAxisRowset(this.mResultSetHandle, axisIndex, bindingBitmask);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving rowset for axis ").append(axisIndex).append(COLON_SPACE).append(status);
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
            }
            this.mODBOConnection.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.DAT_PROVIDER_ERROR_GETTING_AXIS_ROWSET, Integer.toString(axisIndex), ex);
        }
        return new ODBORowset(this.mODBOConnection, rowsetHandle);
    }

    public ODBOCellset getCellRowset(int bindingBitmask) {
        ODBOResultSet.assertResultSetHandleIsValid(this.mResultSetHandle);
        long rowsetHandle = 0L;
        try {
            rowsetHandle = this.nativeGetCellRowset(this.mResultSetHandle, bindingBitmask);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving cell rowset: ").append(status);
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
            }
            this.mODBOConnection.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.DAT_PROVIDER_ERROR_GETTING_CELL_ROWSET, ex);
        }
        return new ODBOCellset(this.mODBOConnection, rowsetHandle);
    }

    public XIterator getAxisIterator(int axis) {
        if (this.mCube == null) {
            throw new ODBORuntimeException(ODBOMessageKeys.DAT_ITERATOR_CALL_SEQUENCE_ERROR);
        }
        return new ODBOAxisIterator(this, this.getDataContext(), this.mCube, this.getAxisRowset(axis, 30), this.nodeId, axis, this.mODBOConnection);
    }

    public XCellIterator getCellIterator() {
        String providerType = (String)this.mODBOConnection.getConnectionParameters().valueOf(ProviderTypeParameter.class, String.class);
        ODBOConfig currConfig = ODBOConfigManager.getConfig(providerType);
        return new ODBOCellIterator(this, this.getDataContext(), this.getCellRowset(14), this.nodeId, currConfig, this.mODBOConnection);
    }

    public int getNumAxes() {
        int odboAxisCount = this.getAxisCount();
        if (this.numAxesWithoutSlicer == odboAxisCount) {
            return this.numAxesWithoutSlicer;
        }
        return odboAxisCount - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITuple getSlicer() {
        if (this.mCube == null) {
            throw new ODBORuntimeException(ODBOMessageKeys.DAT_SLICER_CALL_SEQUENCE_ERROR);
        }
        int allAxes = this.getAxisCount();
        if (this.getNumAxes() == allAxes) {
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY)) {
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log("ODBO did not return a slicer edge.");
            }
            return null;
        }
        if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY)) {
            ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log("ODBO returned a slicer edge.");
        }
        ODBOAxisIterator it = new ODBOAxisIterator(this, this.getDataContext(), this.mCube, this.getAxisRowset(allAxes - 1, 30), this.nodeId, allAxes - 1, this.mODBOConnection);
        ITuple aTuple = null;
        try {
            aTuple = (ITuple)it.nextImpl();
        }
        finally {
            it.release();
        }
        return aTuple;
    }

    public XScrollableCellIterator getScrollableCellIterator() {
        String providerType = (String)this.mODBOConnection.getConnectionParameters().valueOf(ProviderTypeParameter.class, String.class);
        ODBOConfig currConfig = ODBOConfigManager.getConfig(providerType);
        return new ODBOCellIterator(this, this.getDataContext(), this.getCellRowset(14), this.nodeId, currConfig, this.mODBOConnection);
    }

    public XScrollableIterator getScrollableAxisIterator(int axisNumber) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDimension[] getDimensions(int axisNumber) {
        if (null == this.dimensions[axisNumber]) {
            XIterator iter = this.getAxisIterator(axisNumber);
            try {
                ITuple t = (ITuple)iter.next();
                this.dimensions[axisNumber] = null != t ? t.getDimensions() : new IDimension[0];
            }
            finally {
                iter.release();
            }
        }
        return this.dimensions[axisNumber];
    }

    public long getAxisSize(int axisNumber) {
        throw new UnsupportedOperationException();
    }

    public int getNumTabularMeasures() {
        return 0;
    }

    public int getNumDataItemForSummary(int rowsetId) {
        return 0;
    }

    protected void releaseImpl() {
        try {
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY)) {
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log("Releasing resultSet.");
            }
            this.close();
        }
        catch (Exception e) {
            if (ODBOLog.isOn(LogLevel.ERROR)) {
                ODBOLog.getLogger().log(LogLevel.ERROR, (Throwable)e);
            }
        }
        finally {
            super.releaseImpl();
        }
    }

    Member getCachedMember(String mun) {
        return this.memberCache.get(mun);
    }

    void putCachedMember(String mun, Member member) {
        this.memberCache.put(mun, member);
    }

    private static void assertResultSetHandleIsValid(long handle) {
        if (0L == handle) {
            throw new ODBORuntimeException(ODBOMessageKeys.RES_INVALID_RESULTSET_HANDLE);
        }
    }

    public long getHandle() {
        return this.mResultSetHandle;
    }

    public boolean isCancelled() {
        return this.bCancelled;
    }

    public void setCancelled(boolean cancelled) {
        if (!this.bCancelled) {
            this.bCancelled = cancelled;
        }
    }

    private static native void cCancel(long var0) throws NativeException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelImpl() {
        boolean cancelSuccess = true;
        if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_CANCEL, LogLevel.TRACE)) {
            ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_CANCEL).log(LogLevel.TRACE, "ODBOResultSet cancel called.");
        }
        if (this.mResultSetHandle != 0L) {
            try {
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_CANCEL, LogLevel.TRACE)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_CANCEL).log(LogLevel.TRACE, "ODBOResultSet calling native cancel.");
                }
                ODBOConnection.cInitializeCOMThread();
                try {
                    ODBOResultSet.cCancel(this.mResultSetHandle);
                }
                finally {
                    ODBOConnection.cTerminateCOMThread();
                }
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_CANCEL, LogLevel.TRACE)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_CANCEL).log(LogLevel.TRACE, "ODBOResultSet native cancel success.");
                }
            }
            catch (NativeException ex) {
                StringBuilder msgBuffer;
                cancelSuccess = false;
                XQEDebugLog.out.printStackTrace((Throwable)ex);
                ErrorStatus status = ex.getErrorStatus();
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                    msgBuffer = new StringBuilder();
                    msgBuffer.append("Error cancelling request: ").append(status);
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
                }
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_CANCEL, LogLevel.ERROR)) {
                    msgBuffer = new StringBuilder();
                    msgBuffer.append("Error cancelling request:").append(status);
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_CANCEL).log(LogLevel.ERROR, msgBuffer.toString());
                }
                this.mODBOConnection.checkForLostConnection(status);
            }
            finally {
                this.releaseImpl();
            }
        }
        return cancelSuccess;
    }

    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("ODBOResultSet", 1);
        xmlWriter.attribute("serialVersionUID", 1L);
        xmlWriter.attribute("numAxesWithoutSlicer", this.numAxesWithoutSlicer);
        xmlWriter.beginElement("dimensions", 1);
        for (int i = 0; i < this.getAxisCount(); ++i) {
            IDimension[] dimArray = this.dimensions[i];
            for (int j = 0; j < dimArray.length; ++j) {
                IDimension iDimension = dimArray[j];
            }
        }
        xmlWriter.endElement();
        xmlWriter.beginElement("memberCache", 1);
        xmlWriter.endElement();
        xmlWriter.endElement();
    }
}

