/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.odbo.concurrent;

import com.cognos.xqe.data.providers.olap.odbo.ODBOConnection;
import com.cognos.xqe.data.providers.olap.odbo.ODBOMessageKeys;
import com.cognos.xqe.data.providers.olap.odbo.ODBORuntimeException;
import com.cognos.xqe.data.providers.olap.odbo.concurrent.ODBOThreadContext;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;

public class ODBOPassThroughExecutor
extends AbstractExecutorService {
    private static final ThreadLocal<Boolean> COM_INIT_FLAG = new ThreadLocal();
    private volatile boolean shutdown = false;

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return true;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.shutdown;
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown = true;
        return Collections.emptyList();
    }

    @Override
    public void execute(Runnable command) {
        ODBOPassThroughExecutor.initializeCOMThread();
        ODBOThreadContext.enter();
        try {
            command.run();
        }
        finally {
            ODBOThreadContext.exit();
        }
    }

    private static void initializeCOMThread() {
        boolean comInitialized = Boolean.TRUE.equals(COM_INIT_FLAG.get());
        if (comInitialized) {
            return;
        }
        try {
            ODBOConnection.cInitializeCOMThread();
        }
        catch (NativeException ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.COM_COM_THREAD_INIT_FAILED, ex);
        }
        COM_INIT_FLAG.set(Boolean.TRUE);
    }
}

