/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.odbo.concurrent;

import com.cognos.xqe.data.providers.olap.odbo.ODBOMessageKeys;
import com.cognos.xqe.data.providers.olap.odbo.ODBORuntimeException;

public final class ODBOThreadContext {
    private static final ThreadLocal<ODBOThreadContext> CURRENT = new ThreadLocal<ODBOThreadContext>(){

        @Override
        protected ODBOThreadContext initialValue() {
            return new ODBOThreadContext();
        }
    };
    private static boolean sEnableContextCheck = false;
    private int mEnterCount = 0;

    public static void enter() {
        ODBOThreadContext ctx = CURRENT.get();
        ++ctx.mEnterCount;
    }

    public static boolean isODBOThread() {
        ODBOThreadContext ctx = CURRENT.get();
        return ctx.mEnterCount > 0;
    }

    public static void exit() {
        ODBOThreadContext ctx = CURRENT.get();
        --ctx.mEnterCount;
    }

    public static void enableThreadCheck() {
        sEnableContextCheck = true;
    }

    public static void disableThreadCheck() {
        sEnableContextCheck = false;
    }

    public static void assertIsODBOThread() {
        if (sEnableContextCheck && !ODBOThreadContext.isODBOThread()) {
            throw new ODBORuntimeException(ODBOMessageKeys.COM_COM_THREAD_SWITCH_MISSING);
        }
    }
}

