/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.springboot.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.AdaptableModuleFactory;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.File;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={LibIndexCache.class})
public final class LibIndexCache {
    private static final String CACHE_DIR = ".cache.dirs";
    private static final String CACHE_ARTIFACT_DIR = "artifact.cache";
    private static final String CACHE_ADAPT_DIR = "adapt.cache";
    private static final String CACHE_OVERLAY_DIR = "overlay.cache";
    private WsResource libraryIndexParent;
    private WsResource libraryIndexWorkArea;
    private ArtifactContainerFactory containerFactory;
    private AdaptableModuleFactory adaptableFactory;
    static final long serialVersionUID = 7295950718852140099L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference
    protected void setLocationAdmin(WsLocationAdmin locAdmin) {
        WsResource indexResParent = locAdmin.resolveResource("${shared.resource.dir}/lib.index.cache/");
        this.libraryIndexParent = indexResParent.isType(WsResource.Type.DIRECTORY) ? indexResParent : null;
        WsResource indexResWorkArea = locAdmin.resolveResource("${server.workarea.dir}/spring/lib.index.cache/");
        indexResWorkArea.create();
        this.libraryIndexWorkArea = indexResWorkArea;
    }

    @Reference(target="(&(category=DIR)(category=JAR)(category=BUNDLE))")
    protected void setArtifactContainerFactory(ArtifactContainerFactory containerFactory) {
        this.containerFactory = containerFactory;
    }

    @Reference
    protected void setAdaptableModuleFactory(AdaptableModuleFactory adaptableFactory) {
        this.adaptableFactory = adaptableFactory;
    }

    private File getLibrary(Map.Entry<String, String> LibIndexEntry) {
        WsResource parentRes;
        if (this.libraryIndexParent != null && (parentRes = LibIndexCache.getStoreLocation(LibIndexEntry, this.libraryIndexParent)).exists()) {
            return parentRes.asFile();
        }
        WsResource workareaRes = LibIndexCache.getStoreLocation(LibIndexEntry, this.libraryIndexWorkArea);
        if (workareaRes.exists()) {
            return workareaRes.asFile();
        }
        return null;
    }

    private static WsResource getStoreLocation(Map.Entry<String, String> LibIndexEntry, WsResource storeRoot) {
        String hash = LibIndexEntry.getValue();
        String key = LibIndexEntry.getKey();
        String jarName = key.substring(key.lastIndexOf(47));
        CharSequence prefix = hash.subSequence(0, 2);
        CharSequence postFix = hash.subSequence(2, hash.length());
        WsResource prefixDir = storeRoot.resolveRelative(prefix.toString() + '/');
        return prefixDir.resolveRelative(postFix.toString() + '/' + jarName);
    }

    public Container getLibraryContainer(Map.Entry<String, String> libIndexEntry) throws UnableToAdaptException {
        File libFile = this.getLibrary(libIndexEntry);
        if (libFile == null) {
            return null;
        }
        ArtifactContainer libArtifactContainer = this.containerFactory.getContainer(this.getCache(libFile, CACHE_ARTIFACT_DIR), (Object)libFile);
        if (libArtifactContainer == null) {
            throw new UnableToAdaptException("Unable to get the container for the entry " + libIndexEntry.getKey());
        }
        return this.adaptableFactory.getContainer(this.getCache(libFile, CACHE_ADAPT_DIR), this.getCache(libFile, CACHE_OVERLAY_DIR), libArtifactContainer);
    }

    private File getCache(File libFile, String cacheName) {
        WsResource cacheDir = this.libraryIndexWorkArea.resolveRelative(".cache.dirs/" + libFile.getParentFile().getName() + '/' + libFile.getName() + '/' + cacheName + '/');
        cacheDir.create();
        return cacheDir.asFile();
    }

    public File getLibIndexParent() {
        return this.libraryIndexParent.asFile();
    }

    public File getLibIndexWorkarea() {
        return this.libraryIndexWorkArea.asFile();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(LibIndexCache.class, (String[])new String[]{"springboot", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.springboot.internal.resources.Messages", (String)"com.ibm.ws.app.manager.springboot.internal.LibIndexCache");
    }
}

