/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.blueprint.extensions.interceptors.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.eba.blueprint.extensions.interceptors.InterceptorFactory;
import com.ibm.ws.eba.blueprint.extensions.interceptors.impl.CDRCallBack;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.ComponentDefinitionRegistryProcessor;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.blueprint.PassThroughMetadata;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NonNullMetadata;
import org.osgi.service.blueprint.reflect.ReferenceListener;
import org.osgi.service.blueprint.reflect.RegistrationListener;
import org.osgi.service.blueprint.reflect.ServiceMetadata;
import org.osgi.service.blueprint.reflect.ServiceReferenceMetadata;
import org.osgi.service.blueprint.reflect.Target;

public class IBMDefaultRegistryProcessor
implements ComponentDefinitionRegistryProcessor {
    private static final TraceComponent _tc = Tr.register(IBMDefaultRegistryProcessor.class, (String)"Aries.blueprint.transform", null);
    private static final String FILTER = "(ibm.private.blueprint.default.interceptor=true)";
    private static final String SERVICE_INTERCEPTOR_FILTER = "(ibm.private.blueprint.default.service.interceptor=true)";
    private String name;
    private BundleContext context;
    private Integer callbackKey;
    private CDRCallBack callbackHandler;
    private Bundle blueprintBundle;

    public void setId(String id) {
        this.name = id;
    }

    public void setContext(BundleContext ctx) {
        this.context = ctx;
    }

    public void setCallbackKey(Integer i) {
        this.callbackKey = i;
    }

    public void setCallbackHandler(CDRCallBack handler) {
        this.callbackHandler = handler;
    }

    public void setBlueprintBundle(Bundle b) {
        this.blueprintBundle = b;
    }

    public void process(ComponentDefinitionRegistry reg) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)_tc, (String)"process", (Object[])new Object[]{reg});
        }
        reg.removeComponentDefinition(this.name);
        Collection<Interceptor> interceptors = this.getDefaultInterceptors();
        Collection<Interceptor> serviceInterceptors = this.getDefaultServiceInterceptors();
        for (String name : reg.getComponentDefinitionNames()) {
            ComponentMetadata metadata = reg.getComponentDefinition(name);
            this.registerInterceptors(reg, metadata, interceptors, serviceInterceptors);
            this.registerAnonymousChildren(reg, metadata, interceptors, serviceInterceptors);
        }
        this.callbackHandler.componentRegistryProcessorCallBack(this.callbackKey);
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)_tc, (String)"process");
        }
    }

    private void registerAnonymousChildren(ComponentDefinitionRegistry reg, ComponentMetadata metadata, Collection<Interceptor> interceptors, Collection<Interceptor> serviceInterceptors) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)_tc, (String)"registerAnonymousChildren", (Object[])new Object[]{reg, metadata, interceptors});
        }
        Collection<Object> anonymousComps = new ArrayList();
        if (metadata instanceof ServiceMetadata) {
            anonymousComps = this.processServiceMetaData((ServiceMetadata)metadata);
        } else if (metadata instanceof ServiceReferenceMetadata) {
            anonymousComps = this.processServiceReferenceMetaData((ServiceReferenceMetadata)metadata);
        } else if (metadata instanceof BeanMetadata) {
            anonymousComps = this.processBeanMetaData((BeanMetadata)metadata);
        }
        for (ComponentMetadata componentMetadata : anonymousComps) {
            this.registerInterceptors(reg, componentMetadata, interceptors, serviceInterceptors);
            this.registerAnonymousChildren(reg, componentMetadata, interceptors, serviceInterceptors);
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)_tc, (String)"registerAnonymousChildren");
        }
    }

    private Collection<? extends ComponentMetadata> processServiceMetaData(ServiceMetadata metadata) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)_tc, (String)"processServiceMetaData", (Object[])new Object[]{metadata});
        }
        ArrayList<ComponentMetadata> anonymousComps = new ArrayList<ComponentMetadata>();
        Target serviceComponent = metadata.getServiceComponent();
        if (serviceComponent instanceof ComponentMetadata) {
            anonymousComps.add((ComponentMetadata)serviceComponent);
        }
        Collection listeners = metadata.getRegistrationListeners();
        for (RegistrationListener rl : listeners) {
            Target listener = rl.getListenerComponent();
            if (!(listener instanceof ComponentMetadata)) continue;
            anonymousComps.add((ComponentMetadata)listener);
        }
        List serviceProps = metadata.getServiceProperties();
        for (MapEntry entry : serviceProps) {
            NonNullMetadata key = entry.getKey();
            Metadata value = entry.getValue();
            if (key instanceof ComponentMetadata) {
                anonymousComps.add((ComponentMetadata)key);
            }
            if (!(value instanceof ComponentMetadata)) continue;
            anonymousComps.add((ComponentMetadata)value);
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)_tc, (String)"processServiceMetaData", anonymousComps);
        }
        return anonymousComps;
    }

    private Collection<? extends ComponentMetadata> processServiceReferenceMetaData(ServiceReferenceMetadata metadata) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)_tc, (String)"processServiceReferenceMetaData", (Object[])new Object[]{metadata});
        }
        ArrayList<ComponentMetadata> anonymousComps = new ArrayList<ComponentMetadata>();
        Collection listeners = metadata.getReferenceListeners();
        for (ReferenceListener rl : listeners) {
            Target listener = rl.getListenerComponent();
            if (!(listener instanceof ComponentMetadata)) continue;
            anonymousComps.add((ComponentMetadata)listener);
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)_tc, (String)"processServiceReferenceMetaData", anonymousComps);
        }
        return anonymousComps;
    }

    private Collection<? extends ComponentMetadata> processBeanMetaData(BeanMetadata metadata) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)_tc, (String)"processBeanMetaData", (Object[])new Object[]{metadata});
        }
        ArrayList<ComponentMetadata> anonymousComps = new ArrayList<ComponentMetadata>();
        List args = metadata.getArguments();
        for (BeanArgument arg : args) {
            Metadata value = arg.getValue();
            if (!(value instanceof ComponentMetadata)) continue;
            anonymousComps.add((ComponentMetadata)value);
        }
        List props = metadata.getProperties();
        for (BeanProperty prop : props) {
            Metadata value = prop.getValue();
            if (!(value instanceof ComponentMetadata)) continue;
            anonymousComps.add((ComponentMetadata)value);
        }
        Target factoryComp = metadata.getFactoryComponent();
        if (factoryComp instanceof ComponentMetadata) {
            anonymousComps.add((ComponentMetadata)factoryComp);
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)_tc, (String)"processBeanMetaData", anonymousComps);
        }
        return anonymousComps;
    }

    private void registerInterceptors(ComponentDefinitionRegistry reg, ComponentMetadata metadata, Collection<Interceptor> interceptors, Collection<Interceptor> serviceInterceptors) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)_tc, (String)"registerInterceptors", (Object[])new Object[]{reg, metadata, interceptors});
        }
        if (metadata instanceof BeanMetadata || metadata instanceof PassThroughMetadata) {
            for (Interceptor i : interceptors) {
                reg.registerInterceptorWithComponent(metadata, i);
            }
        } else if (metadata instanceof ServiceMetadata) {
            if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)_tc, (String)"Attempt to register interceptors for ServiceMetadata", (Object[])new Object[]{metadata, serviceInterceptors});
            }
            for (Interceptor i : serviceInterceptors) {
                reg.registerInterceptorWithComponent(metadata, i);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)_tc, (String)"registerInterceptors");
        }
    }

    private Collection<Interceptor> getDefaultInterceptors() {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)_tc, (String)"getDefaultInterceptors", (Object[])new Object[0]);
        }
        Collection<Interceptor> interceptors = this.getInterceptors(FILTER);
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)_tc, (String)"getDefaultInterceptors", interceptors);
        }
        return interceptors;
    }

    private Collection<Interceptor> getDefaultServiceInterceptors() {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)_tc, (String)"getDefaultServiceInterceptors", (Object[])new Object[0]);
        }
        Collection<Interceptor> serviceInterceptors = this.getInterceptors(SERVICE_INTERCEPTOR_FILTER);
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)_tc, (String)"getDefaultServiceInterceptors", serviceInterceptors);
        }
        return serviceInterceptors;
    }

    private Collection<Interceptor> getInterceptors(String filter) {
        Object i;
        ServiceReference[] refs;
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)_tc, (String)"getInterceptors", (Object[])new Object[0]);
        }
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        try {
            refs = this.context.getServiceReferences(Interceptor.class.getCanonicalName(), filter);
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    i = (Interceptor)this.context.getService(ref);
                    if (i == null) continue;
                    interceptors.add((Interceptor)i);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            FFDCFilter.processException((Throwable)e, (String)(IBMDefaultRegistryProcessor.class.getName() + "getInterceptors"), (String)"359");
        }
        try {
            refs = this.context.getServiceReferences(InterceptorFactory.class.getCanonicalName(), filter);
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    i = (InterceptorFactory)this.context.getService(ref);
                    if (i == null) continue;
                    interceptors.add(i.createInterceptor(this.blueprintBundle));
                }
            }
        }
        catch (InvalidSyntaxException e) {
            FFDCFilter.processException((Throwable)e, (String)(IBMDefaultRegistryProcessor.class.getName() + "getInterceptors"), (String)"377");
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)_tc, (String)"getInterceptors", interceptors);
        }
        return interceptors;
    }
}

