/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.blueprint.extensions.interceptors.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.eba.blueprint.transform.BlueprintBundle;
import com.ibm.ws.eba.blueprint.transform.BlueprintTransformer;
import com.ibm.ws.eba.blueprint.transform.BlueprintXml;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class IBMNamespaceTransformer
implements BlueprintTransformer {
    private static final TraceComponent _tc = Tr.register(IBMNamespaceTransformer.class, (String)"Aries.blueprint.transform", null);
    public static final String NS_URI = "http://www.ibm.com/xmlns/blueprint/internal/v1.0.0";
    public static final String IBM_EXTENSIONS_ATTRIBUTE = "extensions";

    public void transformBlueprintBundle(BlueprintBundle bpBundle) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)_tc, (String)"transformBlueprintBundle", (Object[])new Object[]{bpBundle});
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        TransformerFactory tranFact = TransformerFactory.newInstance();
        Transformer transformer = tranFact.newTransformer();
        for (BlueprintXml xml : bpBundle.getXmlFiles()) {
            Document doc = db.parse(xml.getInputStream());
            String prefix = this.findPrefix(doc.getDocumentElement());
            doc.getDocumentElement().setAttributeNS(NS_URI, prefix + ":" + IBM_EXTENSIONS_ATTRIBUTE, Boolean.toString(true));
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(xml.getOutputStream());
            transformer.transform(source, result);
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)_tc, (String)"transformBlueprintBundle");
        }
    }

    private String findPrefix(Element e) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)_tc, (String)"findPrefix", (Object[])new Object[]{e});
        }
        StringBuilder prefix = new StringBuilder("ibm");
        NamedNodeMap map = e.getAttributes();
        if (map != null) {
            boolean prefixSelected = false;
            int i = 0;
            while (!prefixSelected) {
                Node n = map.getNamedItemNS("http://www.w3.org/2000/xmlns/", prefix.toString());
                if (n == null) {
                    prefixSelected = true;
                    continue;
                }
                prefix.append(i++);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)_tc, (String)"findPrefix", (Object)prefix);
        }
        return prefix.toString();
    }
}

