/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.bundle.repository.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.eba.bundle.repository.internal.Services;
import com.ibm.ws.eba.bundle.repository.internal.Utils;
import com.ibm.ws.eba.bundle.repository.internal.WsBundleRepository;
import com.ibm.ws.eba.bundle.repository.internal.blueprint.ResourceModellingUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.config.Fileset;
import com.ibm.wsspi.config.FilesetChangeListener;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.aries.util.filesystem.IFile;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.repository.Repository;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BundleRepositoryImpl
implements WsBundleRepository {
    private static final TraceComponent tc = Tr.register(BundleRepositoryImpl.class, (String)"blueprint", (String)"com.ibm.ws.eba.bundle.repository.internal.resources.Messages");
    private final BundleContext ctx;
    private final String pid;
    private final ConcurrentHashMap<String, RepositoryChangeListener> configuredFileChangeListeners = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Collection<IFile>> cachedRepositoryFiles = new ConcurrentHashMap();
    private final AtomicServiceReference<RepositoryAdmin> repoAdminRef;
    private final Object repoGenerator;
    private final AtomicServiceReference<WsLocationAdmin> locationServiceRef;
    private final String id;
    private Lock xml_lock = new ReentrantLock();
    private final AtomicReference<ServiceRegistration<Repository>> repositoryRegistration = new AtomicReference();
    static final long serialVersionUID = -6117386483790570920L;

    BundleRepositoryImpl(BundleContext ctx, String pid, Services services) {
        this.ctx = ctx;
        this.pid = pid;
        this.repoAdminRef = services.getRepoAdminRef();
        this.repoGenerator = services.getRepoGenerator();
        this.locationServiceRef = services.getLocationServiceRef();
        this.id = pid;
    }

    @Override
    public void setXMLLock(Lock lock) {
        this.xml_lock = lock;
    }

    @Override
    @FFDCIgnore(value={IllegalStateException.class})
    public void delete() {
        if (this.repoGenerator != null) {
            RepositoryAdmin repoAdmin = (RepositoryAdmin)this.repoAdminRef.getService();
            WsResource repoXml = this.getRepositoryResource();
            if (repoXml == null) {
                return;
            }
            try {
                repoAdmin.removeRepository(repoXml.toExternalURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.eba.bundle.repository.internal.BundleRepositoryImpl", (String)"101", (Object)this, (Object[])new Object[0]);
            }
        } else {
            ServiceRegistration registration = this.repositoryRegistration.getAndSet(null);
            if (registration != null) {
                try {
                    registration.unregister();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The bundleRepository was removed", (Object[])new Object[]{this.pid});
        }
    }

    private synchronized Collection<IFile> getFilesFromFilesets() {
        ArrayList<IFile> repositoryFiles = new ArrayList<IFile>();
        for (Map.Entry<String, RepositoryChangeListener> listenerMapEntry : this.configuredFileChangeListeners.entrySet()) {
            String fsPid = listenerMapEntry.getKey();
            RepositoryChangeListener fsListener = listenerMapEntry.getValue();
            Tr.debug((TraceComponent)tc, (String)"getFilesFromFilesets(), fsPid, fsListener", (Object[])new Object[]{fsPid, fsListener});
            if (fsListener != null && fsListener.updateRequired()) {
                Fileset fileset = fsListener.fileset;
                if (fileset == null) continue;
                Collection<IFile> repoFilesForFileset = Utils.convertFilesetToIFiles(fileset.getFileset());
                repositoryFiles.addAll(repoFilesForFileset);
                this.cachedRepositoryFiles.put(fsPid, repoFilesForFileset);
                fsListener.reset();
                continue;
            }
            Collection<IFile> cached = this.cachedRepositoryFiles.get(fsPid);
            Tr.debug((TraceComponent)tc, (String)"Update from cache:", (Object[])new Object[]{cached});
            if (cached == null) continue;
            repositoryFiles.addAll(cached);
        }
        return Collections.unmodifiableCollection(repositoryFiles);
    }

    private WsResource getRepositoryResource() {
        WsLocationAdmin locationAdmin = (WsLocationAdmin)this.locationServiceRef.getService();
        if (locationAdmin == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to get repository XML as the location service is not available.", (Object[])new Object[0]);
            }
            Tr.warning((TraceComponent)tc, (String)"warn.missing.service", (Object[])new Object[]{"Location service"});
            return null;
        }
        return locationAdmin.getServerWorkareaResource("platform/bundleRepositories/" + this.pid + ".xml");
    }

    @FFDCIgnore(value={IllegalStateException.class})
    private void updateRepository() {
        if (this.repoGenerator != null) {
            WsResource repoXml = this.getRepositoryResource();
            if (repoXml == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to update repository", (Object[])new Object[0]);
                }
                return;
            }
            ResourceModellingUtils.updateOBR(repoXml, this.getFilesFromFilesets(), this.pid, this.ctx, tc, this.xml_lock, this.repoGenerator, (RepositoryAdmin)this.repoAdminRef.getService());
        } else {
            Repository repository = Utils.createRepository(this.getFilesFromFilesets());
            ServiceRegistration<Repository> existingRegistration = this.repositoryRegistration.getAndSet((ServiceRegistration<Repository>)this.ctx.registerService(Repository.class, (Object)repository, null));
            if (existingRegistration != null) {
                try {
                    existingRegistration.unregister();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"RepositoryAdmin updated with bundle repository change", (Object[])new Object[]{this.pid});
            }
        }
    }

    @Override
    public synchronized void updateConfig(Dictionary<String, Object> properties) {
        String[] filesetPids = (String[])properties.get("filesetRef");
        filesetPids = filesetPids != null ? filesetPids : new String[]{};
        List<String> fileSetPidList = Arrays.asList(filesetPids);
        Set knownFilesetPids = this.configuredFileChangeListeners.keySet();
        Tr.debug((TraceComponent)tc, (String)"knownFilesetPids = ", (Object[])new Object[]{knownFilesetPids});
        for (String pid : knownFilesetPids) {
            ServiceRegistration<FilesetChangeListener> reg;
            if (fileSetPidList.contains(pid)) continue;
            RepositoryChangeListener oldListener = this.configuredFileChangeListeners.remove(pid);
            if (oldListener != null && (reg = oldListener.getRegistration()) != null) {
                reg.unregister();
            }
            this.cachedRepositoryFiles.remove(pid);
        }
        for (String fsPid : fileSetPidList) {
            RepositoryChangeListener listener;
            RepositoryChangeListener existingListener = this.configuredFileChangeListeners.putIfAbsent(fsPid, listener = new RepositoryChangeListener());
            if (existingListener != null) continue;
            Hashtable<String, String> listenerProps = new Hashtable<String, String>(1);
            ((Dictionary)listenerProps).put("fileset", fsPid);
            Tr.debug((TraceComponent)tc, (String)"Resister FilesetChangeListener with Fileset", (Object[])new Object[]{listener, fsPid});
            ServiceRegistration reg = this.ctx.registerService(FilesetChangeListener.class, (Object)listener, listenerProps);
            listener.setRegistration((ServiceRegistration<FilesetChangeListener>)reg);
        }
    }

    @Override
    public void validateConfig(Dictionary<String, Object> properties) throws ConfigurationException {
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public byte[] getOBRXML() {
        if (this.repoGenerator != null) {
            WsResource repoXml = this.getRepositoryResource();
            if (repoXml == null) {
                return new byte[0];
            }
            try {
                this.xml_lock.lock();
                byte[] byArray = Utils.getContents(repoXml);
                return byArray;
            }
            finally {
                this.xml_lock.unlock();
            }
        }
        return new byte[0];
    }

    @Override
    public String getLocation() {
        StringBuilder builder = new StringBuilder();
        for (String filesetRef : this.configuredFileChangeListeners.keySet()) {
            try {
                Collection refs = this.ctx.getServiceReferences(Fileset.class, "(service.pid=" + filesetRef + ")");
                for (ServiceReference ref : refs) {
                    Fileset fileset = (Fileset)this.ctx.getService(ref);
                    builder.append(fileset.getDir());
                }
            }
            catch (InvalidSyntaxException refs) {
                FFDCFilter.processException((Throwable)refs, (String)"com.ibm.ws.eba.bundle.repository.internal.BundleRepositoryImpl", (String)"336", (Object)this, (Object[])new Object[0]);
                continue;
            }
            builder.append(";");
        }
        if (builder.length() > 0) {
            return builder.substring(0, builder.length() - 1);
        }
        return "";
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private final class RepositoryChangeListener
    implements FilesetChangeListener {
        private final AtomicBoolean updated = new AtomicBoolean(true);
        private volatile ServiceRegistration<FilesetChangeListener> reg;
        private volatile Fileset fileset;
        static final long serialVersionUID = 2098967733305330980L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private RepositoryChangeListener() {
        }

        public String toString() {
            return "RepositoryChangeListener [updated=" + this.updated + ", reg=" + this.reg + ", fileset=" + this.fileset + "]";
        }

        public void filesetNotification(String pid, Fileset fileset) {
            this.updated.set(true);
            this.fileset = fileset;
            BundleRepositoryImpl.this.updateRepository();
        }

        boolean updateRequired() {
            return this.updated.get();
        }

        void reset() {
            this.updated.set(false);
        }

        void setRegistration(ServiceRegistration<FilesetChangeListener> reg) {
            this.reg = reg;
        }

        ServiceRegistration<FilesetChangeListener> getRegistration() {
            return this.reg;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.bundle.repository.internal.BundleRepositoryImpl$RepositoryChangeListener", RepositoryChangeListener.class, (String)"blueprint", (String)"com.ibm.ws.eba.bundle.repository.internal.resources.Messages");
        }
    }
}

