/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.bundle.repository.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.eba.bundle.repository.internal.ResourceResolver;
import com.ibm.ws.eba.bundle.repository.internal.ResourceResolverFactory;
import com.ibm.ws.eba.bundle.repository.internal.Utils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HTTPRemoteRepository {
    private static final TraceComponent tc = Tr.register(HTTPRemoteRepository.class, (String)"blueprint", (String)"com.ibm.ws.eba.bundle.repository.internal.resources.Messages");
    static final long serialVersionUID = -573846079215715487L;

    /*
     * WARNING - void declaration
     */
    static WsResource getRemoteResource(URL resurl, ResourceResolver resolver) throws IOException {
        HttpURLConnection con = (HttpURLConnection)resurl.openConnection();
        String urlHash = Utils.generateHash(tc, resurl.toString().getBytes());
        if (urlHash == null) {
            throw new IOException();
        }
        String id = urlHash;
        try {
            return HTTPRemoteRepository.downloadResource(con, id, resolver, resurl);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.eba.bundle.repository.internal.HTTPRemoteRepository", (String)"55", null, (Object[])new Object[]{resurl, resolver});
            WsResource cached = resolver.getLatestCachedVersion(id);
            if (cached == null) {
                void e;
                throw e;
            }
            return cached;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WsResource downloadResource(HttpURLConnection con, String id, ResourceResolver resolver, URL resurl) throws IOException {
        WsResource localStorage = null;
        con.connect();
        switch (con.getResponseCode()) {
            case 200: {
                String tag = con.getHeaderField("ETag");
                if (tag != null) {
                    String etagHash = Utils.generateHash(tc, tag.getBytes());
                    if (etagHash != null) {
                        id = id + "." + etagHash;
                    }
                } else {
                    id = id + "." + UUID.randomUUID().toString();
                }
                id = id + "_" + Utils.getFileName(resurl);
                localStorage = resolver.getResource(id);
                if (tag != null && localStorage.exists()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)String.format("Match found for %s in cache [%s]", resurl, localStorage), (Object[])new Object[0]);
                    }
                    return localStorage;
                }
                WsResource tmpStorage = resolver.getResource(id + ".part");
                InputStream is = null;
                try {
                    is = con.getInputStream();
                    tmpStorage.put(is);
                }
                finally {
                    if (is != null) {
                        Utils.close(is);
                    }
                }
                tmpStorage.moveTo(localStorage);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)String.format("Download complete for %s, stored in cache as [%s]", resurl, localStorage), (Object[])new Object[0]);
                }
                return localStorage;
            }
        }
        Tr.error((TraceComponent)tc, (String)"error.http.server", (Object[])new Object[]{resurl.getHost(), con.getResponseCode()});
        String msg = Tr.formatMessage((TraceComponent)tc, (String)"error.http.server", (Object[])new Object[]{resurl.getHost(), con.getResponseCode()});
        throw new IOException(msg);
    }

    public static void clean(WsLocationAdmin locationServiceRef) {
        if (locationServiceRef == null) {
            return;
        }
        HTTPRemoteRepository.deleteOrphanCaches(locationServiceRef);
        ResourceResolver resolver = ResourceResolverFactory.createOBRXMLResolver(locationServiceRef);
        HTTPRemoteRepository.removeOldVersions(resolver);
        resolver = ResourceResolverFactory.createConfigResolver(locationServiceRef);
        HTTPRemoteRepository.removeOldVersions(resolver);
    }

    private static void deleteOrphanCaches(WsLocationAdmin locationServiceRef) {
        if (locationServiceRef == null) {
            return;
        }
        for (WsResource cache : ResourceResolverFactory.getCaches(locationServiceRef)) {
            String name;
            ResourceResolver resolver = ResourceResolverFactory.createOBRXMLResolver(locationServiceRef);
            List<WsResource> matches = resolver.getAllVersions((name = Utils.removeTrailingSlash(cache.getName())) + ".*");
            if (matches.isEmpty()) {
                if (cache.isType(WsResource.Type.DIRECTORY)) {
                    Iterator i = cache.getChildren();
                    while (i.hasNext()) {
                        WsResource file = cache.getChild((String)i.next());
                        if (file == null) continue;
                        file.delete();
                    }
                }
                cache.delete();
                continue;
            }
            ResourceResolver cacheResolver = ResourceResolverFactory.createCacheResolver(locationServiceRef, name);
            HTTPRemoteRepository.removeOldVersions(cacheResolver);
        }
    }

    private static void removeOldVersions(ResourceResolver resolver) {
        for (String name : resolver.getUniqueNames()) {
            name = Utils.removeTrailingSlash(name);
            List<WsResource> versions = resolver.getAllVersions(name + ".*");
            Collections.sort(versions, new Comparator<WsResource>(){
                static final long serialVersionUID = 6527661619876275177L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public int compare(WsResource r1, WsResource r2) {
                    return (int)(r2.getLastModified() - r1.getLastModified());
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.bundle.repository.internal.HTTPRemoteRepository$1", 1.class, (String)"blueprint", (String)"com.ibm.ws.eba.bundle.repository.internal.resources.Messages");
                }
            });
            for (int i = 1; i < versions.size(); ++i) {
                versions.get(i).delete();
            }
        }
    }
}

