/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.bundle.repository.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.eba.bundle.repository.internal.Utils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.osgi.service.cm.ConfigurationException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RepositoryID {
    private static final TraceComponent tc = Tr.register(RepositoryID.class, (String)"blueprint", (String)"com.ibm.ws.eba.bundle.repository.internal.resources.Messages");
    public final URL url;
    public final URI uri;
    public final String id;
    static final long serialVersionUID = -2766562041066749654L;

    /*
     * WARNING - void declaration
     */
    RepositoryID(final String location, URI relativeResolver) throws ConfigurationException {
        try {
            URI tempURI = AccessController.doPrivileged(new PrivilegedExceptionAction<URI>(){
                static final long serialVersionUID = 7475059612228051331L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public URI run() throws ConfigurationException {
                    try {
                        return new URI(location);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        void e;
                        FFDCFilter.processException((Throwable)uRISyntaxException, (String)"com.ibm.ws.eba.bundle.repository.internal.RepositoryID$1", (String)"46", (Object)this, (Object[])new Object[0]);
                        throw new ConfigurationException("location", e.getLocalizedMessage(), (Throwable)e);
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.bundle.repository.internal.RepositoryID$1", 1.class, (String)"blueprint", (String)"com.ibm.ws.eba.bundle.repository.internal.resources.Messages");
                }
            });
            this.uri = tempURI.isAbsolute() ? tempURI : relativeResolver.resolve(tempURI);
            this.url = this.uri.toURL();
            this.id = Utils.generateHash(tc, this.url.toString().getBytes());
        }
        catch (PrivilegedActionException tempURI) {
            void e;
            FFDCFilter.processException((Throwable)tempURI, (String)"com.ibm.ws.eba.bundle.repository.internal.RepositoryID", (String)"55", (Object)this, (Object[])new Object[]{location, relativeResolver});
            throw (ConfigurationException)((Object)e.getException());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.eba.bundle.repository.internal.RepositoryID", (String)"57", (Object)this, (Object[])new Object[]{location, relativeResolver});
            throw new ConfigurationException("location", e.getLocalizedMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    RepositoryID(URI location, URI relativeResolver) throws ConfigurationException {
        this.uri = location.isAbsolute() ? location : relativeResolver.resolve(location);
        try {
            this.url = location.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            void e;
            FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.eba.bundle.repository.internal.RepositoryID", (String)"66", (Object)this, (Object[])new Object[]{location, relativeResolver});
            throw new ConfigurationException("location", e.getLocalizedMessage(), (Throwable)e);
        }
        this.id = Utils.generateHash(tc, this.url.toString().getBytes());
    }

    public boolean equals(Object o) {
        if (o instanceof RepositoryID) {
            return this.id.equals(((RepositoryID)o).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Repository [uri=" + this.uri + "]";
    }
}

