/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.bundle.repository.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.eba.bundle.repository.internal.ResourceResolver;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ResourceResolverFactory {
    private static final String BASE = "platform/bundleRepositories/remote/";
    static final long serialVersionUID = 798805240913029856L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static ResourceResolver createOBRXMLResolver(WsLocationAdmin locationAdmin) {
        return new OBRXMLResourceResolver(locationAdmin);
    }

    public static ResourceResolver createConfigResolver(WsLocationAdmin locationAdmin) {
        return new ConfigResourceResolver(locationAdmin);
    }

    public static ResourceResolver createCacheResolver(WsLocationAdmin locationAdmin, String root) {
        return new CacheResourceResolver(locationAdmin, root);
    }

    public static List<WsResource> getCaches(WsLocationAdmin locationAdmin) {
        WsResource root = locationAdmin.getServerWorkareaResource(BASE);
        return ResourceResolverFactory.getChildren(root, "^[a-f0-9]*/");
    }

    private static List<WsResource> getChildren(WsResource root, String regex) {
        ArrayList<WsResource> caches = new ArrayList<WsResource>();
        Iterator matches = root.getChildren(regex);
        while (matches.hasNext()) {
            caches.add(root.getChild((String)matches.next()));
        }
        return caches;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.bundle.repository.internal.ResourceResolverFactory", ResourceResolverFactory.class, (String)"blueprint", (String)"com.ibm.ws.eba.bundle.repository.internal.resources.Messages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class CacheResourceResolver
    extends AbstractResourceResolver {
        static final long serialVersionUID = 1509349735857463630L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private CacheResourceResolver(WsLocationAdmin locationAdmin, String root) {
            super(locationAdmin, "platform/bundleRepositories/remote//" + root + "/");
        }

        @Override
        public ResourceResolverType getType() {
            return ResourceResolverType.CACHE;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.bundle.repository.internal.ResourceResolverFactory$CacheResourceResolver", CacheResourceResolver.class, (String)"blueprint", (String)"com.ibm.ws.eba.bundle.repository.internal.resources.Messages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ConfigResourceResolver
    extends AbstractResourceResolver {
        static final long serialVersionUID = -7845362820021628140L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ConfigResourceResolver(WsLocationAdmin locationAdmin) {
            super(locationAdmin, ResourceResolverFactory.BASE);
            this.SUFFIX = "_config.properties";
        }

        @Override
        public ResourceResolverType getType() {
            return ResourceResolverType.PROPS;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.bundle.repository.internal.ResourceResolverFactory$ConfigResourceResolver", ConfigResourceResolver.class, (String)"blueprint", (String)"com.ibm.ws.eba.bundle.repository.internal.resources.Messages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class OBRXMLResourceResolver
    extends AbstractResourceResolver {
        static final long serialVersionUID = -6384259679859277829L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private OBRXMLResourceResolver(WsLocationAdmin locationAdmin) {
            super(locationAdmin, ResourceResolverFactory.BASE);
            this.SUFFIX = "_obr.xml";
        }

        @Override
        public ResourceResolverType getType() {
            return ResourceResolverType.OBRXML;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.bundle.repository.internal.ResourceResolverFactory$OBRXMLResourceResolver", OBRXMLResourceResolver.class, (String)"blueprint", (String)"com.ibm.ws.eba.bundle.repository.internal.resources.Messages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static abstract class AbstractResourceResolver
    implements ResourceResolver {
        protected String SUFFIX = "";
        protected final WsLocationAdmin locationAdmin;
        protected final String PATH;
        static final long serialVersionUID = 9082884723780129853L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private AbstractResourceResolver(WsLocationAdmin locationAdmin, String path) {
            this.locationAdmin = locationAdmin;
            this.PATH = path;
        }

        @Override
        public WsResource getResource(String name) {
            if (this.SUFFIX != null && this.SUFFIX.length() > 0 && !name.endsWith(this.SUFFIX)) {
                name = name + this.SUFFIX;
            }
            return this.locationAdmin.getServerWorkareaResource(this.PATH + name);
        }

        @Override
        public List<WsResource> getAllVersions(String id) {
            WsResource root = this.locationAdmin.getServerWorkareaResource(this.PATH);
            return ResourceResolverFactory.getChildren(root, "^" + id + this.SUFFIX);
        }

        @Override
        public Set<String> getUniqueNames() {
            WsResource root = this.locationAdmin.getServerWorkareaResource(this.PATH);
            Iterator files = root.getChildren(".*" + this.SUFFIX);
            HashSet<String> results = new HashSet<String>();
            while (files.hasNext()) {
                String fullname = (String)files.next();
                int pos = fullname.indexOf(46);
                if (pos == -1) {
                    results.add(fullname);
                    continue;
                }
                results.add(fullname.substring(0, pos));
            }
            return results;
        }

        @Override
        public WsResource getLatestCachedVersion(String id) {
            List<WsResource> versions = this.getAllVersions(id + ".*");
            if (versions.size() == 0) {
                return null;
            }
            Collections.sort(versions, new Comparator<WsResource>(){
                static final long serialVersionUID = 5971010453498328463L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public int compare(WsResource r1, WsResource r2) {
                    return (int)(r2.getLastModified() - r1.getLastModified());
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.bundle.repository.internal.ResourceResolverFactory$AbstractResourceResolver$1", 1.class, (String)"blueprint", (String)"com.ibm.ws.eba.bundle.repository.internal.resources.Messages");
                }
            });
            return versions.get(0);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.bundle.repository.internal.ResourceResolverFactory$AbstractResourceResolver", AbstractResourceResolver.class, (String)"blueprint", (String)"com.ibm.ws.eba.bundle.repository.internal.resources.Messages");
        }
    }

    public static enum ResourceResolverType {
        PROPS,
        CACHE,
        OBRXML;

    }
}

