/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.eba.bundle.repository.internal.blueprint;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.eba.bundle.repository.internal.ResourceResolver;
import com.ibm.ws.eba.bundle.repository.internal.ResourceResolverFactory;
import com.ibm.ws.eba.bundle.repository.internal.Utils;
import com.ibm.ws.eba.bundle.repository.internal.blueprint.BundleBlueprintParser;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.DesignatedXMLInputFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.stream.XMLStreamReader;
import org.apache.aries.application.InvalidAttributeException;
import org.apache.aries.application.ServiceDeclaration;
import org.apache.aries.application.management.ResolverException;
import org.apache.aries.application.management.spi.repository.RepositoryGenerator;
import org.apache.aries.application.modelling.ImportedService;
import org.apache.aries.application.modelling.ModelledResource;
import org.apache.aries.application.modelling.ModelledResourceManager;
import org.apache.aries.application.modelling.ModellerException;
import org.apache.aries.application.modelling.ModellingManager;
import org.apache.aries.application.modelling.ParsedServiceElements;
import org.apache.aries.application.modelling.WrappedServiceMetadata;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.io.IOUtils;
import org.apache.aries.util.manifest.BundleManifest;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ResourceModellingUtils {
    private static final String SERVICE_EXPORTED_INTERFACES = "service.exported.interfaces";
    private static Set<String> ALLOWLISTED_XML_NAMESPACES;
    static final long serialVersionUID = -2996151181351914826L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static ModelledResource model(String uri, BundleManifest mf, IDirectory iDir, ModelledResourceManager modelledResourceManager, ModellingManager modellingManager) throws InvalidAttributeException, ModellerException, Exception {
        Attributes attributes = mf.getRawAttributes();
        ParsedServiceElements pse = modelledResourceManager.getServiceElements(iDir);
        ArrayList<ImportedService> serviceRefs = new ArrayList<ImportedService>(pse.getReferences());
        serviceRefs.addAll(ResourceModellingUtils.getBlueprintNamespaceReferences(modellingManager, iDir));
        ModelledResource result = modellingManager.getModelledResource(uri, attributes, serviceRefs, pse.getServices());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static ModelledResource model(String uri, BundleManifest mf, IDirectory iDir, BundleContext ctx) throws InvalidAttributeException, ModellerException, Exception {
        ServiceTracker mrmRefTracker = new ServiceTracker(ctx, ModelledResourceManager.class.getName(), null);
        ServiceTracker mmRefTracker = new ServiceTracker(ctx, ModellingManager.class.getName(), null);
        mrmRefTracker.open();
        mmRefTracker.open();
        try {
            ModelledResourceManager modelledResourceManager = null;
            ModellingManager mmMgr = null;
            try {
                modelledResourceManager = (ModelledResourceManager)mrmRefTracker.waitForService(3000L);
                mmMgr = (ModellingManager)mmRefTracker.waitForService(3000L);
            }
            catch (InterruptedException interruptedException) {
                void ie;
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.eba.bundle.repository.internal.blueprint.ResourceModellingUtils", (String)"152", null, (Object[])new Object[]{uri, mf, iDir, ctx});
                FFDCFilter.processException((Throwable)ie, (String)(ResourceModellingUtils.class.getName() + ".model"), (String)"125");
            }
            if (modelledResourceManager == null) {
                throw new Exception("No modelling service");
            }
            if (mmMgr == null) {
                throw new Exception("No modelling manager");
            }
            ModelledResource modelledResource = ResourceModellingUtils.model(uri, mf, iDir, modelledResourceManager, mmMgr);
            return modelledResource;
        }
        finally {
            if (mmRefTracker != null) {
                mmRefTracker.close();
            }
            if (mrmRefTracker != null) {
                mrmRefTracker.close();
            }
        }
    }

    public static Collection<WrappedServiceMetadata> filterEBAServices(Collection<WrappedServiceMetadata> blueprintServicesInThisArchive, Collection<ServiceDeclaration> serviceExportFilters) throws InvalidSyntaxException {
        Collection<WrappedServiceMetadata> result = ResourceModellingUtils.filterServices(blueprintServicesInThisArchive, serviceExportFilters, true);
        return result;
    }

    public static Collection<WrappedServiceMetadata> filterCBAServices(Collection<WrappedServiceMetadata> blueprintServicesInThisArchive, Collection<ServiceDeclaration> serviceExportFilters) throws InvalidSyntaxException {
        Collection<WrappedServiceMetadata> result = ResourceModellingUtils.filterServices(blueprintServicesInThisArchive, serviceExportFilters, false);
        return result;
    }

    private static Collection<WrappedServiceMetadata> filterServices(Collection<WrappedServiceMetadata> blueprintServicesInThisArchive, Collection<ServiceDeclaration> serviceExportFilters, boolean filteringEBA) throws InvalidSyntaxException {
        ArrayList<WrappedServiceMetadata> result = new ArrayList<WrappedServiceMetadata>();
        ArrayList<WrappedServiceMetadata> candidateMatches = new ArrayList<WrappedServiceMetadata>();
        for (ServiceDeclaration exportedService : serviceExportFilters) {
            String interfaceName = exportedService.getInterfaceName();
            Filter filter = exportedService.getFilter();
            for (WrappedServiceMetadata blueprintServiceMetadata : blueprintServicesInThisArchive) {
                Collection interfaces = blueprintServiceMetadata.getInterfaces();
                String matchedInterfaceName = null;
                for (String i : interfaces) {
                    if (!i.equals(interfaceName)) continue;
                    matchedInterfaceName = i;
                    break;
                }
                if (matchedInterfaceName == null) continue;
                Map props = blueprintServiceMetadata.getServiceProperties();
                Hashtable dict = new Hashtable();
                Set entries = props.entrySet();
                for (Map.Entry serviceProp : entries) {
                    String key = (String)serviceProp.getKey();
                    Object objValue = serviceProp.getValue();
                    if (objValue.getClass().isArray()) {
                        ((Dictionary)dict).put(key, objValue);
                        continue;
                    }
                    String strValue = String.valueOf(objValue);
                    if (key.equals(SERVICE_EXPORTED_INTERFACES) && "*".equals(strValue)) {
                        strValue = ResourceModellingUtils.formatListAsCommaSeparatedString(interfaces);
                    }
                    ((Dictionary)dict).put(key, strValue);
                }
                if (filter != null && !filter.match(dict)) continue;
                if (filteringEBA) {
                    String remoteFilter = "(service.exported.interfaces=" + matchedInterfaceName + ")";
                    Filter checkForRemotable = FrameworkUtil.createFilter((String)remoteFilter);
                    if (!checkForRemotable.match(dict)) continue;
                    candidateMatches.add(blueprintServiceMetadata);
                    continue;
                }
                candidateMatches.add(blueprintServiceMetadata);
            }
        }
        while (candidateMatches.size() > 0) {
            WrappedServiceMetadata wsm = (WrappedServiceMetadata)candidateMatches.remove(0);
            ArrayList<WrappedServiceMetadata> dups = new ArrayList<WrappedServiceMetadata>();
            dups.add(wsm);
            Iterator iterator = candidateMatches.iterator();
            while (iterator.hasNext()) {
                WrappedServiceMetadata possibleDuplicate = (WrappedServiceMetadata)iterator.next();
                if (!wsm.identicalOrDiffersOnlyByName(possibleDuplicate)) continue;
                dups.add(possibleDuplicate);
                iterator.remove();
            }
            Collections.sort(dups);
            result.add((WrappedServiceMetadata)dups.get(0));
        }
        return result;
    }

    private static String formatListAsCommaSeparatedString(Collection<String> list) {
        StringBuffer buf = new StringBuffer();
        if (list == null || list.size() == 0) {
            return "";
        }
        for (String s : list) {
            buf.append(s);
            buf.append(",");
        }
        String result = buf.substring(0, buf.lastIndexOf(","));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static Collection<ImportedService> getBlueprintNamespaceReferences(ModellingManager modellingManager, IDirectory iDir) throws IOException {
        HashSet<String> namespaces = new HashSet<String>();
        for (IFile f : ResourceModellingUtils.findBlueprints(iDir)) {
            InputStream is = f.open();
            try {
                namespaces.addAll(ResourceModellingUtils.getBlueprintNamespaces(is));
            }
            finally {
                IOUtils.close((Closeable)is);
            }
        }
        namespaces.retainAll(ALLOWLISTED_XML_NAMESPACES);
        ArrayList<ImportedService> references = new ArrayList<ImportedService>();
        for (String ns : namespaces) {
            try {
                references.add(modellingManager.getImportedService(false, "org.apache.aries.blueprint.NamespaceHandler", null, "(osgi.service.blueprint.namespace=" + ns + ")", null, false));
            }
            catch (InvalidAttributeException invalidAttributeException) {
                void iae;
                FFDCFilter.processException((Throwable)invalidAttributeException, (String)"com.ibm.ws.eba.bundle.repository.internal.blueprint.ResourceModellingUtils", (String)"357", null, (Object[])new Object[]{modellingManager, iDir});
                FFDCFilter.processException((Throwable)iae, (String)ResourceModellingUtils.class.getName(), (String)"620");
            }
        }
        return references;
    }

    public static Collection<IFile> findBlueprints(IDirectory iDir) throws UnsupportedOperationException, IOException {
        ArrayList<IFile> result = new ArrayList<IFile>();
        Manifest mf = BundleManifest.fromBundle((IFile)iDir).getRawManifest();
        String bundleBlueprint = mf.getMainAttributes().getValue("Bundle-Blueprint");
        BundleBlueprintParser bpParser = new BundleBlueprintParser(bundleBlueprint);
        for (IFile f : iDir.listAllFiles()) {
            String name;
            String dirName = f.getParent().getName();
            if (!bpParser.isBPFile(dirName, name = f.getName().replaceFirst(dirName, ""))) continue;
            result.add(f);
        }
        return result;
    }

    private static Set<String> getBlueprintNamespaces(InputStream bpFile) {
        HashSet<String> namespaces = new HashSet<String>();
        try {
            XMLStreamReader reader = DesignatedXMLInputFactory.newInstance().createXMLStreamReader(bpFile);
            int event = reader.next();
            while (event != 8) {
                if (event == 1) {
                    for (int i = 0; i < reader.getNamespaceCount(); ++i) {
                        namespaces.add(reader.getNamespaceURI(i));
                    }
                }
                event = reader.next();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.eba.bundle.repository.internal.blueprint.ResourceModellingUtils", (String)"404", null, (Object[])new Object[]{bpFile});
        }
        return namespaces;
    }

    public static Collection<ModelledResource> modelJars(Collection<IFile> jarFiles, BundleContext ctx, TraceComponent tc) {
        ArrayList<ModelledResource> modelledBundles = new ArrayList<ModelledResource>();
        for (IFile f : jarFiles) {
            try {
                BundleManifest bm = BundleManifest.fromBundle((IFile)f);
                if (bm == null) continue;
                modelledBundles.add(ResourceModellingUtils.model(f.toURL().toURI().toString(), bm, f.convert(), ctx));
            }
            catch (InvalidAttributeException bm) {
                FFDCFilter.processException((Throwable)bm, (String)"com.ibm.ws.eba.bundle.repository.internal.blueprint.ResourceModellingUtils", (String)"419", null, (Object[])new Object[]{jarFiles, ctx, tc});
                if (!tc.isWarningEnabled()) continue;
                Tr.warning((TraceComponent)tc, (String)"warn.invalid.bundle", (Object[])new Object[]{f});
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.eba.bundle.repository.internal.blueprint.ResourceModellingUtils", (String)"423", null, (Object[])new Object[]{jarFiles, ctx, tc});
            }
        }
        return modelledBundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateOBR(WsResource repoXml, Collection<IFile> files, String pid, BundleContext ctx, final TraceComponent tc, Lock xml_lock, Object respositoryGenerator, RepositoryAdmin repoAdmin) {
        block21: {
            RepositoryGenerator repositoryGeneratorService;
            Collection<ModelledResource> models = ResourceModellingUtils.modelJars(files, ctx, tc);
            xml_lock.lock();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"OBR XML lock obtained", (Object[])new Object[]{xml_lock, repoXml});
            }
            if ((repositoryGeneratorService = (RepositoryGenerator)respositoryGenerator) != null) {
                try (OutputStream os = repoXml.putStream();){
                    repositoryGeneratorService.generateRepository(pid, models, os);
                    break block21;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to generate OBR.XML as the RepositoryGenerator service is not available", (Object[])new Object[0]);
            }
            xml_lock.unlock();
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return;
            Tr.debug((TraceComponent)tc, (String)"OBR XML lock released", (Object[])new Object[]{xml_lock, repoXml});
            return;
        }
        try {
            if (repoAdmin != null) {
                try {
                    repoAdmin.removeRepository(repoXml.toExternalURI().toURL());
                    repoAdmin.addRepository(repoXml.toExternalURI().toURL());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"RepositoryAdmin updated with bundle repository change", (Object[])new Object[]{pid});
                    }
                }
                catch (MalformedURLException os) {
                    FFDCFilter.processException((Throwable)os, (String)"com.ibm.ws.eba.bundle.repository.internal.blueprint.ResourceModellingUtils", (String)"462", null, (Object[])new Object[]{repoXml, files, pid, ctx, tc, xml_lock, respositoryGenerator, repoAdmin});
                }
                catch (Exception os) {
                    FFDCFilter.processException((Throwable)os, (String)"com.ibm.ws.eba.bundle.repository.internal.blueprint.ResourceModellingUtils", (String)"463", null, (Object[])new Object[]{repoXml, files, pid, ctx, tc, xml_lock, respositoryGenerator, repoAdmin});
                    final File file = repoXml.asFile();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Checking OBR XML file", (Object[])new Object[]{file.getAbsolutePath()});
                    }
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                if (!file.exists()) {
                                    Tr.debug((TraceComponent)tc, (String)"OBR XML file does not exist", (Object[])new Object[0]);
                                } else {
                                    Tr.debug((TraceComponent)tc, (String)("OBR XML file size on disk : " + file.length()), (Object[])new Object[0]);
                                }
                            }
                            return null;
                        }
                    });
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Failed to update RepositoryAdmin with bundle repository change", (Object[])new Object[]{pid});
            }
            xml_lock.unlock();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.eba.bundle.repository.internal.blueprint.ResourceModellingUtils", (String)"489", null, (Object[])new Object[]{repoXml, files, pid, ctx, tc, xml_lock, respositoryGenerator, repoAdmin});
            xml_lock.unlock();
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return;
            Tr.debug((TraceComponent)tc, (String)"OBR XML lock released", (Object[])new Object[]{xml_lock, repoXml});
            return;
        }
        catch (ResolverException resolverException) {
            FFDCFilter.processException((Throwable)resolverException, (String)"com.ibm.ws.eba.bundle.repository.internal.blueprint.ResourceModellingUtils", (String)"490", null, (Object[])new Object[]{repoXml, files, pid, ctx, tc, xml_lock, respositoryGenerator, repoAdmin});
            xml_lock.unlock();
            {
                catch (Throwable throwable) {
                    xml_lock.unlock();
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) throw throwable;
                    Tr.debug((TraceComponent)tc, (String)"OBR XML lock released", (Object[])new Object[]{xml_lock, repoXml});
                    throw throwable;
                }
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return;
            Tr.debug((TraceComponent)tc, (String)"OBR XML lock released", (Object[])new Object[]{xml_lock, repoXml});
            return;
        }
        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return;
        Tr.debug((TraceComponent)tc, (String)"OBR XML lock released", (Object[])new Object[]{xml_lock, repoXml});
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WsResource createOBR(Collection<IFile> ifiles, BundleContext ctx, WsLocationAdmin locationAdmin, Object generator, TraceComponent tc) {
        Collection<ModelledResource> models = ResourceModellingUtils.modelJars(ifiles, ctx, tc);
        if (locationAdmin == null) {
            Tr.warning((TraceComponent)tc, (String)"warn.missing.service", (Object[])new Object[]{"Location service"});
            return null;
        }
        ResourceResolver resolver = ResourceResolverFactory.createOBRXMLResolver(locationAdmin);
        WsResource xml = null;
        xml = resolver.getResource(UUID.randomUUID().toString());
        if (generator != null) {
            OutputStream out = null;
            try {
                out = xml.putStream();
                ((RepositoryGenerator)generator).generateRepository("VirtualRepository", models, out);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.eba.bundle.repository.internal.blueprint.ResourceModellingUtils", (String)"513", null, (Object[])new Object[]{ifiles, ctx, locationAdmin, generator, tc});
                WsResource wsResource = null;
                return wsResource;
            }
            finally {
                Utils.close(out);
            }
        } else {
            Tr.warning((TraceComponent)tc, (String)"warn.missing.service", (Object[])new Object[]{"RepositoryGenerator"});
            return null;
        }
        return xml;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.eba.bundle.repository.internal.blueprint.ResourceModellingUtils", ResourceModellingUtils.class, null, null);
        ALLOWLISTED_XML_NAMESPACES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("http://www.osgi.org/xmlns/blueprint/v1.0.0", "http://www.ibm.com/appserver/schemas/8.0/blueprint/resourcereference", "http://aries.apache.org/xmlns/transactions/v1.0.0", "http://aries.apache.org/xmlns/jpa/v1.0.0", "http://aries.apache.org/xmlns/jpa/v1.1.0", "http://aries.apache.org/blueprint/xmlns/blueprint-ext/v1.0.0")));
    }
}

