/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs2;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs2.util.ReaderUtils;
import io.swagger.oas.annotations.Parameter;
import io.swagger.oas.annotations.enums.Explode;
import io.swagger.oas.annotations.headers.Header;
import io.swagger.oas.annotations.info.Contact;
import io.swagger.oas.annotations.info.Info;
import io.swagger.oas.annotations.info.License;
import io.swagger.oas.annotations.links.Link;
import io.swagger.oas.annotations.links.LinkParameter;
import io.swagger.oas.annotations.media.Content;
import io.swagger.oas.annotations.media.Encoding;
import io.swagger.oas.annotations.media.ExampleObject;
import io.swagger.oas.annotations.media.Schema;
import io.swagger.oas.annotations.parameters.RequestBody;
import io.swagger.oas.annotations.responses.ApiResponse;
import io.swagger.oas.annotations.security.SecurityRequirement;
import io.swagger.oas.annotations.servers.Servers;
import io.swagger.oas.models.Components;
import io.swagger.oas.models.ExternalDocumentation;
import io.swagger.oas.models.examples.Example;
import io.swagger.oas.models.headers.Header;
import io.swagger.oas.models.media.ArraySchema;
import io.swagger.oas.models.media.MediaType;
import io.swagger.oas.models.responses.ApiResponses;
import io.swagger.oas.models.servers.Server;
import io.swagger.oas.models.servers.ServerVariable;
import io.swagger.oas.models.servers.ServerVariables;
import io.swagger.oas.models.tags.Tag;
import io.swagger.util.Json;
import io.swagger.util.ParameterProcessor;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OperationParser {
    public static final String RESPONSE_DEFAULT = "default";
    public static final String MEDIA_TYPE = "*/*";
    public static final String COMPONENTS_REF = "#/components/schemas/";
    public static final String DEFAULT_DESCRIPTION = "no description";
    public static final String COMMA = ",";
    static final long serialVersionUID = 2673496987919452670L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static Optional<List<io.swagger.oas.models.parameters.Parameter>> getParametersList(Parameter[] parameters, Components components) {
        if (parameters == null) {
            return Optional.empty();
        }
        ArrayList parametersObject = new ArrayList();
        for (Parameter parameter : parameters) {
            OperationParser.getParameter(parameter, components).ifPresent(parametersObject::add);
        }
        if (parametersObject.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(parametersObject);
    }

    public static Optional<io.swagger.oas.models.parameters.Parameter> getParameter(Parameter parameter, Components components) {
        if (parameter == null) {
            return Optional.empty();
        }
        io.swagger.oas.models.parameters.Parameter parameterObject = new io.swagger.oas.models.parameters.Parameter();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)parameter.description())) {
            parameterObject.setDescription(parameter.description());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)parameter.name())) {
            parameterObject.setName(parameter.name());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)parameter.in())) {
            parameterObject.setIn(parameter.in());
            isEmpty = false;
        }
        if (parameter.deprecated()) {
            parameterObject.setDeprecated(Boolean.valueOf(parameter.deprecated()));
        }
        if (parameter.required()) {
            parameterObject.setRequired(Boolean.valueOf(parameter.required()));
            isEmpty = false;
        }
        if (parameter.allowEmptyValue()) {
            parameterObject.setAllowEmptyValue(Boolean.valueOf(parameter.allowEmptyValue()));
            isEmpty = false;
        }
        if (parameter.allowReserved()) {
            parameterObject.setAllowReserved(Boolean.valueOf(parameter.allowReserved()));
            isEmpty = false;
        }
        ParameterProcessor.setParameterStyle((io.swagger.oas.models.parameters.Parameter)parameterObject, (Parameter)parameter);
        ParameterProcessor.setParameterExplode((io.swagger.oas.models.parameters.Parameter)parameterObject, (Parameter)parameter);
        if (!Explode.DEFAULT.equals((Object)parameter.explode())) {
            isEmpty = false;
        }
        OperationParser.getContent(parameter.content(), null, components).ifPresent(arg_0 -> ((io.swagger.oas.models.parameters.Parameter)parameterObject).setContent(arg_0));
        if (parameterObject.getContent() == null) {
            OperationParser.getArraySchema(parameter.array(), components).ifPresent(arg_0 -> ((io.swagger.oas.models.parameters.Parameter)parameterObject).setSchema(arg_0));
            if (parameterObject.getSchema() == null) {
                Class schemaImplementation = parameter.schema().implementation();
                if (schemaImplementation == Void.class) {
                    OperationParser.getSchemaFromAnnotation(parameter.schema()).ifPresent(schema -> {
                        if (StringUtils.isNotBlank((CharSequence)schema.getType())) {
                            parameterObject.setSchema(schema);
                        }
                    });
                } else {
                    io.swagger.oas.models.media.Schema schemaObject = new io.swagger.oas.models.media.Schema();
                    OperationParser.setReference(schemaObject, schemaImplementation, components);
                }
            }
        }
        if (parameterObject.getContent() != null || parameterObject.getSchema() != null) {
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(parameterObject);
    }

    private static void setReference(io.swagger.oas.models.media.Schema schemaObject, Class<?> schemaImplementation, Components components) {
        if (schemaImplementation.getName().startsWith("java.lang")) {
            schemaObject.setType(schemaImplementation.getSimpleName().toLowerCase());
        } else {
            Map schemaMap = ModelConverters.getInstance().readAll(schemaImplementation);
            schemaMap.forEach((key, schema) -> components.addSchemas(key, schema));
            schemaObject.set$ref(COMPONENTS_REF + schemaImplementation.getSimpleName());
        }
    }

    public static Optional<ArraySchema> getArraySchema(io.swagger.oas.annotations.media.ArraySchema arraySchema, Components components) {
        if (arraySchema == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        ArraySchema arraySchemaObject = new ArraySchema();
        if (arraySchema.uniqueItems()) {
            arraySchemaObject.setUniqueItems(Boolean.valueOf(arraySchema.uniqueItems()));
            isEmpty = false;
        }
        if (arraySchema.maxItems() > 0) {
            arraySchemaObject.setMaxItems(Integer.valueOf(arraySchema.maxItems()));
            isEmpty = false;
        }
        if (arraySchema.minItems() < Integer.MAX_VALUE) {
            arraySchemaObject.setMinItems(Integer.valueOf(arraySchema.minItems()));
            isEmpty = false;
        }
        if (arraySchema.schema() != null && StringUtils.isNotBlank((CharSequence)arraySchema.schema().type())) {
            Class schemaImplementation = arraySchema.schema().implementation();
            if (schemaImplementation == Void.class) {
                OperationParser.getSchemaFromAnnotation(arraySchema.schema()).ifPresent(schema -> {
                    if (StringUtils.isNotBlank((CharSequence)schema.getType())) {
                        arraySchemaObject.setItems(schema);
                    }
                });
            } else {
                OperationParser.setReference((io.swagger.oas.models.media.Schema)arraySchemaObject, schemaImplementation, components);
            }
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(arraySchemaObject);
    }

    public static Optional<io.swagger.oas.models.media.Schema> getSchemaFromAnnotation(Schema schema) {
        if (schema == null) {
            return Optional.empty();
        }
        io.swagger.oas.models.media.Schema schemaObject = new io.swagger.oas.models.media.Schema();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)schema.description())) {
            schemaObject.setDescription(schema.description());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)schema.ref())) {
            schemaObject.set$ref(schema.ref());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)schema.type())) {
            schemaObject.setType(schema.type());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)schema.defaultValue())) {
            schemaObject.setDefault((Object)schema.defaultValue());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)schema.example())) {
            schemaObject.setExample((Object)schema.example());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)schema.format())) {
            schemaObject.setFormat(schema.format());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)schema.pattern())) {
            schemaObject.setPattern(schema.pattern());
            isEmpty = false;
        }
        if (schema.readOnly()) {
            schemaObject.setReadOnly(Boolean.valueOf(schema.readOnly()));
            isEmpty = false;
        }
        if (schema.deprecated()) {
            schemaObject.setDeprecated(Boolean.valueOf(schema.deprecated()));
            isEmpty = false;
        }
        if (schema.exclusiveMaximum()) {
            schemaObject.setExclusiveMaximum(Boolean.valueOf(schema.exclusiveMaximum()));
            isEmpty = false;
        }
        if (schema.exclusiveMinimum()) {
            schemaObject.setExclusiveMinimum(Boolean.valueOf(schema.exclusiveMinimum()));
            isEmpty = false;
        }
        if (schema.maxProperties() > 0) {
            schemaObject.setMaxProperties(Integer.valueOf(schema.maxProperties()));
            isEmpty = false;
        }
        if (schema.maxLength() != Integer.MAX_VALUE && schema.maxLength() > 0) {
            schemaObject.setMaxLength(Integer.valueOf(schema.maxLength()));
            isEmpty = false;
        }
        if (schema.minProperties() > 0) {
            schemaObject.setMinProperties(Integer.valueOf(schema.minProperties()));
            isEmpty = false;
        }
        if (schema.minLength() > 0) {
            schemaObject.setMinLength(Integer.valueOf(schema.minLength()));
            isEmpty = false;
        }
        if (schema.multipleOf() != 0.0) {
            schemaObject.setMultipleOf(new BigDecimal(schema.multipleOf()));
            isEmpty = false;
        }
        if (NumberUtils.isCreatable((String)schema.maximum())) {
            String filteredMaximum = schema.maximum().replaceAll(COMMA, "");
            schemaObject.setMaximum(new BigDecimal(filteredMaximum));
            isEmpty = false;
        }
        if (NumberUtils.isCreatable((String)schema.minimum())) {
            String filteredMinimum = schema.minimum().replaceAll(COMMA, "");
            schemaObject.setMinimum(new BigDecimal(filteredMinimum));
            isEmpty = false;
        }
        if (schema.nullable()) {
            schemaObject.setNullable(Boolean.valueOf(schema.nullable()));
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)schema.title())) {
            schemaObject.setTitle(schema.title());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)schema.name())) {
            schemaObject.setName(schema.name());
            isEmpty = false;
        }
        if (schema.writeOnly()) {
            schemaObject.setWriteOnly(Boolean.valueOf(schema.writeOnly()));
            isEmpty = false;
        }
        ReaderUtils.getStringListFromStringArray(schema.requiredProperties()).ifPresent(arg_0 -> ((io.swagger.oas.models.media.Schema)schemaObject).setRequired(arg_0));
        ReaderUtils.getStringListFromStringArray(schema.allowableValues()).ifPresent(arg_0 -> ((io.swagger.oas.models.media.Schema)schemaObject).setEnum(arg_0));
        OperationParser.getExternalDocumentation(schema.externalDocs()).ifPresent(arg_0 -> ((io.swagger.oas.models.media.Schema)schemaObject).setExternalDocs(arg_0));
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(schemaObject);
    }

    public static Optional<Set<Tag>> getTags(String[] tags) {
        if (tags == null) {
            return Optional.empty();
        }
        LinkedHashSet<Tag> tagsList = new LinkedHashSet<Tag>();
        boolean isEmpty = true;
        for (String tag : tags) {
            Tag tagObject = new Tag();
            if (StringUtils.isNotBlank((CharSequence)tag)) {
                isEmpty = false;
            }
            tagObject.setDescription(tag);
            tagObject.setName(tag);
            tagsList.add(tagObject);
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(tagsList);
    }

    public static Optional<List<Server>> getServers(Servers servers) {
        if (servers == null) {
            return Optional.empty();
        }
        return OperationParser.getServers(servers.value());
    }

    public static Optional<List<Server>> getServers(io.swagger.oas.annotations.servers.Server[] servers) {
        if (servers == null) {
            return Optional.empty();
        }
        ArrayList serverObjects = new ArrayList();
        for (io.swagger.oas.annotations.servers.Server server : servers) {
            OperationParser.getServer(server).ifPresent(serverObjects::add);
        }
        if (serverObjects.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(serverObjects);
    }

    public static Optional<Server> getServer(io.swagger.oas.annotations.servers.Server server) {
        if (server == null) {
            return Optional.empty();
        }
        Server serverObject = new Server();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)server.url())) {
            serverObject.setUrl(server.url());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)server.description())) {
            serverObject.setDescription(server.description());
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        io.swagger.oas.annotations.servers.ServerVariable[] serverVariables = server.variables();
        ServerVariables serverVariablesObject = new ServerVariables();
        for (io.swagger.oas.annotations.servers.ServerVariable serverVariable : serverVariables) {
            ServerVariable serverVariableObject = new ServerVariable();
            if (StringUtils.isNotBlank((CharSequence)serverVariable.description())) {
                serverVariableObject.setDescription(serverVariable.description());
            }
            if (StringUtils.isNotBlank((CharSequence)serverVariable.defaultValue())) {
                serverVariableObject.setDefault(serverVariable.defaultValue());
            }
            serverVariablesObject.addServerVariable(serverVariable.name(), serverVariableObject);
        }
        serverObject.setVariables(serverVariablesObject);
        return Optional.of(serverObject);
    }

    public static Optional<ExternalDocumentation> getExternalDocumentation(io.swagger.oas.annotations.ExternalDocumentation externalDocumentation) {
        if (externalDocumentation == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        ExternalDocumentation external = new ExternalDocumentation();
        if (StringUtils.isNotBlank((CharSequence)externalDocumentation.description())) {
            isEmpty = false;
            external.setDescription(externalDocumentation.description());
        }
        if (StringUtils.isNotBlank((CharSequence)externalDocumentation.url())) {
            isEmpty = false;
            external.setUrl(externalDocumentation.url());
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(external);
    }

    public static Optional<io.swagger.oas.models.parameters.RequestBody> getRequestBody(RequestBody requestBody, Consumes consumes, Components components) {
        if (requestBody == null) {
            return Optional.empty();
        }
        io.swagger.oas.models.parameters.RequestBody requestBodyObject = new io.swagger.oas.models.parameters.RequestBody();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)requestBody.description())) {
            requestBodyObject.setDescription(requestBody.description());
            isEmpty = false;
        }
        if (requestBody.required()) {
            requestBodyObject.setRequired(Boolean.valueOf(requestBody.required()));
            isEmpty = false;
        }
        if (requestBody.content().length > 0) {
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        String[] consumesValues = null;
        if (consumes != null) {
            consumesValues = consumes.value();
        }
        OperationParser.getContent(requestBody.content(), consumesValues, components).ifPresent(arg_0 -> ((io.swagger.oas.models.parameters.RequestBody)requestBodyObject).setContent(arg_0));
        return Optional.of(requestBodyObject);
    }

    public static Optional<ApiResponses> getApiResponses(ApiResponse[] responses, Produces produces, Components components) {
        if (responses == null) {
            return Optional.empty();
        }
        ApiResponses apiResponsesObject = new ApiResponses();
        for (ApiResponse response : responses) {
            io.swagger.oas.models.responses.ApiResponse apiResponseObject = new io.swagger.oas.models.responses.ApiResponse();
            if (StringUtils.isNotBlank((CharSequence)response.description())) {
                apiResponseObject.setDescription(response.description());
            }
            String[] producesValues = null;
            if (produces != null) {
                producesValues = produces.value();
            }
            OperationParser.getContent(response.content(), producesValues, components).ifPresent(arg_0 -> ((io.swagger.oas.models.responses.ApiResponse)apiResponseObject).content(arg_0));
            OperationParser.getHeaders(response.headers(), components).ifPresent(arg_0 -> ((io.swagger.oas.models.responses.ApiResponse)apiResponseObject).headers(arg_0));
            if (!StringUtils.isNotBlank((CharSequence)apiResponseObject.getDescription()) && apiResponseObject.getContent() == null && apiResponseObject.getHeaders() == null) continue;
            Map<String, io.swagger.oas.models.links.Link> links = OperationParser.getLinks(response.links());
            if (links.size() > 0) {
                apiResponseObject.setLinks(links);
            }
            if (StringUtils.isNotBlank((CharSequence)response.responseCode())) {
                apiResponsesObject.addApiResponse(response.responseCode(), apiResponseObject);
                continue;
            }
            apiResponsesObject._default(apiResponseObject);
        }
        if (apiResponsesObject.isEmpty()) {
            io.swagger.oas.models.responses.ApiResponse apiResponseObject = new io.swagger.oas.models.responses.ApiResponse();
            apiResponseObject.setDescription(DEFAULT_DESCRIPTION);
            apiResponsesObject._default(apiResponseObject);
        }
        return Optional.of(apiResponsesObject);
    }

    private static MediaType handleImplementation(Components components, Content annotationContent, Class<?> schemaImplementation) {
        MediaType mediaType = new MediaType();
        if (schemaImplementation != Void.class) {
            io.swagger.oas.models.media.Schema schemaObject = new io.swagger.oas.models.media.Schema();
            OperationParser.setReference(schemaObject, schemaImplementation, components);
            mediaType.setSchema(schemaObject);
        } else {
            OperationParser.getSchemaFromAnnotation(annotationContent.schema()).ifPresent(arg_0 -> ((MediaType)mediaType).setSchema(arg_0));
        }
        return mediaType;
    }

    public static Optional<io.swagger.oas.models.media.Content> getContent(Content[] annotationContents, String[] mediaTypes, Components components) {
        if (annotationContents == null) {
            return Optional.empty();
        }
        io.swagger.oas.models.media.Content content = new io.swagger.oas.models.media.Content();
        for (Content annotationContent : annotationContents) {
            Encoding[] encodings;
            ExampleObject[] examples;
            io.swagger.oas.annotations.media.ArraySchema array = annotationContent.array();
            MediaType mediaType = new MediaType();
            if (StringUtils.isNotBlank((CharSequence)array.schema().type())) {
                OperationParser.getArraySchema(array, components).ifPresent(arg_0 -> ((MediaType)mediaType).setSchema(arg_0));
            } else {
                String[] schemaImplementation = annotationContent.schema().implementation();
                mediaType = OperationParser.handleImplementation(components, annotationContent, schemaImplementation);
            }
            if (StringUtils.isNotBlank((CharSequence)annotationContent.mediaType())) {
                content.addMediaType(annotationContent.mediaType(), mediaType);
            } else if (mediaType.getSchema() != null) {
                if (mediaTypes != null) {
                    for (String value : mediaTypes) {
                        content.addMediaType(value, mediaType);
                    }
                } else {
                    content.addMediaType(MEDIA_TYPE, mediaType);
                }
            }
            for (ExampleObject example : examples = annotationContent.examples()) {
                OperationParser.addExampleToMediaType(mediaType, example);
            }
            for (Encoding encoding : encodings = annotationContent.encoding()) {
                OperationParser.addEncodingToMediaType(mediaType, encoding, components);
            }
        }
        if (content.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(content);
    }

    public static Optional<Map<String, io.swagger.oas.models.headers.Header>> getHeaders(Header[] annotationHeaders, Components components) {
        if (annotationHeaders == null) {
            return Optional.empty();
        }
        HashMap headers = new HashMap();
        for (Header header : annotationHeaders) {
            OperationParser.getHeader(header, components).ifPresent(headerResult -> headers.put(header.name(), headerResult));
        }
        if (headers.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(headers);
    }

    public static Optional<io.swagger.oas.models.headers.Header> getHeader(Header header, Components components) {
        if (header == null) {
            return Optional.empty();
        }
        io.swagger.oas.models.headers.Header headerObject = new io.swagger.oas.models.headers.Header();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)header.ref())) {
            headerObject.set$ref(header.ref());
            return Optional.of(headerObject);
        }
        if (StringUtils.isNotBlank((CharSequence)header.description())) {
            headerObject.setDescription(header.description());
            isEmpty = false;
        }
        if (header.deprecated()) {
            headerObject.setDeprecated(Boolean.valueOf(header.deprecated()));
        }
        if (header.required()) {
            headerObject.setRequired(Boolean.valueOf(header.required()));
            isEmpty = false;
        }
        if (header.allowEmptyValue()) {
            headerObject.setAllowEmptyValue(Boolean.valueOf(header.allowEmptyValue()));
            isEmpty = false;
        }
        headerObject.setStyle(Header.StyleEnum.SIMPLE);
        if (header.schema() != null && header.schema().implementation() == Void.class) {
            OperationParser.getSchemaFromAnnotation(header.schema()).ifPresent(schema -> {
                if (StringUtils.isNotBlank((CharSequence)schema.getType())) {
                    headerObject.setSchema(schema);
                }
            });
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(headerObject);
    }

    @FFDCIgnore(value={JsonProcessingException.class})
    public static void addExampleToMediaType(MediaType mediaType, ExampleObject example) {
        if (example == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)example.name())) {
            Example exampleObject = new Example();
            if (StringUtils.isNotBlank((CharSequence)example.name())) {
                exampleObject.setDescription(example.name());
            }
            if (StringUtils.isNotBlank((CharSequence)example.summary())) {
                exampleObject.setSummary(example.summary());
            }
            if (StringUtils.isNotBlank((CharSequence)example.externalValue())) {
                exampleObject.setExternalValue(example.externalValue());
            }
            if (StringUtils.isNotBlank((CharSequence)example.value())) {
                try {
                    exampleObject.setValue((Object)Json.mapper().readTree(example.value()));
                }
                catch (JsonProcessingException e) {
                    exampleObject.setValue((Object)example.value());
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, (String)"io.swagger.jaxrs2.OperationParser", (String)"632", null, (Object[])new Object[]{mediaType, example});
                    exampleObject.setValue((Object)example.value());
                }
            }
            mediaType.addExamples(example.name(), exampleObject);
        }
    }

    public static void addEncodingToMediaType(MediaType mediaType, Encoding encoding, Components components) {
        if (encoding == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)encoding.name())) {
            io.swagger.oas.models.media.Encoding encodingObject = new io.swagger.oas.models.media.Encoding();
            if (StringUtils.isNotBlank((CharSequence)encoding.contentType())) {
                encodingObject.setContentType(encoding.contentType());
            }
            if (StringUtils.isNotBlank((CharSequence)encoding.style())) {
                encodingObject.setStyle(encoding.style());
            }
            if (encoding.explode()) {
                encodingObject.setExplode(Boolean.valueOf(encoding.explode()));
            }
            if (encoding.allowReserved()) {
                encodingObject.setAllowReserved(Boolean.valueOf(encoding.allowReserved()));
            }
            if (encoding.headers() != null) {
                OperationParser.getHeaders(encoding.headers(), components).ifPresent(arg_0 -> ((io.swagger.oas.models.media.Encoding)encodingObject).headers(arg_0));
            }
            mediaType.addEncoding(encoding.name(), encodingObject);
        }
    }

    public static Optional<io.swagger.oas.models.info.Info> getInfo(Info info) {
        if (info == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        io.swagger.oas.models.info.Info infoObject = new io.swagger.oas.models.info.Info();
        if (StringUtils.isNotBlank((CharSequence)info.description())) {
            infoObject.setDescription(info.description());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)info.termsOfService())) {
            infoObject.setTermsOfService(info.termsOfService());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)info.title())) {
            infoObject.setTitle(info.title());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)info.version())) {
            infoObject.setVersion(info.version());
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        OperationParser.getContact(info.contact()).ifPresent(arg_0 -> ((io.swagger.oas.models.info.Info)infoObject).setContact(arg_0));
        OperationParser.getLicense(info.license()).ifPresent(arg_0 -> ((io.swagger.oas.models.info.Info)infoObject).setLicense(arg_0));
        return Optional.of(infoObject);
    }

    public static Optional<io.swagger.oas.models.info.Contact> getContact(Contact contact) {
        if (contact == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        io.swagger.oas.models.info.Contact contactObject = new io.swagger.oas.models.info.Contact();
        if (StringUtils.isNotBlank((CharSequence)contact.email())) {
            contactObject.setEmail(contact.email());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)contact.name())) {
            contactObject.setName(contact.name());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)contact.url())) {
            contactObject.setUrl(contact.url());
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(contactObject);
    }

    public static Optional<io.swagger.oas.models.info.License> getLicense(License license) {
        if (license == null) {
            return Optional.empty();
        }
        io.swagger.oas.models.info.License licenseObject = new io.swagger.oas.models.info.License();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)license.name())) {
            licenseObject.setName(license.name());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)license.url())) {
            licenseObject.setUrl(license.url());
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(licenseObject);
    }

    public static Map<String, io.swagger.oas.models.links.Link> getLinks(Link[] links) {
        HashMap<String, io.swagger.oas.models.links.Link> linkMap = new HashMap<String, io.swagger.oas.models.links.Link>();
        if (links == null) {
            return linkMap;
        }
        for (Link link : links) {
            OperationParser.getLink(link).ifPresent(linkResult -> linkMap.put(link.name(), (io.swagger.oas.models.links.Link)linkResult));
        }
        return linkMap;
    }

    public static Optional<io.swagger.oas.models.links.Link> getLink(Link link) {
        if (link == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        io.swagger.oas.models.links.Link linkObject = new io.swagger.oas.models.links.Link();
        if (StringUtils.isNotBlank((CharSequence)link.description())) {
            linkObject.setDescription(link.description());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)link.operationId())) {
            linkObject.setOperationId(link.operationId());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)link.operationRef())) {
            linkObject.setOperationRef(link.operationRef());
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        Map<String, String> linkParameters = OperationParser.getLinkParameters(link.parameters());
        if (linkParameters.size() > 0) {
            linkObject.setParameters(linkParameters);
        }
        return Optional.of(linkObject);
    }

    public static Map<String, String> getLinkParameters(LinkParameter[] linkParameter) {
        HashMap<String, String> linkParametersMap = new HashMap<String, String>();
        if (linkParameter == null) {
            return linkParametersMap;
        }
        for (LinkParameter parameter : linkParameter) {
            if (!StringUtils.isNotBlank((CharSequence)parameter.name())) continue;
            linkParametersMap.put(parameter.name(), parameter.expression());
        }
        return linkParametersMap;
    }

    public static Optional<List<io.swagger.oas.models.security.SecurityRequirement>> getSecurityRequirements(SecurityRequirement[] security) {
        if (security == null) {
            return Optional.empty();
        }
        ArrayList<io.swagger.oas.models.security.SecurityRequirement> securityRequirements = new ArrayList<io.swagger.oas.models.security.SecurityRequirement>();
        for (SecurityRequirement sec : security) {
            String name = sec.name();
            if (StringUtils.isBlank((CharSequence)name)) continue;
            io.swagger.oas.models.security.SecurityRequirement securityRequirementObject = new io.swagger.oas.models.security.SecurityRequirement();
            if (sec.scopes().length > 0) {
                securityRequirementObject.addList(name, Arrays.asList(sec.scopes()));
            } else {
                securityRequirementObject.addList(name);
            }
            securityRequirements.add(securityRequirementObject);
        }
        if (securityRequirements.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(securityRequirements);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.swagger.jaxrs2.OperationParser", OperationParser.class, null, null);
    }
}

