/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs2;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.openapi.SwaggerConfiguration;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs2.OperationParser;
import io.swagger.jaxrs2.SecurityParser;
import io.swagger.jaxrs2.ext.OpenAPIExtension;
import io.swagger.jaxrs2.ext.OpenAPIExtensions;
import io.swagger.jaxrs2.util.ReaderUtils;
import io.swagger.oas.annotations.ExternalDocumentation;
import io.swagger.oas.annotations.OpenAPIDefinition;
import io.swagger.oas.annotations.Operation;
import io.swagger.oas.annotations.callbacks.Callback;
import io.swagger.oas.annotations.callbacks.Callbacks;
import io.swagger.oas.annotations.info.Info;
import io.swagger.oas.annotations.security.SecurityRequirement;
import io.swagger.oas.annotations.security.SecurityScheme;
import io.swagger.oas.annotations.servers.Servers;
import io.swagger.oas.annotations.tags.Tags;
import io.swagger.oas.integration.OpenAPIConfiguration;
import io.swagger.oas.integration.OpenAPIReader;
import io.swagger.oas.models.Components;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.PathItem;
import io.swagger.oas.models.Paths;
import io.swagger.oas.models.headers.Header;
import io.swagger.oas.models.media.Content;
import io.swagger.oas.models.media.MediaType;
import io.swagger.oas.models.media.Schema;
import io.swagger.oas.models.parameters.Parameter;
import io.swagger.oas.models.parameters.RequestBody;
import io.swagger.oas.models.responses.ApiResponse;
import io.swagger.oas.models.responses.ApiResponses;
import io.swagger.oas.models.servers.Server;
import io.swagger.oas.models.tags.Tag;
import io.swagger.util.Json;
import io.swagger.util.ParameterProcessor;
import io.swagger.util.PathUtils;
import io.swagger.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Reader
implements OpenAPIReader {
    public static final String DEFAULT_MEDIA_TYPE_VALUE = "*/*";
    protected OpenAPIConfiguration config;
    private OpenAPI openAPI = new OpenAPI();
    private final Components components;
    private final Paths paths = new Paths();
    private final Set<Tag> openApiTags = new LinkedHashSet<Tag>();
    Consumes classConsumes;
    Produces classProduces;
    Produces methodProduces;
    Consumes methodConsumes;
    private static final String GET_METHOD = "get";
    private static final String POST_METHOD = "post";
    private static final String PUT_METHOD = "put";
    private static final String DELETE_METHOD = "delete";
    private static final String PATCH_METHOD = "patch";
    private static final String TRACE_METHOD = "trace";
    private static final String HEAD_METHOD = "head";
    private static final String OPTIONS_METHOD = "options";
    static final long serialVersionUID = 6766527221193388855L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Reader() {
        this.components = new Components();
    }

    public Reader(OpenAPI openAPI) {
        this();
        this.setConfiguration((OpenAPIConfiguration)new SwaggerConfiguration().openAPI(openAPI));
    }

    public Reader(OpenAPIConfiguration openApiConfiguration) {
        this();
        this.setConfiguration(openApiConfiguration);
    }

    public OpenAPI getOpenAPI() {
        return this.openAPI;
    }

    public OpenAPI read(Class<?> cls) {
        return this.read(cls, "");
    }

    public OpenAPI read(Set<Class<?>> classes) {
        TreeSet sortedClasses = new TreeSet(new Comparator<Class<?>>(){
            static final long serialVersionUID = -5640813410685206691L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public int compare(Class<?> class1, Class<?> class2) {
                if (class1.equals(class2)) {
                    return 0;
                }
                if (class1.isAssignableFrom(class2)) {
                    return -1;
                }
                if (class2.isAssignableFrom(class1)) {
                    return 1;
                }
                return class1.getName().compareTo(class2.getName());
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.swagger.jaxrs2.Reader$1", 1.class, null, null);
            }
        });
        sortedClasses.addAll(classes);
        for (Class clazz : sortedClasses) {
            this.read(clazz, "");
        }
        if (this.openAPI != null && this.openAPI.getInfo() == null) {
            this.openAPI.info(new io.swagger.oas.models.info.Info().title("API").version("1.0"));
        }
        return this.openAPI;
    }

    public void setConfiguration(OpenAPIConfiguration openApiConfiguration) {
        if (openApiConfiguration != null) {
            this.config = ReaderUtils.deepCopy(openApiConfiguration);
            if (openApiConfiguration.getOpenAPI() != null) {
                this.openAPI = this.config.getOpenAPI();
            }
        }
    }

    public OpenAPI read(Set<Class<?>> classes, Map<String, Object> resources) {
        return this.read(classes);
    }

    public OpenAPI read(Class<?> cls, String parentPath) {
        Method[] methods;
        Optional<List<Server>> optionalServers;
        SecurityScheme apiSecurityScheme = (SecurityScheme)ReflectionUtils.getAnnotation(cls, SecurityScheme.class);
        ExternalDocumentation apiExternalDocs = (ExternalDocumentation)ReflectionUtils.getAnnotation(cls, ExternalDocumentation.class);
        Info apiInfo = (Info)ReflectionUtils.getAnnotation(cls, Info.class);
        Servers apiServers = (Servers)ReflectionUtils.getAnnotation(cls, Servers.class);
        OpenAPIDefinition apiDefinition = (OpenAPIDefinition)ReflectionUtils.getAnnotation(cls, OpenAPIDefinition.class);
        this.classConsumes = (Consumes)ReflectionUtils.getAnnotation(cls, Consumes.class);
        this.classProduces = (Produces)ReflectionUtils.getAnnotation(cls, Produces.class);
        Optional<io.swagger.oas.models.security.SecurityScheme> securityScheme = SecurityParser.getSecurityScheme(apiSecurityScheme);
        if (securityScheme.isPresent()) {
            HashMap<String, io.swagger.oas.models.security.SecurityScheme> securitySchemeMap = new HashMap<String, io.swagger.oas.models.security.SecurityScheme>();
            if (StringUtils.isNotBlank((CharSequence)apiSecurityScheme.schemeName())) {
                securitySchemeMap.put(apiSecurityScheme.schemeName(), securityScheme.get());
                if (this.components.getSecuritySchemes() != null && this.components.getSecuritySchemes().size() != 0) {
                    this.components.getSecuritySchemes().putAll(securitySchemeMap);
                } else {
                    this.components.setSecuritySchemes(securitySchemeMap);
                }
            }
        }
        List<Server> globalServers = (optionalServers = OperationParser.getServers(apiServers)).isPresent() ? optionalServers.get() : null;
        Tags tagsAnnotations = (Tags)ReflectionUtils.getAnnotation(cls, Tags.class);
        Optional<Set<Tag>> tags = Reader.getTags(tagsAnnotations);
        if (tags.isPresent()) {
            Set<Tag> tagsSet = Reader.mergeTags(this.openApiTags, tags.get());
            this.openApiTags.clear();
            this.openApiTags.addAll(tagsSet);
        }
        Path apiPath = (Path)ReflectionUtils.getAnnotation(cls, Path.class);
        JavaType classType = TypeFactory.defaultInstance().constructType(cls);
        BeanDescription bd = Json.mapper().getSerializationConfig().introspect(classType);
        ArrayList<Parameter> globalParameters = new ArrayList<Parameter>();
        globalParameters.addAll(ReaderUtils.collectConstructorParameters(cls, this.openAPI));
        globalParameters.addAll(ReaderUtils.collectFieldParameters(cls, this.openAPI));
        for (Method method : methods = cls.getMethods()) {
            JavaType type;
            String httpMethod;
            io.swagger.oas.models.Operation operation;
            RequestBody requestBody = new RequestBody();
            AnnotatedMethod annotatedMethod = bd.findMethod(method.getName(), (Class[])method.getParameterTypes());
            this.methodProduces = (Produces)ReflectionUtils.getAnnotation((Method)method, Produces.class);
            this.methodConsumes = (Consumes)ReflectionUtils.getAnnotation((Method)method, Consumes.class);
            if (ReflectionUtils.isOverriddenMethod((Method)method, cls)) continue;
            Path methodPath = (Path)ReflectionUtils.getAnnotation((Method)method, Path.class);
            Consumes methodConsumes = (Consumes)ReflectionUtils.getAnnotation((Method)method, Consumes.class);
            String operationPath = ReaderUtils.getPath(apiPath, methodPath, parentPath);
            LinkedHashMap regexMap = new LinkedHashMap();
            if ((operationPath = PathUtils.parsePath((String)operationPath, regexMap)) == null || ReaderUtils.isIgnored(operationPath, this.config) || (operation = this.parseMethod(method)) == null) continue;
            PathItem pathItemObject = this.openAPI.getPaths() != null && this.openAPI.getPaths().get((Object)operationPath) != null ? (PathItem)this.openAPI.getPaths().get((Object)operationPath) : new PathItem();
            if (globalServers != null && !globalServers.isEmpty() && (operation.getServers() == null || operation.getServers().isEmpty())) {
                operation.servers(globalServers);
            }
            if (!StringUtils.isNotBlank((CharSequence)(httpMethod = ReaderUtils.extractOperationMethod(operation, method, OpenAPIExtensions.chain())))) continue;
            this.setPathItemOperation(pathItemObject, httpMethod, operation);
            ArrayList<Parameter> operationParameters = new ArrayList<Parameter>();
            Annotation[][] paramAnnotations = ReflectionUtils.getParameterAnnotations((Method)method);
            if (annotatedMethod == null) {
                Type[] genericParameterTypes = method.getGenericParameterTypes();
                for (int i = 0; i < genericParameterTypes.length; ++i) {
                    type = TypeFactory.defaultInstance().constructType(genericParameterTypes[i], cls);
                    operationParameters.addAll(this.getParameters((Type)type, Arrays.asList(paramAnnotations[i])));
                }
            } else {
                for (int i = 0; i < annotatedMethod.getParameterCount(); ++i) {
                    AnnotatedParameter param = annotatedMethod.getParameter(i);
                    type = TypeFactory.defaultInstance().constructType(param.getParameterType(), cls);
                    List<Parameter> parameters = this.getParameters((Type)type, Arrays.asList(paramAnnotations[i]));
                    for (Parameter parameter : parameters) {
                        Schema parameterSchema = parameter.getSchema();
                        if (StringUtils.isNotBlank((CharSequence)parameter.getIn())) {
                            operationParameters.add(parameter);
                            continue;
                        }
                        if (operation.getRequestBody() != null) continue;
                        boolean isRequestBodyEmpty = true;
                        if (StringUtils.isNotBlank((CharSequence)parameter.get$ref())) {
                            requestBody.set$ref(parameter.get$ref());
                            isRequestBodyEmpty = false;
                        }
                        if (StringUtils.isNotBlank((CharSequence)parameter.getDescription())) {
                            requestBody.setDescription(parameter.getDescription());
                            isRequestBodyEmpty = false;
                        }
                        if (Boolean.TRUE.equals(parameter.getRequired())) {
                            requestBody.setRequired(parameter.getRequired());
                            isRequestBodyEmpty = false;
                        }
                        if (parameter.getSchema() != null) {
                            Content content = new Content();
                            if (methodConsumes != null) {
                                for (String value : methodConsumes.value()) {
                                    this.setMediaTypeToContent(parameter.getSchema(), content, value);
                                }
                            } else if (this.classConsumes != null) {
                                for (String value : this.classConsumes.value()) {
                                    this.setMediaTypeToContent(parameter.getSchema(), content, value);
                                }
                            } else {
                                this.setMediaTypeToContent(parameter.getSchema(), content, DEFAULT_MEDIA_TYPE_VALUE);
                            }
                            requestBody.setContent(content);
                            isRequestBodyEmpty = false;
                        }
                        if (isRequestBodyEmpty) continue;
                        if (parameterSchema != null) {
                            Map schemaMap = ModelConverters.getInstance().readAll((Type)type);
                            schemaMap.forEach((key, schema) -> this.components.addSchemas(key, schema));
                        }
                        operation.setRequestBody(requestBody);
                    }
                }
            }
            if (operationParameters.size() > 0) {
                operation.setParameters(operationParameters);
            }
            if (tags.isPresent() && operation.getTags() == null) {
                tags.get().stream().forEach(tag -> operation.addTagsItem(tag.getName()));
            }
            this.paths.addPathItem(operationPath, pathItemObject);
            if (this.openAPI.getPaths() != null) {
                this.paths.putAll((Map)this.openAPI.getPaths());
            }
            this.openAPI.setPaths(this.paths);
        }
        if (this.components.getSecuritySchemes() != null && this.components.getSecuritySchemes().size() > 0 || this.components.getSchemas() != null && this.components.getSchemas().size() > 0) {
            this.openAPI.setComponents(this.components);
        }
        if (!this.openApiTags.isEmpty()) {
            Set<Tag> tagsSet = Reader.mergeTags(this.openApiTags, this.openAPI.getTags() != null ? new HashSet(this.openAPI.getTags()) : Collections.emptySet());
            this.openAPI.setTags(new ArrayList<Tag>(tagsSet));
        }
        OperationParser.getExternalDocumentation(apiExternalDocs).ifPresent(externalDocumentation -> this.openAPI.setExternalDocs(externalDocumentation));
        OperationParser.getInfo(apiInfo).ifPresent(info -> this.openAPI.setInfo(info));
        this.setOpenAPIFromDefinitions(apiDefinition);
        return this.openAPI;
    }

    private void setOpenAPIFromDefinitions(OpenAPIDefinition apiDefinition) {
        Optional<Components> optComponents;
        if (apiDefinition == null) {
            return;
        }
        OperationParser.getInfo(apiDefinition.info()).ifPresent(arg_0 -> ((OpenAPI)this.openAPI).setInfo(arg_0));
        OperationParser.getServers(apiDefinition.servers()).ifPresent(arg_0 -> ((OpenAPI)this.openAPI).servers(arg_0));
        OperationParser.getSecurityRequirements(apiDefinition.security()).ifPresent(arg_0 -> ((OpenAPI)this.openAPI).setSecurity(arg_0));
        OperationParser.getExternalDocumentation(apiDefinition.externalDocs()).ifPresent(arg_0 -> ((OpenAPI)this.openAPI).setExternalDocs(arg_0));
        Optional<Set<Tag>> maybe = Reader.getTags(apiDefinition.tags());
        if (maybe.isPresent()) {
            Set<Tag> tagsSet = Reader.mergeTags(this.openApiTags, maybe.get());
            this.openApiTags.clear();
            this.openApiTags.addAll(tagsSet);
            tagsSet = Reader.mergeTags(this.openApiTags, this.openAPI.getTags() != null ? new HashSet(this.openAPI.getTags()) : Collections.emptySet());
            this.openAPI.setTags(new ArrayList<Tag>(tagsSet));
        }
        if ((optComponents = this.getComponents(apiDefinition.components())).isPresent()) {
            if (this.openAPI.getComponents() == null) {
                this.openAPI.setComponents(optComponents.get());
            } else {
                Components openAPIComponents = this.openAPI.getComponents();
                Map headersToAdd = optComponents.get().getHeaders();
                if (headersToAdd != null && headersToAdd.size() > 0) {
                    if (openAPIComponents.getHeaders() == null) {
                        openAPIComponents.setHeaders(headersToAdd);
                    } else {
                        openAPIComponents.getHeaders().putAll(headersToAdd);
                    }
                }
            }
        }
    }

    private void setMediaTypeToContent(Schema schema, Content content, String value) {
        MediaType mediaTypeObject = new MediaType();
        mediaTypeObject.setSchema(schema);
        content.addMediaType(value, mediaTypeObject);
    }

    public io.swagger.oas.models.Operation parseMethod(Method method) {
        JavaType classType = TypeFactory.defaultInstance().constructType(method.getDeclaringClass());
        return this.parseMethod(classType.getClass(), method);
    }

    private io.swagger.oas.models.Operation parseMethod(Class<?> cls, Method method) {
        io.swagger.oas.models.Operation operation = new io.swagger.oas.models.Operation();
        Operation apiOperation = (Operation)ReflectionUtils.getAnnotation((Method)method, Operation.class);
        Callback apiCallback = (Callback)ReflectionUtils.getAnnotation((Method)method, Callback.class);
        SecurityRequirement apiSecurity = (SecurityRequirement)ReflectionUtils.getAnnotation((Method)method, SecurityRequirement.class);
        Callbacks apiCallbacks = (Callbacks)ReflectionUtils.getAnnotation((Method)method, Callbacks.class);
        if (apiOperation != null) {
            Map<String, io.swagger.oas.models.callbacks.Callback> callbacks = this.getCallbacks(apiCallback);
            if (apiCallbacks != null) {
                Callback[] containerCallbacks;
                for (Callback methodCallback : containerCallbacks = apiCallbacks.value()) {
                    Map<String, io.swagger.oas.models.callbacks.Callback> currentCallbacks = this.getCallbacks(methodCallback);
                    callbacks.putAll(currentCallbacks);
                }
            }
            if (callbacks.size() > 0) {
                operation.setCallbacks(callbacks);
            }
            SecurityParser.getSecurityRequirement(apiSecurity).ifPresent(arg_0 -> ((io.swagger.oas.models.Operation)operation).setSecurity(arg_0));
            this.setOperationObjectFromApiOperationAnnotation(operation, apiOperation);
            if (StringUtils.isBlank((CharSequence)operation.getOperationId())) {
                operation.setOperationId(method.getName());
            }
        }
        this.createDefaultResponses(method, operation);
        return operation;
    }

    private void createDefaultResponses(Method method, io.swagger.oas.models.Operation operation) {
        if (operation.getResponses() == null) {
            ApiResponses responses = new ApiResponses();
            ApiResponse response = new ApiResponse();
            response.setDescription("Default response");
            Content content = new Content();
            MediaType mediaTypeObject = null;
            if (!this.shouldIgnoreClass(method.getGenericReturnType().getTypeName())) {
                Type returnType = method.getGenericReturnType();
                Map schemas = ModelConverters.getInstance().readAll(returnType);
                Schema res_schema = ModelConverters.getInstance().resolveProperty(returnType);
                mediaTypeObject = new MediaType();
                mediaTypeObject.setSchema(res_schema);
                schemas.forEach((k, v) -> this.components.addSchemas(k, v));
            }
            String[] mediaTypes = null;
            mediaTypes = this.methodProduces != null ? this.methodProduces.value() : (this.classProduces != null ? this.classProduces.value() : new String[]{DEFAULT_MEDIA_TYPE_VALUE});
            for (String mediaType : mediaTypes) {
                if (mediaTypeObject == null) continue;
                content.addMediaType(mediaType, mediaTypeObject);
            }
            if (content.size() > 0) {
                response.setContent(content);
            }
            responses._default(response);
            operation.responses(responses);
        }
    }

    private boolean shouldIgnoreClass(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return true;
        }
        boolean ignore = false;
        ignore = ignore || className.startsWith("javax.ws.rs.");
        ignore = ignore || className.equalsIgnoreCase("void");
        return ignore;
    }

    private Map<String, io.swagger.oas.models.callbacks.Callback> getCallbacks(Callback apiCallback) {
        HashMap<String, io.swagger.oas.models.callbacks.Callback> callbackMap = new HashMap<String, io.swagger.oas.models.callbacks.Callback>();
        if (apiCallback == null) {
            return callbackMap;
        }
        io.swagger.oas.models.callbacks.Callback callbackObject = new io.swagger.oas.models.callbacks.Callback();
        PathItem pathItemObject = new PathItem();
        for (Operation callbackOperation : apiCallback.operation()) {
            io.swagger.oas.models.Operation callbackNewOperation = new io.swagger.oas.models.Operation();
            this.setOperationObjectFromApiOperationAnnotation(callbackNewOperation, callbackOperation);
            this.setPathItemOperation(pathItemObject, callbackOperation.method(), callbackNewOperation);
        }
        callbackObject.addPathItem(apiCallback.callbackUrlExpression(), pathItemObject);
        callbackMap.put(apiCallback.name(), callbackObject);
        return callbackMap;
    }

    private Optional<Components> getComponents(io.swagger.oas.annotations.Components annotationComponents) {
        if (annotationComponents == null) {
            return Optional.empty();
        }
        Components components = new Components();
        boolean isEmpty = true;
        Optional<Map<String, Header>> headers = OperationParser.getHeaders(annotationComponents.headers(), null);
        if (headers.isPresent()) {
            components.setHeaders(headers.get());
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(components);
    }

    private static Optional<Set<Tag>> getTags(Tags tags) {
        if (tags == null || tags.value() == null && tags.tags() == null) {
            return Optional.empty();
        }
        boolean isEmpty = true;
        LinkedHashSet<Tag> tagsSetFromValue = new LinkedHashSet<Tag>();
        OperationParser.getTags(tags.value()).ifPresent(tagsSetFromValue::addAll);
        isEmpty &= tagsSetFromValue.isEmpty();
        LinkedHashSet<Tag> tagsSetFromTags = new LinkedHashSet<Tag>();
        Reader.getTags(tags.tags()).ifPresent(tagsSetFromTags::addAll);
        if (isEmpty &= tagsSetFromTags.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new HashSet<Tag>(Reader.mergeTags(tagsSetFromValue, tagsSetFromTags)));
    }

    private static Optional<Set<Tag>> getTags(io.swagger.oas.annotations.tags.Tag[] allTags) {
        if (allTags == null || allTags.length == 0) {
            return Optional.empty();
        }
        LinkedHashSet<Tag> tagsSetFromTags = new LinkedHashSet<Tag>();
        for (io.swagger.oas.annotations.tags.Tag tag : allTags) {
            if (!StringUtils.isNotBlank((CharSequence)tag.name())) continue;
            Tag tagObject = new Tag();
            tagObject.setName(tag.name());
            tagObject.setDescription(tag.description());
            OperationParser.getExternalDocumentation(tag.externalDocs()).ifPresent(arg_0 -> ((Tag)tagObject).setExternalDocs(arg_0));
            tagsSetFromTags.add(tagObject);
        }
        if (tagsSetFromTags.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new HashSet(tagsSetFromTags));
    }

    private static Set<Tag> mergeTags(Set<Tag> tags1, Set<Tag> tags2) {
        if (tags1 == null || tags2 == null) {
            return tags1 != null ? tags1 : (tags2 != null ? tags2 : Collections.emptySet());
        }
        HashSet<Tag> merged = new HashSet<Tag>();
        merged.addAll(tags1);
        for (Tag tag2 : tags2) {
            boolean found = false;
            for (Tag tag1 : tags1) {
                if (!Objects.equals(tag1.getName(), tag2.getName())) continue;
                if (StringUtils.isBlank((CharSequence)tag1.getDescription()) || Objects.equals(tag1.getName(), tag1.getDescription())) {
                    tag1.setDescription(tag2.getDescription());
                }
                if (tag1.getExternalDocs() == null) {
                    tag1.setExternalDocs(tag2.getExternalDocs());
                }
                found = true;
            }
            if (found) continue;
            merged.add(tag2);
        }
        return merged;
    }

    private void setPathItemOperation(PathItem pathItemObject, String method, io.swagger.oas.models.Operation callbackNewOperation) {
        switch (method) {
            case "post": {
                pathItemObject.post(callbackNewOperation);
                break;
            }
            case "get": {
                pathItemObject.get(callbackNewOperation);
                break;
            }
            case "delete": {
                pathItemObject.delete(callbackNewOperation);
                break;
            }
            case "put": {
                pathItemObject.put(callbackNewOperation);
                break;
            }
            case "patch": {
                pathItemObject.patch(callbackNewOperation);
                break;
            }
            case "trace": {
                pathItemObject.trace(callbackNewOperation);
                break;
            }
            case "head": {
                pathItemObject.head(callbackNewOperation);
                break;
            }
            case "options": {
                pathItemObject.options(callbackNewOperation);
                break;
            }
        }
    }

    private void setOperationObjectFromApiOperationAnnotation(io.swagger.oas.models.Operation operation, Operation apiOperation) {
        if (StringUtils.isNotBlank((CharSequence)apiOperation.summary())) {
            operation.setSummary(apiOperation.summary());
        }
        if (StringUtils.isNotBlank((CharSequence)apiOperation.description())) {
            operation.setDescription(apiOperation.description());
        }
        if (StringUtils.isNotBlank((CharSequence)apiOperation.operationId())) {
            operation.setOperationId(this.getOperationId(apiOperation.operationId()));
        }
        if (apiOperation.deprecated()) {
            operation.setDeprecated(Boolean.valueOf(apiOperation.deprecated()));
        }
        ReaderUtils.getStringListFromStringArray(apiOperation.tags()).ifPresent(arg_0 -> ((io.swagger.oas.models.Operation)operation).setTags(arg_0));
        OperationParser.getTags(apiOperation.tags()).ifPresent(tag -> this.addTagsIfNeeded((Set<Tag>)tag));
        OperationParser.getExternalDocumentation(apiOperation.externalDocs()).ifPresent(arg_0 -> ((io.swagger.oas.models.Operation)operation).setExternalDocs(arg_0));
        Consumes consumes = this.methodConsumes != null ? this.methodConsumes : this.classConsumes;
        OperationParser.getRequestBody(apiOperation.requestBody(), consumes, this.components).ifPresent(arg_0 -> ((io.swagger.oas.models.Operation)operation).setRequestBody(arg_0));
        Produces produces = this.methodProduces != null ? this.methodProduces : this.classProduces;
        OperationParser.getApiResponses(apiOperation.responses(), produces, this.components).ifPresent(arg_0 -> ((io.swagger.oas.models.Operation)operation).setResponses(arg_0));
        OperationParser.getServers(apiOperation.servers()).ifPresent(arg_0 -> ((io.swagger.oas.models.Operation)operation).setServers(arg_0));
        OperationParser.getParametersList(apiOperation.parameters(), this.components).ifPresent(arg_0 -> ((io.swagger.oas.models.Operation)operation).setParameters(arg_0));
        List securityRequirements = operation.getSecurity();
        if (securityRequirements != null && securityRequirements.size() > 0) {
            Optional<List<io.swagger.oas.models.security.SecurityRequirement>> requirementsObject = OperationParser.getSecurityRequirements(apiOperation.security());
            if (requirementsObject.isPresent()) {
                List<io.swagger.oas.models.security.SecurityRequirement> requirements = requirementsObject.get();
                for (io.swagger.oas.models.security.SecurityRequirement secReq : requirements) {
                    if (securityRequirements.contains(secReq)) continue;
                    securityRequirements.add(secReq);
                }
                operation.setSecurity(securityRequirements);
            }
        } else {
            OperationParser.getSecurityRequirements(apiOperation.security()).ifPresent(arg_0 -> ((io.swagger.oas.models.Operation)operation).setSecurity(arg_0));
        }
    }

    protected String getOperationId(String operationId) {
        boolean operationIdUsed = this.existOperationId(operationId);
        String operationIdToFind = null;
        int counter = 0;
        while (operationIdUsed) {
            operationIdToFind = String.format("%s_%d", operationId, ++counter);
            operationIdUsed = this.existOperationId(operationIdToFind);
        }
        if (operationIdToFind != null) {
            operationId = operationIdToFind;
        }
        return operationId;
    }

    private boolean existOperationId(String operationId) {
        if (this.openAPI == null) {
            return false;
        }
        if (this.openAPI.getPaths() == null || this.openAPI.getPaths().isEmpty()) {
            return false;
        }
        for (PathItem path : this.openAPI.getPaths().values()) {
            String pathOperationId = this.extractOperationIdFromPathItem(path);
            if (!operationId.equalsIgnoreCase(pathOperationId)) continue;
            return true;
        }
        return false;
    }

    private List<Parameter> getParameters(Type type, List<Annotation> annotations) {
        Parameter param;
        Iterator<OpenAPIExtension> chain = OpenAPIExtensions.chain();
        if (!chain.hasNext()) {
            return Collections.emptyList();
        }
        HashSet<Type> typesToSkip = new HashSet<Type>();
        OpenAPIExtension extension = chain.next();
        List<Parameter> parameters = extension.extractParameters(annotations, type, typesToSkip, chain);
        if (!parameters.isEmpty()) {
            ArrayList<Parameter> processed = new ArrayList<Parameter>(parameters.size());
            for (Parameter parameter : parameters) {
                if (ParameterProcessor.applyAnnotations((OpenAPI)this.openAPI, (Parameter)parameter, (Type)type, annotations) == null) continue;
                processed.add(parameter);
                Map schemaMap = ModelConverters.getInstance().readAll(type);
                schemaMap.forEach((key, schema) -> this.components.addSchemas(key, schema));
            }
            return processed;
        }
        ArrayList<Parameter> body = new ArrayList<Parameter>();
        if (!typesToSkip.contains(type) && (param = ParameterProcessor.applyAnnotations((OpenAPI)this.openAPI, null, (Type)type, annotations)) != null) {
            body.add(param);
        }
        return body;
    }

    private void mergeComponents(OpenAPI openAPI, boolean isComponentEmpty) {
        Components openAPIComponent = openAPI.getComponents();
        if (!isComponentEmpty) {
            if (openAPIComponent != null) {
                if (this.components.getCallbacks() != null) {
                    this.components.getCallbacks().putAll(openAPIComponent.getCallbacks());
                }
                if (this.components.getExamples() != null) {
                    this.components.getExamples().putAll(openAPIComponent.getExamples());
                }
                if (this.components.getExtensions() != null) {
                    this.components.getExtensions().putAll(openAPIComponent.getExtensions());
                }
                if (this.components.getHeaders() != null) {
                    this.components.getHeaders().putAll(openAPIComponent.getHeaders());
                }
                if (this.components.getLinks() != null) {
                    this.components.getLinks().putAll(openAPIComponent.getLinks());
                }
                if (this.components.getParameters() != null) {
                    this.components.getParameters().putAll(openAPIComponent.getParameters());
                }
                if (this.components.getRequestBodies() != null) {
                    this.components.getRequestBodies().putAll(openAPIComponent.getRequestBodies());
                }
                if (this.components.getResponses() != null) {
                    this.components.getResponses().putAll(openAPIComponent.getResponses());
                }
                if (this.components.getSchemas() != null) {
                    this.components.getSchemas().putAll(openAPIComponent.getSchemas());
                }
            }
            openAPI.setComponents(this.components);
        }
    }

    private String extractOperationIdFromPathItem(PathItem path) {
        if (path.getGet() != null) {
            return path.getGet().getOperationId();
        }
        if (path.getPost() != null) {
            return path.getPost().getOperationId();
        }
        if (path.getPut() != null) {
            return path.getPut().getOperationId();
        }
        if (path.getDelete() != null) {
            return path.getDelete().getOperationId();
        }
        if (path.getOptions() != null) {
            return path.getOptions().getOperationId();
        }
        if (path.getHead() != null) {
            return path.getHead().getOperationId();
        }
        if (path.getPatch() != null) {
            return path.getPatch().getOperationId();
        }
        return "";
    }

    private void addTagsIfNeeded(Set<Tag> tags) {
        for (Tag tag : tags) {
            boolean found = false;
            for (Tag t : this.openApiTags) {
                if (!Objects.equals(t.getName(), tag.getName())) continue;
                found = true;
            }
            if (found) continue;
            this.openApiTags.add(tag);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.swagger.jaxrs2.Reader", Reader.class, null, null);
    }
}

