/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs2;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.swagger.oas.annotations.security.OAuthFlows;
import io.swagger.oas.annotations.security.OAuthScope;
import io.swagger.oas.annotations.security.SecurityRequirement;
import io.swagger.oas.models.security.OAuthFlow;
import io.swagger.oas.models.security.Scopes;
import io.swagger.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SecurityParser {
    public static final String SCOPE_NAME = "name";
    public static final String SCOPE_DESCRIPTION = "description";
    static final long serialVersionUID = -4139888233637962276L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static Optional<List<io.swagger.oas.models.security.SecurityRequirement>> getSecurityRequirement(SecurityRequirement securityRequirement) {
        if (securityRequirement == null) {
            return Optional.empty();
        }
        ArrayList<io.swagger.oas.models.security.SecurityRequirement> securityRequirements = new ArrayList<io.swagger.oas.models.security.SecurityRequirement>();
        io.swagger.oas.models.security.SecurityRequirement securityRequirementObject = new io.swagger.oas.models.security.SecurityRequirement();
        if (securityRequirement.scopes().length > 0) {
            securityRequirementObject.addList(securityRequirement.name(), Arrays.asList(securityRequirement.scopes()));
        } else {
            securityRequirementObject.addList(securityRequirement.name());
        }
        securityRequirements.add(securityRequirementObject);
        return Optional.of(securityRequirements);
    }

    public static Optional<SecurityScheme> getSecurityScheme(io.swagger.oas.annotations.security.SecurityScheme securityScheme) {
        if (securityScheme == null) {
            return Optional.empty();
        }
        SecurityScheme securitySchemeObject = new SecurityScheme();
        if (StringUtils.isNotBlank((CharSequence)securityScheme.type())) {
            securitySchemeObject.setType(SecurityParser.getType(securityScheme.type()));
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.openIdConnectUrl())) {
            securitySchemeObject.setOpenIdConnectUrl(securityScheme.openIdConnectUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.scheme())) {
            securitySchemeObject.setScheme(securityScheme.scheme());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.bearerFormat())) {
            securitySchemeObject.setBearerFormat(securityScheme.bearerFormat());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.description())) {
            securitySchemeObject.setDescription(securityScheme.description());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.name())) {
            securitySchemeObject.setName(securityScheme.name());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.in())) {
            securitySchemeObject.setIn(SecurityParser.getIn(securityScheme.in()));
        }
        SecurityParser.getOAuthFlows(securityScheme.flows()).ifPresent(arg_0 -> ((SecurityScheme)securitySchemeObject).setFlows(arg_0));
        return Optional.of(securitySchemeObject);
    }

    public static Optional<io.swagger.oas.models.security.OAuthFlows> getOAuthFlows(OAuthFlows oAuthFlows) {
        if (SecurityParser.isEmpty(oAuthFlows)) {
            return Optional.empty();
        }
        io.swagger.oas.models.security.OAuthFlows oAuthFlowsObject = new io.swagger.oas.models.security.OAuthFlows();
        SecurityParser.getOAuthFlow(oAuthFlows.authorizationCode()).ifPresent(arg_0 -> ((io.swagger.oas.models.security.OAuthFlows)oAuthFlowsObject).setAuthorizationCode(arg_0));
        SecurityParser.getOAuthFlow(oAuthFlows.clientCredentials()).ifPresent(arg_0 -> ((io.swagger.oas.models.security.OAuthFlows)oAuthFlowsObject).setClientCredentials(arg_0));
        SecurityParser.getOAuthFlow(oAuthFlows.implicit()).ifPresent(arg_0 -> ((io.swagger.oas.models.security.OAuthFlows)oAuthFlowsObject).setImplicit(arg_0));
        SecurityParser.getOAuthFlow(oAuthFlows.password()).ifPresent(arg_0 -> ((io.swagger.oas.models.security.OAuthFlows)oAuthFlowsObject).setPassword(arg_0));
        return Optional.of(oAuthFlowsObject);
    }

    public static Optional<OAuthFlow> getOAuthFlow(io.swagger.oas.annotations.security.OAuthFlow oAuthFlow) {
        if (SecurityParser.isEmpty(oAuthFlow)) {
            return Optional.empty();
        }
        OAuthFlow oAuthFlowObject = new OAuthFlow();
        if (StringUtils.isNotBlank((CharSequence)oAuthFlow.authorizationUrl())) {
            oAuthFlowObject.setAuthorizationUrl(oAuthFlow.authorizationUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)oAuthFlow.refreshUrl())) {
            oAuthFlowObject.setRefreshUrl(oAuthFlow.refreshUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)oAuthFlow.tokenUrl())) {
            oAuthFlowObject.setTokenUrl(oAuthFlow.tokenUrl());
        }
        SecurityParser.getScopes(oAuthFlow.scopes()).ifPresent(arg_0 -> ((OAuthFlow)oAuthFlowObject).setScopes(arg_0));
        return Optional.of(oAuthFlowObject);
    }

    public static Optional<Scopes> getScopes(OAuthScope[] scopes) {
        if (SecurityParser.isEmpty(scopes)) {
            return Optional.empty();
        }
        Scopes scopesObject = new Scopes();
        for (OAuthScope scope : scopes) {
            scopesObject.addString(scope.name(), scope.description());
        }
        return Optional.of(scopesObject);
    }

    private static SecurityScheme.In getIn(String value) {
        return Arrays.stream(SecurityScheme.In.values()).filter(i -> i.toString().equals(value)).findFirst().orElse(null);
    }

    private static SecurityScheme.Type getType(String value) {
        return Arrays.stream(SecurityScheme.Type.values()).filter(i -> i.toString().equals(value)).findFirst().orElse(null);
    }

    private static boolean isEmpty(OAuthFlows oAuthFlows) {
        if (oAuthFlows == null) {
            return true;
        }
        if (!SecurityParser.isEmpty(oAuthFlows.implicit())) {
            return false;
        }
        if (!SecurityParser.isEmpty(oAuthFlows.authorizationCode())) {
            return false;
        }
        if (!SecurityParser.isEmpty(oAuthFlows.clientCredentials())) {
            return false;
        }
        return SecurityParser.isEmpty(oAuthFlows.password());
    }

    private static boolean isEmpty(io.swagger.oas.annotations.security.OAuthFlow oAuthFlow) {
        if (oAuthFlow == null) {
            return true;
        }
        if (!StringUtils.isBlank((CharSequence)oAuthFlow.authorizationUrl())) {
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)oAuthFlow.refreshUrl())) {
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)oAuthFlow.tokenUrl())) {
            return false;
        }
        return SecurityParser.isEmpty(oAuthFlow.scopes());
    }

    private static boolean isEmpty(OAuthScope[] scopes) {
        return scopes == null || scopes.length == 0;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.swagger.jaxrs2.SecurityParser", SecurityParser.class, null, null);
    }
}

