/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.jwk.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PemKeyUtil {
    private static final TraceComponent tc = Tr.register(PemKeyUtil.class, null, null);
    protected static final String BEGIN_PUBLIC = "-----BEGIN PUBLIC KEY-----";
    protected static final String END_PUBLIC = "-----END PUBLIC KEY-----";
    protected static final String BEGIN_PRIVATE = "-----BEGIN PRIVATE KEY-----";
    protected static final String END_PRIVATE = "-----END PRIVATE KEY-----";
    protected static final String BEGIN_RSA_PUBLIC = "-----BEGIN RSA PUBLIC KEY-----";
    protected static final String END_RSA_PUBLIC = "-----END RSA PUBLIC KEY-----";
    protected static final String BEGIN_EC_PUBLIC = "-----BEGIN ECDSA PUBLIC KEY-----";
    protected static final String END_EC_PUBLIC = "-----END ECDSA PUBLIC KEY-----";
    protected static final String LINE_SEPARATOR_UNIX = "\n";
    protected static final String LINE_SEPARATOR_MAC = "\r";
    protected static final String LINE_SEPARATOR_WINDOW = "\r\n";
    protected static final String RSA_KEY = "RSA";
    protected static final String EC_KEY = "EC";
    static final long serialVersionUID = 2431442417089561538L;

    public static PublicKey getPublicKey(String pkcs8pem) throws Exception {
        KeyType keyType = PemKeyUtil.getKeyType(pkcs8pem);
        String pemKey = PemKeyUtil.removeDelimiter(pkcs8pem);
        byte[] encodedKey = Base64.decodeBase64((String)pemKey);
        return PemKeyUtil.generatePublicKey(encodedKey, keyType);
    }

    @Sensitive
    public static PrivateKey getPrivateKey(@Sensitive String pkcs8pem) throws Exception {
        KeyType keyType = PemKeyUtil.getKeyType(pkcs8pem);
        String pemKey = PemKeyUtil.removeDelimiter(pkcs8pem);
        byte[] encodedKey = Base64.decodeBase64((String)pemKey);
        return PemKeyUtil.generatePrivateKey(encodedKey, keyType);
    }

    public static KeyType getKeyType(@Sensitive String pkcs8pem) {
        if (pkcs8pem == null) {
            return KeyType.UNKNOWN;
        }
        if (pkcs8pem.contains(BEGIN_RSA_PUBLIC)) {
            return KeyType.RSA_PUBLIC;
        }
        if (pkcs8pem.contains(BEGIN_EC_PUBLIC)) {
            return KeyType.EC_PUBLIC;
        }
        if (pkcs8pem.contains(BEGIN_PUBLIC)) {
            return KeyType.PUBLIC;
        }
        if (pkcs8pem.contains(BEGIN_PRIVATE)) {
            return KeyType.PRIVATE;
        }
        return KeyType.UNKNOWN;
    }

    private static String removeDelimiter(@Sensitive String pem) {
        pem = pem.replaceAll(BEGIN_PUBLIC, "");
        pem = pem.replaceAll(END_PUBLIC, "");
        pem = pem.replaceAll(BEGIN_PRIVATE, "");
        pem = pem.replaceAll(END_PRIVATE, "");
        pem = pem.replaceAll(BEGIN_RSA_PUBLIC, "");
        pem = pem.replaceAll(END_RSA_PUBLIC, "");
        pem = pem.replaceAll(BEGIN_EC_PUBLIC, "");
        pem = pem.replaceAll(END_EC_PUBLIC, "");
        pem = pem.replaceAll(LINE_SEPARATOR_UNIX, "");
        pem = pem.replaceAll(LINE_SEPARATOR_MAC, "");
        pem = pem.replaceAll(LINE_SEPARATOR_WINDOW, "");
        return pem.trim();
    }

    private static PublicKey generatePublicKey(byte[] encodedKey, KeyType keyType) throws Exception {
        if (keyType == KeyType.RSA_PUBLIC) {
            return PemKeyUtil.generateRsaPublicKey(encodedKey);
        }
        if (keyType == KeyType.EC_PUBLIC) {
            return PemKeyUtil.generateEcPublicKey(encodedKey);
        }
        if (keyType == KeyType.PUBLIC) {
            return PemKeyUtil.generateUnspecifiedPublicKey(encodedKey);
        }
        return null;
    }

    @Sensitive
    private static PrivateKey generatePrivateKey(@Sensitive byte[] encodedKey, KeyType keyType) throws Exception {
        return PemKeyUtil.generateUnspecifiedPrivateKey(encodedKey);
    }

    private static PublicKey generateRsaPublicKey(byte[] encodedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY);
        return keyFactory.generatePublic(keySpec);
    }

    @Sensitive
    private static PrivateKey generateRsaPrivateKey(@Sensitive byte[] encodedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY);
        return keyFactory.generatePrivate(keySpec);
    }

    private static PublicKey generateEcPublicKey(byte[] encodedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
        KeyFactory keyFactory = KeyFactory.getInstance(EC_KEY);
        return keyFactory.generatePublic(keySpec);
    }

    @Sensitive
    private static PrivateKey generateEcPrivateKey(@Sensitive byte[] encodedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
        KeyFactory keyFactory = KeyFactory.getInstance(EC_KEY);
        return keyFactory.generatePrivate(keySpec);
    }

    @FFDCIgnore(value={Exception.class})
    private static PublicKey generateUnspecifiedPublicKey(byte[] encodedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        try {
            return PemKeyUtil.generateRsaPublicKey(encodedKey);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Failed to generate RSA public key. Will try to generate EC key instead. Exception was: " + e), (Object[])new Object[0]);
            }
            return PemKeyUtil.generateEcPublicKey(encodedKey);
        }
    }

    @Sensitive
    @FFDCIgnore(value={Exception.class})
    private static PrivateKey generateUnspecifiedPrivateKey(@Sensitive byte[] encodedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        try {
            return PemKeyUtil.generateRsaPrivateKey(encodedKey);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Failed to generate RSA private key. Will try to generate EC key instead. Exception was: " + e), (Object[])new Object[0]);
            }
            return PemKeyUtil.generateEcPrivateKey(encodedKey);
        }
    }

    public static enum KeyType {
        RSA_PUBLIC,
        EC_PUBLIC,
        PUBLIC,
        PRIVATE,
        UNKNOWN;

    }
}

