/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.mediator;

import com.ibm.oauth.core.api.error.OAuthConfigurationException;
import com.ibm.oauth.core.api.oauth20.mediator.OAuth20Mediator;
import com.ibm.oauth.core.internal.oauth20.OAuth20ComponentInternal;
import com.ibm.oauth.core.internal.oauth20.config.OAuth20ConfigProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class OAuth20MediatorFactory {
    static final String CLASS = OAuth20MediatorFactory.class.getName();
    static final Logger _log = Logger.getLogger(CLASS);
    static Map<String, OAuth20Mediator> _mediatorMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized OAuth20Mediator getMediator(OAuth20ComponentInternal component) throws OAuthConfigurationException {
        String methodName = "getMediator";
        _log.entering(CLASS, methodName);
        OAuth20Mediator result = null;
        try {
            String componentId;
            boolean inCache;
            if (_mediatorMap == null) {
                _mediatorMap = new HashMap<String, OAuth20Mediator>();
            }
            boolean bl = inCache = (result = _mediatorMap.get(componentId = component.getParentComponentInstance().getInstanceId())) != null;
            if (!inCache) {
                OAuth20ConfigProvider config = component.get20Configuration();
                result = config.getMediators();
                _mediatorMap.put(componentId, result);
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return result;
    }
}

