/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.token.impl;

import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import java.util.Map;
import java.util.Set;

public abstract class OAuth20TokenBase
implements OAuth20Token {
    private String _id = null;
    private String _componentId = null;
    private String _type = null;
    private long _createdAt = 0L;
    private long _lastAccess = 0L;
    private String _stateId = null;
    private int _lifetimeSeconds = 0;
    private boolean _isPersistent;
    private String _grantType = null;
    private Map<String, String[]> _extensionProperties = null;

    public OAuth20TokenBase(String id, String componentId, String type, String stateId, int lifetimeSeconds, boolean isPersistent, Map<String, String[]> extensionProperties, String grantType) {
        this._id = id;
        this.init(componentId, type, stateId, lifetimeSeconds, isPersistent, extensionProperties, grantType);
    }

    private void init(String componentId, String type, String stateId, int lifetimeSeconds, boolean isPersistent, Map<String, String[]> extensionProperties, String grantType) {
        this._componentId = componentId;
        this._type = type;
        this._createdAt = System.currentTimeMillis();
        this._stateId = stateId;
        this._lifetimeSeconds = lifetimeSeconds;
        this._isPersistent = isPersistent;
        this._extensionProperties = extensionProperties;
        this._grantType = grantType;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public String getComponentId() {
        return this._componentId;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public long getCreatedAt() {
        return this._createdAt;
    }

    @Override
    public String getStateId() {
        return this._stateId;
    }

    @Override
    public int getLifetimeSeconds() {
        return this._lifetimeSeconds;
    }

    @Override
    public boolean isPersistent() {
        return this._isPersistent;
    }

    @Override
    public String getGrantType() {
        return this._grantType;
    }

    @Override
    public String[] getExtensionPropertyNames() {
        Set<String> keys;
        String[] result = null;
        if (this._extensionProperties != null && this._extensionProperties.size() > 0 && (keys = this._extensionProperties.keySet()) != null) {
            result = keys.toArray(new String[keys.size()]);
        }
        return result;
    }

    @Override
    public String[] getExtensionProperty(String propertyName) {
        String[] result = null;
        if (this._extensionProperties != null && this._extensionProperties.size() > 0) {
            result = this._extensionProperties.get(propertyName);
        }
        return result;
    }

    @Override
    public Map<String, String[]> getExtensionProperties() {
        return this._extensionProperties;
    }

    @Override
    public String getUsedFor() {
        return null;
    }

    @Override
    public String[] getUsedBy() {
        return null;
    }

    @Override
    public String getAppName() {
        return null;
    }

    @Override
    public long getLastAccess() {
        return this._lastAccess;
    }

    @Override
    public void setLastAccess() {
        this._lastAccess = System.currentTimeMillis();
    }

    @Override
    public String getCodeChallenge() {
        String[] buf = this.getExtensionProperty("com.ibm.wsspi.security.oidc.external.claims:code_challenge");
        return buf == null ? null : buf[0];
    }

    @Override
    public String getCodeChallengeMethod() {
        String[] buf = this.getExtensionProperty("com.ibm.wsspi.security.oidc.external.claims:code_challenge_method");
        return buf == null ? null : buf[0];
    }

    public String toString() {
        StringBuffer token = new StringBuffer();
        token.append("id=" + this._id + "&");
        token.append("component_id=" + this._componentId + "&");
        token.append("type=" + this._type + "&");
        token.append("created_at=" + this._createdAt + "&");
        token.append("state_id=" + this._stateId + "&");
        token.append("lifetime_seconds=" + this._lifetimeSeconds + "&");
        token.append("is_persistent=" + this._isPersistent + "&");
        token.append("grant_type=" + this._grantType);
        return token.toString();
    }
}

