/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.form;

import com.ibm.oauth.core.api.attributes.Attribute;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.oauth20.client.OAuth20Client;
import com.ibm.oauth.core.util.JSONUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.util.Nonce;
import com.ibm.ws.security.oauth20.util.TemplateRetriever;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FormRenderer {
    private static TraceComponent tc = Tr.register(FormRenderer.class, (String)"OAuth20Provider", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final String JS_PATH = "/scripts/oauthForm.js";
    public static final String ATTR_OAUTH_FORM_DATA = "oauthFormData";
    public static final String FORM_AUTHORIZATION_URL = "authorizationUrl";
    public static final String FORM_NONCE = "consentNonce";
    public static final String FORM_CLIENT_DISPLAYNAME = "clientDisplayName";
    public static final String FORM_EXTENDED_PROPERTIES = "extendedProperties";
    private static final TemplateRetriever retriever = new TemplateRetriever();
    private static final Set<String> requiredAttributes = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("client_id", "client_secret", "response_type", "redirect_uri", "state", "scope")));
    static final long serialVersionUID = 1434635720051592213L;

    public void renderForm(OAuth20Client client, String templateUrl, String contextPath, String authorizationUrl, Nonce nonce, AttributeList attributes, String acceptLanguage, HttpServletResponse response) throws IOException {
        this.renderForm(client, templateUrl, contextPath, authorizationUrl, nonce, attributes, acceptLanguage, response, null);
    }

    public void renderForm(OAuth20Client client, String templateUrl, String contextPath, String authorizationUrl, Nonce nonce, AttributeList attributes, String acceptLanguage, HttpServletResponse response, byte[] defaultAuthorizationFormTemplatecontent) throws IOException {
        String[] resources;
        TemplateRetriever.Item template = null;
        if (defaultAuthorizationFormTemplatecontent == null) {
            template = retriever.getTemplate(templateUrl, acceptLanguage);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using authorization form from memory", (Object[])new Object[0]);
            }
            template = new TemplateRetriever.Item(defaultAuthorizationFormTemplatecontent, "text/html; charset=UTF-8");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FORM_NONCE, nonce.getValue());
        map.put("client_id", attributes.getAttributeValueByName("client_id"));
        map.put("response_type", attributes.getAttributeValueByName("response_type"));
        map.put("redirect_uri", attributes.getAttributeValueByName("redirect_uri"));
        String strState = attributes.getAttributeValueByName("state");
        if (strState != null && strState.length() > 0) {
            String encoding = response.getCharacterEncoding();
            String encodedState = URLEncoder.encode(strState, encoding != null ? encoding : "UTF-8");
            map.put("state", encodedState);
        } else {
            map.put("state", strState);
        }
        map.put("scope", attributes.getAttributeValuesByName("scope"));
        map.put(FORM_CLIENT_DISPLAYNAME, client.getClientName());
        if (attributes.getAttributeValuesByName("resource") != null) {
            map.put("resource", attributes.getAttributeValuesByName("resource"));
        }
        if ((resources = attributes.getAttributeValuesByName("resource")) != null) {
            String resource = this.arrayToString(resources);
            map.put("resource", resource);
        }
        HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
        for (Attribute attr : attributes.getAllAttributes()) {
            String name = attr.getName();
            if (requiredAttributes.contains(name)) continue;
            String[] values = attr.getValuesArray();
            if (values == null || values.length == 0) {
                extendedProperties.put(name, null);
                continue;
            }
            if (values.length > 1) {
                extendedProperties.put(name, values);
                continue;
            }
            extendedProperties.put(name, values[0]);
        }
        map.put(FORM_EXTENDED_PROPERTIES, extendedProperties);
        StringBuilder data = JSONUtil.getJSON(map);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("oauth form data is " + data.toString()), (Object[])new Object[0]);
        }
        response.setContentType(template.getContentType());
        ServletOutputStream os = response.getOutputStream();
        os.write(template.getContent());
        StringBuilder sb = new StringBuilder();
        sb.append("<script type=\"text/javascript\" src=\"").append(contextPath).append(JS_PATH).append("\"></script>").append("<script language=\"javascript\">").append("var ").append(ATTR_OAUTH_FORM_DATA).append("=").append((CharSequence)data).append(";").append(";var loc=document.location;loc=loc.href.substring(0,loc.href.indexOf(loc.pathname))+loc.pathname;").append(ATTR_OAUTH_FORM_DATA).append(".").append(FORM_AUTHORIZATION_URL).append("=loc;").append("</script>");
        os.write(Base64Coder.getBytes((String)sb.toString()));
        os.close();
    }

    private String arrayToString(String[] values) {
        if (values != null) {
            String result = "";
            for (int iI = 0; iI < values.length; ++iI) {
                if (iI > 0) {
                    result = result.concat(" ");
                }
                result = result.concat(values[iI]);
            }
            return result;
        }
        return null;
    }
}

