/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins.db;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OidcOAuth20ClientProvider;
import com.ibm.ws.security.oauth20.error.impl.BrowserAndServerLogMessage;
import com.ibm.ws.security.oauth20.exception.OAuthDataException;
import com.ibm.ws.security.oauth20.plugins.BaseClient;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClientDBModel;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClientValidator;
import com.ibm.ws.security.oauth20.plugins.db.DynamicDBMigrator;
import com.ibm.ws.security.oauth20.plugins.db.OAuthJDBCImpl;
import com.ibm.ws.security.oauth20.util.ClientUtils;
import com.ibm.ws.security.oauth20.util.HashSecretUtils;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import com.ibm.ws.security.oauth20.web.RegistrationEndpointServices;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CachedDBOidcClientProvider
extends OAuthJDBCImpl
implements OidcOAuth20ClientProvider {
    private static final TraceComponent tc = Tr.register(CachedDBOidcClientProvider.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    private static final String CLASS = CachedDBOidcClientProvider.class.getName();
    private final Logger _log = Logger.getLogger(CLASS);
    private String _componentId;
    private String _tableName;
    private boolean hasRewrites;
    private final String[] _providerRewrites;
    private DynamicDBMigrator _dbMigrator;
    private boolean migrationAttempted = false;
    private static final String CLIENT_CONFIG_PARAMS = String.format(" (%s, %s, %s, %s, %s, %s, %s)", "COMPONENTID", "CLIENTID", "CLIENTSECRET", "DISPLAYNAME", "REDIRECTURI", "ENABLED", "CLIENTMETADATA");
    private final boolean updateXORtoHash = true;
    private String hashType = "xor";
    private final int numIterations = 2048;
    private final int keylength = 2048;
    static final long serialVersionUID = 8920662085483191922L;

    public CachedDBOidcClientProvider(String componentId, DataSource dataSource, String tableName, @Sensitive Object[] credentials, String clientCacheJndi, String[] providerRewrites) {
        super(dataSource, credentials);
        this._componentId = componentId;
        this._tableName = tableName;
        this._providerRewrites = providerRewrites != null ? (String[])providerRewrites.clone() : null;
        this._dbMigrator = new DynamicDBMigrator(this._tableName);
    }

    public CachedDBOidcClientProvider(String componentId, DataSource dataSource, String tableName, @Sensitive Object[] credentials, String clientCacheJndi, String[] providerRewrites, String hashType) {
        super(dataSource, credentials);
        this._componentId = componentId;
        this._tableName = tableName;
        this._providerRewrites = providerRewrites != null ? (String[])providerRewrites.clone() : null;
        this._dbMigrator = new DynamicDBMigrator(this._tableName);
        this.hashType = hashType;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Client secret hash type is " + hashType), (Object[])new Object[0]);
        }
    }

    @Override
    @ManualTrace
    public void initialize() {
        String methodName = "initialize";
        this._log.entering(CLASS, methodName);
        boolean finestLoggable = this._log.isLoggable(Level.FINEST);
        try {
            if (finestLoggable) {
                this._log.logp(Level.FINEST, CLASS, methodName, "Using ComponentId: " + this._componentId);
            }
            this.hasRewrites = ClientUtils.initRewrites(this._componentId, this._providerRewrites);
        }
        finally {
            this._log.exiting(CLASS, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public void init(OAuthComponentConfiguration config) {
        String methodName = "init";
        this._log.entering(CLASS, methodName);
        try {
            super.init(config);
            this._tableName = config.getConfigPropertyValue("oauthjdbc.client.table");
            this._componentId = config.getUniqueId();
            this._dbMigrator = new DynamicDBMigrator(this._tableName);
            boolean finestLoggable = this._log.isLoggable(Level.FINEST);
            if (finestLoggable) {
                this._log.logp(Level.FINEST, CLASS, methodName, "Using ComponentId: " + this._componentId);
            }
            this.hasRewrites = ClientUtils.initRewrites(config);
        }
        finally {
            this._log.exiting(CLASS, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    @FFDCIgnore(value={SQLException.class})
    public OidcBaseClient put(OidcBaseClient newClient) throws OidcServerException {
        String methodName = "put";
        this._log.entering(CLASS, methodName, new Object[]{newClient});
        Connection conn = null;
        boolean error = true;
        try {
            conn = this.getInitializedConnection();
            this.addClientToDB(conn, CachedDBOidcClientProvider.getOidcBaseClientDBModel(this._componentId, newClient, 1));
            error = false;
        }
        catch (SQLException e) {
            this.attemptDbMigration(conn);
            try {
                this.addClientToDB(conn, CachedDBOidcClientProvider.getOidcBaseClientDBModel(this._componentId, newClient, 1));
                error = false;
            }
            catch (SQLException e1) {
                String operation = "INSERT";
                this.logMessageAndThrowOidcServerException(methodName, e1, "ERROR_PERFORMING_DB_OPERATION", operation, newClient.getClientId());
            }
        }
        finally {
            this.closeConnection(conn, error);
        }
        this._log.exiting(CLASS, methodName, new Object[0]);
        return error ? null : newClient;
    }

    private void attemptDbMigration(Connection conn) {
        if (!this.migrationAttempted) {
            this.migrationAttempted = true;
            this._dbMigrator.execute(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    void addClientToDB(Connection conn, OidcBaseClientDBModel clientDbModel) throws SQLException, OidcServerException {
        String methodName = "addClientToDB";
        this._log.entering(CLASS, methodName, new Object[]{clientDbModel});
        String clientSecret = null;
        if (this.isPBKDF2WithHmacSHA512Configured()) {
            HashSecretUtils.processMetatypeForHashInfo(clientDbModel.getClientMetadata(), clientDbModel.getClientId(), this.hashType, 2048, 2048);
            HashSecretUtils.hashClientMetaTypeSecret(clientDbModel.getClientMetadata(), clientDbModel.getClientId(), true);
            clientSecret = HashSecretUtils.hashSecret(clientDbModel.getClientSecret(), clientDbModel.getClientId(), true, clientDbModel.getClientMetadata());
        } else if (this.isXORConfigured()) {
            this.encodeClientSecretInClientMetadata(clientDbModel);
            clientSecret = PasswordUtil.passwordEncode((String)clientDbModel.getClientSecret());
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The client secret type is unknown, attempt to hash. " + this.hashType), (Object[])new Object[0]);
            }
            IllegalArgumentException ie = new IllegalArgumentException("Unknown hash type provided, " + this.hashType + ", the new client cannot be registered: " + clientDbModel.getClientId());
            this.logMessageAndThrowOidcServerException(methodName, ie, "ERROR_PERFORMING_DB_OPERATION", "INSERT", clientDbModel.getClientId());
        }
        PreparedStatement st = null;
        String QUERY_INSERT = "INSERT INTO " + this._tableName + CLIENT_CONFIG_PARAMS + " VALUES ( ?, ?, ?, ?, ?, ?, ? )";
        try {
            st = conn.prepareStatement(QUERY_INSERT);
            st.setString(1, this._componentId);
            st.setString(2, clientDbModel.getClientId());
            st.setString(3, clientSecret);
            st.setString(4, clientDbModel.getDisplayName());
            st.setString(5, clientDbModel.getRedirectUri());
            st.setInt(6, clientDbModel.getEnabled());
            st.setString(7, clientDbModel.getClientMetadata().toString());
            st.executeUpdate();
        }
        finally {
            this.closeStatement(st, methodName);
            this._log.exiting(CLASS, methodName, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    @FFDCIgnore(value={SQLException.class})
    public OidcBaseClient get(String clientId) throws OidcServerException {
        String methodName = "get";
        this._log.entering(CLASS, methodName, new Object[]{clientId});
        OidcBaseClient result = null;
        Connection conn = null;
        boolean error = true;
        if (result == null) {
            try {
                conn = this.getInitializedConnection();
                result = this.getClientFromDB(conn, clientId);
                error = false;
            }
            catch (SQLException e) {
                this.attemptDbMigration(conn);
                try {
                    result = this.getClientFromDB(conn, clientId);
                    error = false;
                }
                catch (SQLException e1) {
                    String operation = "SELECT";
                    this.logMessageAndThrowOidcServerException(methodName, e1, "ERROR_PERFORMING_DB_OPERATION", operation, clientId);
                }
            }
            finally {
                this.closeConnection(conn, error);
            }
        }
        if (this.hasRewrites && result != null) {
            result = ClientUtils.uriRewrite(result);
        }
        this._log.exiting(CLASS, methodName, result);
        return result;
    }

    OidcBaseClient getClientFromDB(Connection conn, String clientId) throws SQLException, OidcServerException {
        return this.getClientFromDB(conn, clientId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    OidcBaseClient getClientFromDB(Connection conn, String clientId, boolean removeHashInfo) throws SQLException, OidcServerException {
        String methodName = "getClientFromDB";
        this._log.entering(CLASS, methodName, new Object[]{clientId, this._componentId});
        OidcBaseClient result = null;
        ResultSet queryResults = null;
        PreparedStatement st = null;
        String QUERY_GET_CLIENTID = "SELECT * FROM " + this._tableName + " WHERE " + "COMPONENTID" + " = ? AND " + "CLIENTID" + " = ?";
        try {
            st = conn.prepareStatement(QUERY_GET_CLIENTID);
            st.setString(1, this._componentId);
            st.setString(2, clientId);
            queryResults = st.executeQuery();
            while (queryResults != null && queryResults.next() && (result = this.getClientFromDBModel(conn, queryResults, removeHashInfo)) == null) {
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(queryResults);
            this.closeStatement(st, methodName);
            this._log.exiting(CLASS, methodName, result);
            throw throwable;
        }
        this.closeResultSet(queryResults);
        this.closeStatement(st, methodName);
        this._log.exiting(CLASS, methodName, result);
        return result;
    }

    OidcBaseClient getClientFromDBModel(Connection conn, ResultSet queryResults) throws SQLException {
        return this.getClientFromDBModel(conn, queryResults, true);
    }

    OidcBaseClient getClientFromDBModel(Connection conn, ResultSet queryResults, boolean removeHashInfo) throws SQLException {
        OidcBaseClientDBModel clientDBModel = this.getDBModelOfClient(conn, queryResults, removeHashInfo);
        OidcBaseClient client = this.setDefaultFacade(clientDBModel, CachedDBOidcClientProvider.getOidcBaseClient(clientDBModel));
        String storedSecret = client.getClientSecret();
        if (storedSecret != null && !storedSecret.isEmpty()) {
            String secretType = PasswordUtil.getCryptoAlgorithm((String)storedSecret);
            if (secretType == null || secretType.equals("xor")) {
                client.setClientSecret(PasswordUtil.passwordDecode((String)storedSecret));
            } else {
                client.setClientSecret(storedSecret);
            }
        }
        return client;
    }

    OidcBaseClient setDefaultFacade(OidcBaseClientDBModel clientDBModel, OidcBaseClient client) {
        OidcBaseClient deepCopyClient = client.getDeepCopy();
        deepCopyClient.setEnabled(clientDBModel.getEnabled() == 1);
        deepCopyClient.setComponentId(clientDBModel.getComponentId());
        boolean isBlank = CachedDBOidcClientProvider.isUninitializedClientMetdata(clientDBModel.getClientMetadata());
        if (isBlank) {
            String oldClientName;
            String oldSecret;
            String oldRedirectUri = clientDBModel.getRedirectUri();
            if (!OidcOAuth20Util.isNullEmpty(oldRedirectUri)) {
                deepCopyClient.setRedirectUris(OidcOAuth20Util.initJsonArray(oldRedirectUri));
            }
            if (!OidcOAuth20Util.isNullEmpty(oldSecret = clientDBModel.getClientSecret())) {
                deepCopyClient.setClientSecret(oldSecret);
            }
            if (!OidcOAuth20Util.isNullEmpty(oldClientName = clientDBModel.getDisplayName())) {
                deepCopyClient.setClientName(oldClientName);
            }
            deepCopyClient.setClientSecretExpiresAt(0L);
            deepCopyClient.setClientIdIssuedAt(0L);
        }
        return OidcBaseClientValidator.getInstance(deepCopyClient).setDefaultsForOmitted();
    }

    static boolean isUninitializedClientMetdata(JsonObject clientMetadata) {
        return clientMetadata == null || clientMetadata.isJsonNull() || clientMetadata.entrySet().size() == 0;
    }

    OidcBaseClientDBModel getDBModelOfClient(Connection conn, ResultSet queryResults) throws SQLException {
        return this.getDBModelOfClient(conn, queryResults, true);
    }

    OidcBaseClientDBModel getDBModelOfClient(Connection conn, ResultSet queryResults, boolean removeHashInfoFromMetadata) throws SQLException {
        String componentId = queryResults.getString("COMPONENTID");
        String clientId = queryResults.getString("CLIENTID");
        String clientSecret = queryResults.getString("CLIENTSECRET");
        String displayName = queryResults.getString("DISPLAYNAME");
        String redirectUri = queryResults.getString("REDIRECTURI");
        int enabled = queryResults.getInt("ENABLED");
        JsonObject clientMetadata = null;
        if (this.getDBType().isClobSupported()) {
            Clob clob = queryResults.getClob("CLIENTMETADATA");
            clientMetadata = new JsonParser().parse(clob.getCharacterStream()).getAsJsonObject();
        } else {
            String strClob = queryResults.getString("CLIENTMETADATA");
            clientMetadata = new JsonParser().parse(strClob).getAsJsonObject();
        }
        if (removeHashInfoFromMetadata) {
            clientMetadata.remove("hash_alg");
            clientMetadata.remove("salt");
            clientMetadata.remove("hash_itr");
            clientMetadata.remove("hash_len");
        }
        return new OidcBaseClientDBModel(componentId, clientId, clientSecret, displayName, redirectUri, enabled, clientMetadata);
    }

    @Override
    @ManualTrace
    public Collection<OidcBaseClient> getAll() throws OidcServerException {
        String methodName = "getAll";
        this._log.entering(CLASS, methodName, new Object[0]);
        Collection<OidcBaseClient> results = this.getAll(null);
        this._log.exiting(CLASS, methodName, results);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    @FFDCIgnore(value={SQLException.class})
    public Collection<OidcBaseClient> getAll(HttpServletRequest request) throws OidcServerException {
        String methodName = "getAll(request)";
        this._log.entering(CLASS, methodName, new Object[0]);
        Collection<OidcBaseClient> results = null;
        Connection conn = null;
        boolean error = true;
        try {
            conn = this.getInitializedConnection();
            results = this.findAllClientsFromDB(conn, request);
            error = false;
        }
        catch (SQLException e) {
            this.attemptDbMigration(conn);
            try {
                results = this.findAllClientsFromDB(conn, request);
                error = false;
            }
            catch (SQLException e1) {
                this.logMessageAndThrowOidcServerException(methodName, e1, "ERROR_GETTING_CLIENTS_FROM_DB", new Object[0]);
            }
        }
        finally {
            this.closeConnection(conn, error);
        }
        if (this.hasRewrites && results != null) {
            ArrayList<OidcBaseClient> updatedResults = new ArrayList<OidcBaseClient>();
            for (OidcBaseClient result : results) {
                updatedResults.add(ClientUtils.uriRewrite(result));
            }
            results = updatedResults;
        }
        this._log.exiting(CLASS, methodName, results);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    Collection<OidcBaseClient> findAllClientsFromDB(Connection conn, HttpServletRequest request) throws SQLException, OidcServerException {
        String methodName = "findAllClientsFromDB(conn,request)";
        this._log.entering(CLASS, methodName, new Object[0]);
        ArrayList<OidcBaseClient> results = new ArrayList<OidcBaseClient>();
        ResultSet queryResults = null;
        PreparedStatement st = null;
        try {
            String query = "SELECT * FROM " + this._tableName + " WHERE " + "COMPONENTID" + " = ?";
            st = conn.prepareStatement(query);
            st.setString(1, this._componentId);
            queryResults = st.executeQuery();
            while (queryResults != null && queryResults.next()) {
                OidcBaseClient result = this.getClientFromDBModel(conn, queryResults);
                if (request != null) {
                    RegistrationEndpointServices.processClientRegistationUri(result, request);
                }
                results.add(result);
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(queryResults);
            this.closeStatement(st, methodName);
            this._log.exiting(CLASS, methodName, results);
            throw throwable;
        }
        this.closeResultSet(queryResults);
        this.closeStatement(st, methodName);
        this._log.exiting(CLASS, methodName, results);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    @FFDCIgnore(value={SQLException.class})
    public OidcBaseClient update(OidcBaseClient newClient) throws OidcServerException {
        String methodName = "update";
        this._log.entering(CLASS, methodName, new Object[]{newClient});
        OidcBaseClient retVal = null;
        Connection conn = null;
        boolean error = true;
        try {
            conn = this.getInitializedConnection();
            if (this.update(conn, CachedDBOidcClientProvider.getOidcBaseClientDBModel(this._componentId, newClient, 1)) == 1) {
                retVal = newClient;
            }
            error = false;
        }
        catch (SQLException e) {
            this.attemptDbMigration(conn);
            try {
                if (this.update(conn, CachedDBOidcClientProvider.getOidcBaseClientDBModel(this._componentId, newClient, 1)) == 1) {
                    retVal = newClient;
                }
                error = false;
            }
            catch (SQLException e1) {
                String operation = "UPDATE";
                this.logMessageAndThrowOidcServerException(methodName, e1, "ERROR_PERFORMING_DB_OPERATION", operation, newClient.getClientId());
            }
        }
        finally {
            this.closeConnection(conn, error);
        }
        this._log.exiting(CLASS, methodName, retVal);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    int update(Connection conn, OidcBaseClientDBModel clientDbModel) throws OidcServerException, SQLException {
        String methodName = "update";
        this._log.entering(CLASS, methodName, new Object[]{conn, this._componentId, clientDbModel});
        PreparedStatement st = null;
        int retVal = 0;
        String clientSecret = clientDbModel.getClientSecret();
        if (this.isPBKDF2WithHmacSHA512Configured()) {
            HashSecretUtils.processMetatypeForHashInfo(clientDbModel.getClientMetadata(), clientDbModel.getClientId(), this.hashType, 2048, 2048);
            HashSecretUtils.hashClientMetaTypeSecret(clientDbModel.getClientMetadata(), clientDbModel.getClientId(), true);
            clientSecret = HashSecretUtils.hashSecret(clientDbModel.getClientSecret(), clientDbModel.getClientId(), true, clientDbModel.getClientMetadata());
        } else if (this.isXORConfigured()) {
            this.encodeClientSecretInClientMetadata(clientDbModel);
            clientSecret = PasswordUtil.passwordEncode((String)clientDbModel.getClientSecret());
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The client secret type is unknown, attempt to hash. " + this.hashType), (Object[])new Object[0]);
            }
            IllegalArgumentException ie = new IllegalArgumentException("Unknown hash type provided, " + this.hashType + ", the new client cannot be registered: " + clientDbModel.getClientId());
            this.logMessageAndThrowOidcServerException(methodName, ie, "ERROR_PERFORMING_DB_OPERATION", "UPDATE", clientDbModel.getClientId());
        }
        String QUERY_UPDATE = "UPDATE " + this._tableName + " SET " + "COMPONENTID" + "=? ," + "CLIENTSECRET" + "=? ," + "DISPLAYNAME" + "=? ," + "REDIRECTURI" + "=? ," + "ENABLED" + "=? ," + "CLIENTMETADATA" + "=? WHERE " + "CLIENTID" + " = ? AND " + "COMPONENTID" + " = ?";
        try {
            st = conn.prepareStatement(QUERY_UPDATE);
            st.setString(1, this._componentId);
            st.setString(2, clientSecret);
            st.setString(3, clientDbModel.getDisplayName());
            st.setString(4, clientDbModel.getRedirectUri());
            st.setInt(5, clientDbModel.getEnabled());
            st.setString(6, clientDbModel.getClientMetadata().toString());
            st.setString(7, clientDbModel.getClientId());
            st.setString(8, this._componentId);
            retVal = st.executeUpdate();
        }
        finally {
            this.closeStatement(st, methodName);
            this._log.exiting(CLASS, methodName, retVal);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public boolean delete(String clientId) throws OidcServerException {
        String methodName = "delete";
        this._log.entering(CLASS, methodName, new Object[]{clientId});
        Connection conn = null;
        boolean error = true;
        try {
            conn = this.getInitializedConnection();
            error = !this.deleteClientFromDB(conn, clientId);
        }
        catch (SQLException sQLException) {
            void e;
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcClientProvider", (String)"671", (Object)this, (Object[])new Object[]{clientId});
            String operation = "DELETE";
            this.logMessageAndThrowOidcServerException(methodName, (SQLException)e, "ERROR_PERFORMING_DB_OPERATION", operation, clientId);
        }
        finally {
            this.closeConnection(conn, error);
        }
        this._log.exiting(CLASS, methodName, error);
        return !error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    boolean deleteClientFromDB(Connection conn, String clientId) throws SQLException {
        String methodName = "deleteClientFromDB";
        this._log.entering(CLASS, methodName, new Object[]{this._tableName, this._componentId, clientId});
        ResultSet queryResults = null;
        PreparedStatement st = null;
        boolean error = true;
        try {
            String QUERY_DELETE = "DELETE FROM " + this._tableName + " WHERE " + "COMPONENTID" + " = ? AND " + "CLIENTID" + " = ?";
            st = conn.prepareStatement(QUERY_DELETE);
            st.setString(1, this._componentId);
            st.setString(2, clientId);
            int numDeleted = st.executeUpdate();
            this._log.logp(Level.FINE, CLASS, methodName, "Num entries deleted: " + numDeleted);
            if (numDeleted > 0) {
                error = false;
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(queryResults);
            this.closeStatement(st, methodName);
            this._log.exiting(CLASS, methodName, null);
            throw throwable;
        }
        this.closeResultSet(queryResults);
        this.closeStatement(st, methodName);
        this._log.exiting(CLASS, methodName, null);
        return !error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    @FFDCIgnore(value={SQLException.class})
    public boolean exists(String clientId) throws OidcServerException {
        String methodName = "exists";
        this._log.entering(CLASS, methodName, new Object[]{clientId});
        boolean result = false;
        Connection conn = null;
        boolean error = true;
        OidcBaseClient client = null;
        if (client == null) {
            try {
                conn = this.getInitializedConnection();
                client = this.getClientFromDB(conn, clientId);
                error = false;
            }
            catch (SQLException e) {
                this.attemptDbMigration(conn);
                try {
                    client = this.getClientFromDB(conn, clientId);
                    error = false;
                }
                catch (SQLException e1) {
                    String operation = "SELECT";
                    this.logMessageAndThrowOidcServerException(methodName, e1, "ERROR_PERFORMING_DB_OPERATION", operation, clientId);
                }
            }
            finally {
                this.closeConnection(conn, error);
            }
        }
        result = client != null;
        this._log.exiting(CLASS, methodName, "" + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    @FFDCIgnore(value={SQLException.class})
    public boolean validateClient(String clientId, String clientSecret) throws OidcServerException {
        BaseClient client;
        boolean error;
        Connection conn;
        boolean result;
        String methodName;
        block12: {
            methodName = "validateClient";
            this._log.entering(CLASS, methodName, new Object[]{clientId, "secret_removed"});
            result = false;
            conn = null;
            error = true;
            client = null;
            try {
                if (clientSecret == null || clientSecret.isEmpty()) break block12;
                conn = this.getInitializedConnection();
                client = this.getClientFromDB(conn, clientId, false);
                error = false;
            }
            catch (SQLException e) {
                try {
                    this.attemptDbMigration(conn);
                    try {
                        client = this.getClientFromDB(conn, clientId, false);
                        error = false;
                    }
                    catch (SQLException e1) {
                        String operation = "SELECT";
                        this.logMessageAndThrowOidcServerException(methodName, e1, "ERROR_PERFORMING_DB_OPERATION", operation, clientId);
                    }
                }
                catch (Throwable throwable) {
                    this.closeConnection(conn, error);
                    throw throwable;
                }
                this.closeConnection(conn, error);
            }
        }
        this.closeConnection(conn, error);
        if (client != null && client.isEnabled() && client.isConfidential()) {
            if (this.hasRewrites) {
                client = ClientUtils.uriRewrite((OidcBaseClient)client);
            }
            String storedSecret = client.getClientSecret();
            boolean update = true;
            String secretType = PasswordUtil.getCryptoAlgorithm((String)storedSecret);
            if (secretType != null && secretType.equals("hash")) {
                update = false;
                clientSecret = HashSecretUtils.hashSecret(clientSecret, clientId, false, ((OidcBaseClient)client).getSalt(), ((OidcBaseClient)client).getAlgorithm(), ((OidcBaseClient)client).getIterations(), ((OidcBaseClient)client).getLength());
            }
            if (storedSecret != null && storedSecret.equals(clientSecret)) {
                result = true;
                if (update && !this.isXORConfigured()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Converting client secret for " + clientId + " to hash during a validateClient request"), (Object[])new Object[0]);
                    }
                    this.update((OidcBaseClient)client);
                }
            }
        }
        this._log.exiting(CLASS, methodName, "" + result);
        return result;
    }

    @FFDCIgnore(value={OAuthDataException.class})
    Connection getInitializedConnection() throws OidcServerException {
        Connection conn;
        try {
            conn = this.getDBConnection();
            conn.setAutoCommit(false);
        }
        catch (OAuthDataException e) {
            throw new OidcServerException(e.getLocalizedMessage(), "server_error", 500, (Throwable)e);
        }
        catch (SQLException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcClientProvider", (String)"837", (Object)this, (Object[])new Object[0]);
            throw new OidcServerException(e.getLocalizedMessage(), "server_error", 500, (Throwable)e);
        }
        return conn;
    }

    private static OidcBaseClientDBModel getOidcBaseClientDBModel(String componentId, OidcBaseClient client, int enabled) {
        return new OidcBaseClientDBModel(componentId, client.getClientId(), null, "", null, enabled, CachedDBOidcClientProvider.getClientMetadata(client));
    }

    private static OidcBaseClient getOidcBaseClient(OidcBaseClientDBModel clientDbModel) {
        OidcBaseClient client = (OidcBaseClient)OidcOAuth20Util.GSON_RAW.fromJson((JsonElement)clientDbModel.getClientMetadata(), OidcBaseClient.class);
        client.setComponentId(clientDbModel.getComponentId());
        client.setClientId(clientDbModel.getClientId());
        client.setEnabled(clientDbModel.getEnabled() != 0);
        return client;
    }

    @Sensitive
    private static JsonObject getClientMetadata(OidcBaseClient client) {
        JsonObject clientMetadataJsonObj = OidcOAuth20Util.getJsonObj(client);
        clientMetadataJsonObj.remove("client_id");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            Set entries = clientMetadataJsonObj.entrySet();
            for (Map.Entry entry : entries) {
                String key = (String)entry.getKey();
                if (key.equals("client_secret")) {
                    sb.append(" " + key + "=secret_removed");
                    continue;
                }
                if (key.equals("salt")) {
                    sb.append(" " + key + "=salt_removed");
                    continue;
                }
                sb.append(" " + key + "=" + entry.getValue());
            }
            sb.append("]");
            Tr.debug((TraceComponent)tc, (String)CLASS, (Object[])new Object[]{"getClientMetadata: " + sb.toString()});
        }
        return clientMetadataJsonObj;
    }

    void encodeClientSecretInClientMetadata(OidcBaseClientDBModel clientDbModel) {
        String clientSecret;
        JsonObject clientMetadataJson = clientDbModel.getClientMetadata();
        if (clientMetadataJson != null && clientMetadataJson.has("client_secret") && (clientSecret = clientMetadataJson.get("client_secret").getAsString()) != null && !clientSecret.isEmpty()) {
            clientMetadataJson.addProperty("client_secret", PasswordUtil.passwordEncode((String)clientSecret));
        }
    }

    void logMessageAndThrowOidcServerException(String methodName, SQLException e, String msgKey, Object ... msgArgs) throws OidcServerException {
        this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), e);
        Object[] updatedMsgArgs = this.appendStringMessageToArgs(e.getLocalizedMessage(), msgArgs);
        Tr.error((TraceComponent)tc, (String)msgKey, (Object[])updatedMsgArgs);
        updatedMsgArgs = this.appendStringMessageToArgs("", msgArgs);
        throw new OidcServerException(new BrowserAndServerLogMessage(tc, msgKey, updatedMsgArgs), "server_error", 500, (Throwable)e);
    }

    void logMessageAndThrowOidcServerException(String methodName, IllegalArgumentException e, String msgKey, Object ... msgArgs) throws OidcServerException {
        this._log.logp(Level.SEVERE, CLASS, methodName, e.getMessage(), e);
        Object[] updatedMsgArgs = this.appendStringMessageToArgs(e.getLocalizedMessage(), msgArgs);
        Tr.error((TraceComponent)tc, (String)msgKey, (Object[])updatedMsgArgs);
        updatedMsgArgs = this.appendStringMessageToArgs("", msgArgs);
        throw new OidcServerException(new BrowserAndServerLogMessage(tc, msgKey, updatedMsgArgs), "server_error", 500, (Throwable)e);
    }

    Object[] appendStringMessageToArgs(String additionalInsert, Object ... msgArgs) {
        Object[] updatedMsgArgs = new Object[1];
        if (msgArgs != null) {
            updatedMsgArgs = new Object[msgArgs.length + 1];
            for (int i = 0; i < msgArgs.length; ++i) {
                updatedMsgArgs[i] = msgArgs[i];
            }
        }
        updatedMsgArgs[updatedMsgArgs.length - 1] = additionalInsert;
        return updatedMsgArgs;
    }

    private boolean isPBKDF2WithHmacSHA512Configured() {
        return this.hashType.equals("PBKDF2WithHmacSHA512");
    }

    private boolean isXORConfigured() {
        return this.hashType.equals("xor");
    }
}

