/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BoundedCommonCache<T>
implements Serializable {
    private static final long serialVersionUID = -6352052283899728877L;
    private static final transient TraceComponent tc = Tr.register(BoundedCommonCache.class, null, null);
    private int capacity;
    private List<T> cache = Collections.synchronizedList(new ArrayList());

    public BoundedCommonCache(int maxCapacity) {
        if (maxCapacity < 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cache capacity cannot be negative. Cache capacity will be set to 0.", (Object[])new Object[0]);
            }
            this.capacity = 0;
        } else {
            this.capacity = maxCapacity;
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void updateCapacity(int newCapacity) {
        if (newCapacity < 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Updated cache capacity cannot be negative. Cache capacity will be updated to 0.", (Object[])new Object[0]);
            }
            this.capacity = 0;
        } else {
            this.capacity = newCapacity;
        }
        int entriesToRemove = this.size() - this.capacity;
        this.removeExcessEntries(entriesToRemove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List<T> list = this.cache;
        synchronized (list) {
            return this.cache.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(T key) {
        List<T> list = this.cache;
        synchronized (list) {
            return this.cache.contains(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(T key) {
        List<T> list = this.cache;
        synchronized (list) {
            if (this.cache.indexOf(key) > -1) {
                return this.cache.get(this.cache.indexOf(key));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(T key) {
        List<T> list = this.cache;
        synchronized (list) {
            if (this.cache.contains(key)) {
                T existingKey = this.cache.get(this.cache.indexOf(key));
                this.cache.remove(existingKey);
            }
        }
        int size = this.size();
        if (size >= this.capacity) {
            int entriesToRemove = size - this.capacity + 1;
            this.removeExcessEntries(entriesToRemove);
        }
        if (this.capacity > 0) {
            this.cache.add(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T key) {
        List<T> list = this.cache;
        synchronized (list) {
            return this.cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExcessEntries(int entriesToRemove) {
        List<T> list = this.cache;
        synchronized (list) {
            Iterator<T> it = this.cache.iterator();
            for (int i = 0; it.hasNext() && i < entriesToRemove; ++i) {
                it.next();
                it.remove();
            }
        }
    }
}

