/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.util.ContentRange;
import com.ibm.ws.security.oauth20.util.StringUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MediaRange
extends ContentRange {
    private final HashMap<String, String[]> _parameters;
    private final HashMap<String, String[]> _extensions;
    static final long serialVersionUID = -3097316942779230129L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public String getType() {
        return super.getType();
    }

    public Map<String, String[]> getParameters() {
        return this._parameters;
    }

    public Map<String, String[]> getExtensions() {
        return this._extensions;
    }

    @Override
    public String toString() {
        StringBuffer buf;
        block5: {
            block4: {
                buf = new StringBuffer();
                buf.append(this._type);
                if (!this._parameters.isEmpty()) {
                    for (Map.Entry<String, String[]> entry : this._parameters.entrySet()) {
                        buf.append(';');
                        buf.append(String.format("%s=%s", entry.getKey(), entry.getValue()));
                    }
                }
                if ((double)this._qValue.floatValue() != 1.0) break block4;
                if (this._extensions.isEmpty()) break block5;
                buf.append(String.format(";q=%s", this._qValue.toString()));
                for (Map.Entry<String, String[]> entry : this._extensions.entrySet()) {
                    buf.append(';');
                    buf.append(String.format("%s=%s", entry.getKey(), entry.getValue()));
                }
                break block5;
            }
            buf.append(String.format(";q=%s", this._qValue.toString()));
            for (Map.Entry<String, String[]> entry : this._extensions.entrySet()) {
                buf.append(';');
                buf.append(String.format("%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        return buf.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof MediaRange)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        MediaRange that = (MediaRange)o;
        return this._qValue.equals(that._qValue) && this._type.equalsIgnoreCase(that._type) && MediaRange.parmMapsEqual(this._parameters, that._parameters) && MediaRange.parmMapsEqual(this._extensions, that._extensions);
    }

    @Override
    public int hashCode() {
        return this._type.hashCode();
    }

    private static boolean parmMapsEqual(Map<String, String[]> thisMap, Map<String, String[]> thatMap) {
        if (thatMap == null && thisMap == null) {
            return true;
        }
        if (thatMap == null && thisMap != null || thatMap != null && thisMap == null) {
            return false;
        }
        for (Map.Entry<String, String[]> entry : thatMap.entrySet()) {
            String thatKey = entry.getKey();
            String[] thatVal = entry.getValue();
            String[] thisVal = thisMap.get(thatKey);
            if (thisVal == null) {
                return false;
            }
            if (MediaRange.arraysEqual(thisVal, thatVal)) continue;
            return false;
        }
        for (Map.Entry<String, String[]> entry : thisMap.entrySet()) {
            String thisKey = entry.getKey();
            String[] thisVal = entry.getValue();
            String[] thatVal = thatMap.get(thisKey);
            if (thatVal == null) {
                return false;
            }
            if (MediaRange.arraysEqual(thatVal, thisVal)) continue;
            return false;
        }
        return true;
    }

    private static boolean arraysEqual(String[] a, String[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b == null || a == null && b != null) {
            return false;
        }
        Arrays.sort(a);
        Arrays.sort(b);
        return Arrays.equals(a, b);
    }

    public MediaRange(String type, HashMap<String, String[]> parameters, Float qValue, HashMap<String, String[]> extensions) {
        super(type == null || type.length() == 0 ? "*/*" : type, qValue);
        this._parameters = parameters == null ? new HashMap() : parameters;
        this._extensions = extensions == null ? new HashMap() : extensions;
    }

    public static MediaRange[] parse(String value) {
        ContentRange.RangeParseCallback cb = new ContentRange.RangeParseCallback(){
            static final long serialVersionUID = -4826104009443792144L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ContentRange rangeParsed(String type, HashMap<String, String[]> parameters, Float qValue, HashMap<String, String[]> extensions) {
                return new MediaRange(type, parameters, qValue, extensions);
            }

            @Override
            public void preSort(ArrayList<ContentRange> rangeList) {
            }

            @Override
            public void postSort(ArrayList<ContentRange> range) {
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.util.MediaRange$1", 1.class, null, null);
            }
        };
        ContentRange[] range = ContentRange.parse(value, cb);
        MediaRange[] newRange = (MediaRange[])Array.newInstance(MediaRange.class, range.length);
        System.arraycopy(range, 0, newRange, 0, range.length);
        return newRange;
    }

    @Override
    public int compareTo(ContentRange that) {
        float rhs;
        if (that == null || !(that instanceof MediaRange)) {
            return 1;
        }
        float lhs = this._qValue.floatValue();
        if (lhs == (rhs = that._qValue.floatValue())) {
            String[] thatType;
            String[] thisType = StringUtil.splitAcceptPairAllowingSingleAsterisk(this._type);
            if (thisType[0].equalsIgnoreCase((thatType = StringUtil.splitAcceptPairAllowingSingleAsterisk(that._type))[0])) {
                if (thisType[1].equalsIgnoreCase(thatType[1])) {
                    return MediaRange.compareParms(this, (MediaRange)that);
                }
                if (thisType[1].equals("*")) {
                    return 1;
                }
                if (thatType[1].equals("*")) {
                    return -1;
                }
                return thisType[1].compareTo(thatType[1]);
            }
            if (thisType[0].equals("*")) {
                return 1;
            }
            if (thatType[0].equals("*")) {
                return -1;
            }
            return this._type.compareTo(that._type);
        }
        if (lhs < rhs) {
            return 1;
        }
        return -1;
    }

    private boolean matchesParms(List<String> params) {
        Map<String, String[]> parmMap = this.getParameters();
        for (String parm : params) {
            String[] splitParm = parm.split("=", 2);
            if (splitParm.length != 2) {
                return false;
            }
            String parmName = splitParm[0].toLowerCase().trim();
            String parmValue = splitParm[1].toLowerCase().trim();
            if (!parmMap.containsKey(parmName)) continue;
            boolean valueFound = false;
            for (String value : parmMap.get(parmName)) {
                if (!parmValue.equals(value)) continue;
                valueFound = true;
                break;
            }
            if (valueFound) continue;
            return false;
        }
        return true;
    }

    private static int compareParms(MediaRange a, MediaRange b) {
        if (!(a._parameters != null && !a._parameters.isEmpty() || b._parameters != null && !b._parameters.isEmpty() || a._extensions != null && !a._extensions.isEmpty() || b._extensions != null && !b._extensions.isEmpty())) {
            return 0;
        }
        if (a._parameters != null && !a._parameters.isEmpty() && (b._parameters == null || b._parameters.isEmpty())) {
            return -1;
        }
        if (b._parameters != null && !b._parameters.isEmpty() && (a._parameters == null || a._parameters.isEmpty())) {
            return 1;
        }
        if (a._extensions != null && !a._extensions.isEmpty() && (b._extensions == null || b._extensions.isEmpty())) {
            return -1;
        }
        if (b._extensions != null && !b._extensions.isEmpty() && (a._extensions == null || a._extensions.isEmpty())) {
            return 1;
        }
        return 0;
    }

    private static boolean allMediaRangesHaveQValue1(MediaRange[] mediaRanges) {
        for (MediaRange mediaRange : mediaRanges) {
            if (mediaRange.getQValue().floatValue() == 1.0f) continue;
            return false;
        }
        return true;
    }

    public static float getQValue(MediaRange mediaRange, boolean allMediaRangeHaveQValue1) {
        return !allMediaRangeHaveQValue1 || mediaRange.getQValue().floatValue() != 1.0f ? mediaRange.getQValue().floatValue() : ("*/*".equals(mediaRange.getType()) ? 0.1f : (mediaRange.getType().endsWith("/*") ? 0.2f : 1.0f));
    }

    public static boolean contentRangesMatch(ContentRange contentRange1, ContentRange contentRange2) {
        block5: {
            block4: {
                if (contentRange1 == contentRange2 || (contentRange1.getType() != null ? contentRange1.getType().equals(contentRange2.getType()) : contentRange2.getType() == null)) break block4;
                if (!"*/*".equals(contentRange1.getType()) && !"*/*".equals(contentRange2.getType())) break block5;
            }
            return true;
        }
        if (contentRange1.getType().charAt(contentRange1.getType().length() - 1) == '*' || contentRange2.getType().charAt(contentRange2.getType().length() - 1) == '*') {
            String mainType1 = contentRange1.getType().substring(0, contentRange1.getType().indexOf(47));
            return contentRange2.getType().startsWith(mainType1 + '/');
        }
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.util.MediaRange", MediaRange.class, null, null);
    }
}

