/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.util.OAuth20Parameter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
public class OAuth20XMLHandler
extends DefaultHandler {
    private static TraceComponent tc = Tr.register(OAuth20XMLHandler.class, (String)"OAuth20Provider", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    protected File configFile;
    protected ArrayList<OAuth20Parameter> parameters;
    protected OAuth20Parameter currentParam;
    boolean inValue;
    StringBuilder currentValue;
    static final long serialVersionUID = -7641613247673328553L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public OAuth20XMLHandler(File f) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{f});
        }
        this.configFile = null;
        this.parameters = null;
        this.currentParam = null;
        this.inValue = false;
        this.currentValue = null;
        this.parameters = new ArrayList();
        this.configFile = f;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void parse() throws SAXException, IOException, ParserConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parse", (Object)new Object[0]);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(this.configFile, (DefaultHandler)this);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parse");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public List<OAuth20Parameter> getParameters() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getParameters", (Object)new Object[0]);
        }
        ArrayList<OAuth20Parameter> arrayList = this.parameters;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            arrayList = arrayList;
            Tr.exit((TraceComponent)tc, (String)"getParameters", arrayList);
        }
        return arrayList;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startElement", (Object)new Object[]{uri, localName, qName, attributes});
        }
        if (qName.equals("parameter")) {
            String paramName = attributes.getValue("name");
            String paramType = attributes.getValue("type");
            String customizable = attributes.getValue("customizable");
            this.currentParam = new OAuth20Parameter(paramName, paramType, customizable);
            this.parameters.add(this.currentParam);
        } else if (qName.equals("value")) {
            this.inValue = true;
            this.currentValue = new StringBuilder();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startElement");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"endElement", (Object)new Object[]{uri, localName, qName});
        }
        if (qName.equals("value")) {
            this.currentParam.addValue(this.currentValue.toString());
            this.inValue = false;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"read parameter", (Object)new Object[]{this.currentParam});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"endElement");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"characters", (Object)new Object[]{ch, start, length});
        }
        if (this.inValue) {
            this.currentValue.append(ch, start, length);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"characters");
        }
    }
}

