/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bytebuffer.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.bytebuffer.internal.PooledWsByteBufferImpl;
import com.ibm.ws.bytebuffer.internal.RefCountWsByteBufferImpl;
import com.ibm.ws.bytebuffer.internal.WsByteBufferPoolManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.util.concurrent.atomic.AtomicBoolean;

public class WsByteBufferImpl
implements WsByteBuffer,
Externalizable {
    private static final long serialVersionUID = 3794216509672320032L;
    private static final TraceComponent tc = Tr.register(WsByteBufferImpl.class, (String)"WsByteBuffer", (String)"com.ibm.ws.bytebuffer.internal.resources.ByteBufferMessages");
    protected ByteBuffer oByteBuffer = null;
    public ByteBuffer oWsBBDirect = null;
    protected final AtomicBoolean booleanReleaseCalled = new AtomicBoolean(false);
    private WsByteBufferPoolManagerImpl oWsByteBufferPoolManager = null;
    private boolean isDirectPool = false;
    private boolean readOnly = false;
    private boolean trusted = false;
    private boolean removedFromLeakDetection = false;
    private String ownerID = null;
    private long lastAccessTime = 0L;
    protected PooledWsByteBufferImpl wsBBRoot = null;
    protected RefCountWsByteBufferImpl wsBBRefRoot = null;
    protected static final int NOT_ACTIVATED = 0;
    protected static final int ACTIVATED = 1;
    protected int quickBufferAction = 0;
    private static final int GET_THRESHOLD = 1023;
    private static final int PUT_THRESHOLD = 2047;
    private int status = 1;

    public PooledWsByteBufferImpl getWsBBRoot() {
        return this.wsBBRoot;
    }

    public void setWsBBRoot(PooledWsByteBufferImpl wsbb) {
        this.wsBBRoot = wsbb;
    }

    public RefCountWsByteBufferImpl getWsBBRefRoot() {
        return this.wsBBRefRoot;
    }

    public void setWsBBRefRoot(RefCountWsByteBufferImpl wsbb) {
        this.wsBBRefRoot = wsbb;
    }

    @Override
    public byte[] array() {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("array(): " + (null != this.oByteBuffer.array())), (Object[])new Object[0]);
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.array();
    }

    @Override
    public int arrayOffset() {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("arrayOffset(): " + this.oByteBuffer.arrayOffset()), (Object[])new Object[0]);
        }
        return this.oByteBuffer.arrayOffset();
    }

    @Override
    public WsByteBuffer compact() {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"compact(): before oByteBuffer.compact()", (Object[])new Object[]{this});
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.compact();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"compact(): after oByteBuffer.compact()", (Object[])new Object[]{this});
        }
        return this;
    }

    @Override
    public int compareTo(Object obj) {
        if (!this.trusted) {
            this.checkValidity();
        }
        ByteBuffer other = ((WsByteBuffer)obj).getWrappedByteBufferNonSafe();
        return this.oByteBuffer.compareTo(other);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public char getChar() {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getChar();
    }

    @Override
    public char getChar(int index) {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getChar(index);
    }

    @Override
    public WsByteBuffer putChar(char value) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putChar(value);
        return this;
    }

    @Override
    public WsByteBuffer putChar(int index, char value) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putChar(index, value);
        return this;
    }

    @Override
    public WsByteBuffer putChar(char[] values) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.putChar(values, 0, values.length);
    }

    @Override
    public WsByteBuffer putChar(char[] values, int off, int len) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        if (off + len > values.length) {
            throw new IllegalArgumentException("Invalid Parameters: off=" + off + ", len=" + len + ", values.length=" + values.length);
        }
        for (int i = off; i < off + len; ++i) {
            this.oByteBuffer.putChar(values[i]);
        }
        return this;
    }

    @Override
    public double getDouble() {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getDouble();
    }

    @Override
    public double getDouble(int index) {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getDouble(index);
    }

    @Override
    public WsByteBuffer putDouble(double value) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putDouble(value);
        return this;
    }

    @Override
    public WsByteBuffer putDouble(int index, double value) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putDouble(index, value);
        return this;
    }

    @Override
    public float getFloat() {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getFloat();
    }

    @Override
    public float getFloat(int index) {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getFloat(index);
    }

    @Override
    public WsByteBuffer putFloat(float value) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putFloat(value);
        return this;
    }

    @Override
    public WsByteBuffer putFloat(int index, float value) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putFloat(index, value);
        return this;
    }

    @Override
    public int getInt() {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getInt();
    }

    @Override
    public int getInt(int index) {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getInt(index);
    }

    @Override
    public WsByteBuffer putInt(int value) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putInt(value);
        return this;
    }

    @Override
    public WsByteBuffer putInt(int index, int value) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putInt(index, value);
        return this;
    }

    @Override
    public long getLong() {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getLong();
    }

    @Override
    public long getLong(int index) {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getLong(index);
    }

    @Override
    public WsByteBuffer putLong(long value) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putLong(value);
        return this;
    }

    @Override
    public WsByteBuffer putLong(int index, long value) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putLong(index, value);
        return this;
    }

    @Override
    public short getShort() {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getShort();
    }

    @Override
    public short getShort(int index) {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.getShort(index);
    }

    @Override
    public WsByteBuffer putShort(short value) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putShort(value);
        return this;
    }

    @Override
    public WsByteBuffer putShort(int index, short value) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.putShort(index, value);
        return this;
    }

    @Override
    public WsByteBuffer putString(String value) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.put(value.getBytes());
        return this;
    }

    @Override
    public boolean hasArray() {
        return this.oByteBuffer.hasArray();
    }

    @Override
    public ByteOrder order() {
        return this.oByteBuffer.order();
    }

    @Override
    public WsByteBuffer order(ByteOrder bo) {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.order(bo);
        return this;
    }

    @Override
    public WsByteBuffer clear() {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.clear();
        return this;
    }

    @Override
    public int capacity() {
        return this.oByteBuffer.capacity();
    }

    @Override
    public WsByteBuffer flip() {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.flip();
        return this;
    }

    private void copyRangeToDirectBuffer(int min, int max) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("copyRangeToDirectBuffer(min,max) " + min + "," + max), (Object[])new Object[0]);
        }
        int directPosition = this.oWsBBDirect.position();
        int directLimit = this.oWsBBDirect.limit();
        this.oWsBBDirect.limit(max + 1);
        this.oWsBBDirect.position(min);
        this.oWsBBDirect.put(this.oByteBuffer.array(), min + this.oByteBuffer.arrayOffset(), max - min + 1);
        this.oWsBBDirect.limit(directLimit);
        this.oWsBBDirect.position(directPosition);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"copyRangeToDirectBuffer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setBufferAction(int newAction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setBufferAction(newAction): " + newAction), (Object[])new Object[0]);
        }
        boolean returnValue = false;
        if (this.wsBBRoot == null) {
            this.wsBBRoot = new PooledWsByteBufferImpl();
        }
        Object object = this.wsBBRoot.actionAccess;
        synchronized (object) {
            if (newAction == 1) {
                if (!this.oByteBuffer.isDirect() && this.wsBBRoot.actionState == 0) {
                    this.wsBBRoot.actionState = 1;
                    this.quickBufferAction = 1;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("actionState set to COPY_WHEN_NEEDED_STATE1: " + this.wsBBRoot.actionState), (Object[])new Object[0]);
                    }
                    if (this.oWsBBDirect == null) {
                        this.oWsBBDirect = ByteBuffer.allocateDirect(this.oByteBuffer.capacity());
                    }
                    returnValue = true;
                }
            } else if (newAction == 2) {
                if ((this.wsBBRoot.actionState == 1 || this.wsBBRoot.actionState == 2) && this.wsBBRoot.readMin != -1 && this.wsBBRoot.readMax != -1) {
                    this.moveUpUsingGetMinMax(this.wsBBRoot.readMin, this.wsBBRoot.readMax, 0);
                }
                this.wsBBRoot.actionState = 4;
                this.quickBufferAction = 0;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("actionState set to COPY_ALL_FINAL: " + this.wsBBRoot.actionState), (Object[])new Object[0]);
                }
                returnValue = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("setBufferAction returning: " + returnValue));
        }
        return returnValue;
    }

    private void moveDownUsingPutMinMax(int newPutMin, int newPutMax) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("moveDownUsingPutMinMax(min,max) " + newPutMin + "," + newPutMax), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current putMin and putMax are: " + this.wsBBRoot.putMin + "," + this.wsBBRoot.putMax), (Object[])new Object[0]);
        }
        if (this.wsBBRoot.actionState == 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("actionState set to COPY_WHEN_NEEDED_STATE2: " + this.wsBBRoot.actionState), (Object[])new Object[0]);
            }
            this.wsBBRoot.actionState = 2;
        }
        if (newPutMin >= this.wsBBRoot.putMin && newPutMax <= this.wsBBRoot.putMax || this.wsBBRoot.putMax == -1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (this.wsBBRoot.putMax == -1) {
                    Tr.debug((TraceComponent)tc, (String)"putMin/putMax are in initial state, set them to the new values", (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)"new values are inside putMin/putMax, nothing will be done", (Object[])new Object[0]);
                }
            }
            if (this.wsBBRoot.putMax == -1) {
                this.wsBBRoot.putMin = newPutMin;
                this.wsBBRoot.putMax = newPutMax;
                this.reduceReadMinMax(newPutMin, newPutMax);
            }
        } else if (newPutMax < this.wsBBRoot.putMin - 1 || newPutMin > this.wsBBRoot.putMax + 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"new min/max completely outside putMin/putMax", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)"copy putMin/putMax to Direct buffer, then set putMin/putMax to new values", (Object[])new Object[0]);
            }
            boolean avoidCopy = false;
            if (this.wsBBRoot.readMin == -1 || this.wsBBRoot.readMin > newPutMax && this.wsBBRoot.readMin > this.wsBBRoot.putMax || this.wsBBRoot.readMax < newPutMin && this.wsBBRoot.readMax < this.wsBBRoot.putMin) {
                if (this.wsBBRoot.putMin > newPutMin) {
                    if (this.wsBBRoot.putMin - newPutMax <= 2047) {
                        this.wsBBRoot.putMin = newPutMin;
                        avoidCopy = true;
                    }
                } else if (newPutMin - this.wsBBRoot.putMax <= 2047) {
                    this.wsBBRoot.putMax = newPutMax;
                    avoidCopy = true;
                }
            }
            if (!avoidCopy) {
                this.copyRangeToDirectBuffer(this.wsBBRoot.putMin, this.wsBBRoot.putMax);
                this.wsBBRoot.putMin = newPutMin;
                this.wsBBRoot.putMax = newPutMax;
                this.reduceReadMinMax(newPutMin, newPutMax);
            }
        } else if (newPutMax <= this.wsBBRoot.putMax || newPutMax == this.wsBBRoot.putMin - 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"new min/max runs into putMin/putMax, set putMin to new value only", (Object[])new Object[0]);
            }
            this.wsBBRoot.putMin = newPutMin;
            this.reduceReadMinMax(this.wsBBRoot.putMin, this.wsBBRoot.putMax);
        } else if (newPutMin >= this.wsBBRoot.putMin || newPutMin == this.wsBBRoot.putMax + 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"new min/max runs out from putMin/putMax, set putMax to new value only", (Object[])new Object[0]);
            }
            this.wsBBRoot.putMax = newPutMax;
            this.reduceReadMinMax(this.wsBBRoot.putMin, this.wsBBRoot.putMax);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"new min/max contains putMin/putMax, set putMin/putMax to new values", (Object[])new Object[0]);
            }
            this.wsBBRoot.putMin = newPutMin;
            this.wsBBRoot.putMax = newPutMax;
            this.reduceReadMinMax(newPutMin, newPutMax);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"moveDownUsingPutMinMax");
        }
    }

    private void copyRangeFromDirectBuffer(int min, int max) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("copyRangeFromDirectBuffer(min,max) " + min + "," + max), (Object[])new Object[0]);
        }
        if (min > max) {
            Exception ex = new Exception("minumum is greater than maximum");
            FFDCFilter.processException((Throwable)ex, (String)(this.getClass().getName() + ".copyRangeFromDirectBuffer"), (String)"837", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR: min > max", (Object[])new Object[0]);
            }
        } else {
            int directPosition = this.oWsBBDirect.position();
            int directLimit = this.oWsBBDirect.limit();
            this.oWsBBDirect.limit(max + 1);
            this.oWsBBDirect.position(min);
            this.oWsBBDirect.get(this.oByteBuffer.array(), min + this.oByteBuffer.arrayOffset(), max - min + 1);
            this.oWsBBDirect.limit(directLimit);
            this.oWsBBDirect.position(directPosition);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"copyRangeFromDirectBuffer");
        }
    }

    private void reduceReadMinMax(int reduceMin, int reduceMax) {
        if (reduceMin <= this.wsBBRoot.readMin) {
            if (reduceMax >= this.wsBBRoot.readMax) {
                this.wsBBRoot.readMin = -1;
                this.wsBBRoot.readMax = -1;
            } else if (reduceMax >= this.wsBBRoot.readMin) {
                this.wsBBRoot.readMin = reduceMax + 1;
            }
        } else if (reduceMax > this.wsBBRoot.readMax && reduceMin <= this.wsBBRoot.readMax) {
            this.wsBBRoot.readMax = reduceMin - 1;
        }
    }

    private void moveUpUsingGetMinMax(int newGetMin, int newGetMax, int recursing) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("moveUpUsingGetMinMax(min,max) " + newGetMin + "," + newGetMax), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current getMin, getMax: " + this.wsBBRoot.getMin + "," + this.wsBBRoot.getMax + " actionState: " + this.wsBBRoot.actionState), (Object[])new Object[0]);
        }
        if (recursing == 0 && newGetMax - newGetMin < 1023) {
            newGetMax = newGetMin + 1023 < this.limit() ? newGetMin + 1023 : this.limit() - 1;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("expanded min,max: " + newGetMin + "," + newGetMax), (Object[])new Object[0]);
            }
        }
        if (this.wsBBRoot.actionState == 1) {
            if (newGetMax < this.wsBBRoot.getMin || newGetMin > this.wsBBRoot.getMax) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"new get is outside current getMin/getMax, so pull up data into NonDirect buffer", (Object[])new Object[0]);
                }
                this.copyRangeFromDirectBuffer(newGetMin, newGetMax);
                this.wsBBRoot.getMin = newGetMin;
                this.wsBBRoot.getMax = newGetMax;
                this.reduceReadMinMax(newGetMin, newGetMax);
            } else if (newGetMax <= this.wsBBRoot.getMax && newGetMin >= this.wsBBRoot.getMin) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"new get is inside current getMin/getMax, nothing done", (Object[])new Object[0]);
                }
            } else if (newGetMax <= this.wsBBRoot.getMax) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"new get runs into current getMin/getMax, pull up new data only", (Object[])new Object[0]);
                }
                newGetMax = this.wsBBRoot.getMin - 1;
                this.copyRangeFromDirectBuffer(newGetMin, newGetMax);
                this.wsBBRoot.getMin = newGetMin;
                this.reduceReadMinMax(this.wsBBRoot.getMin, this.wsBBRoot.getMax);
            } else if (newGetMin >= this.wsBBRoot.getMin) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"new get runs out of current getMin/getMax, pull up new data only", (Object[])new Object[0]);
                }
                newGetMin = this.wsBBRoot.getMax + 1;
                this.copyRangeFromDirectBuffer(newGetMin, newGetMax);
                this.wsBBRoot.getMax = newGetMax;
                this.reduceReadMinMax(this.wsBBRoot.getMin, this.wsBBRoot.getMax);
            } else {
                this.copyRangeFromDirectBuffer(newGetMin, this.wsBBRoot.getMin - 1);
                this.copyRangeFromDirectBuffer(this.wsBBRoot.getMax + 1, newGetMax);
                this.wsBBRoot.getMin = newGetMin;
                this.wsBBRoot.getMax = newGetMax;
                this.reduceReadMinMax(newGetMin, newGetMax);
            }
        } else if (this.wsBBRoot.actionState == 2) {
            if (this.wsBBRoot.putMax != -1) {
                boolean returnNow = false;
                if (newGetMax <= this.wsBBRoot.putMax && newGetMin >= this.wsBBRoot.putMin) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"new get is inside putMin/putMax, nothing done", (Object[])new Object[0]);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"moveUpUsingGetMinMax, exit point 1");
                    }
                    return;
                }
                if (newGetMin < this.wsBBRoot.putMin && newGetMax >= this.wsBBRoot.putMin) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"new get begins before putMin/putMax, move up to NonDirect buffer this beginning data", (Object[])new Object[0]);
                    }
                    this.moveUpUsingGetMinMax(newGetMin, this.wsBBRoot.putMin - 1, 1);
                    returnNow = true;
                }
                if (newGetMax > this.wsBBRoot.putMax && newGetMin <= this.wsBBRoot.putMax) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"new get ends after putMin/putMax, move up to NonDirect buffer this trailing data", (Object[])new Object[0]);
                    }
                    this.moveUpUsingGetMinMax(this.wsBBRoot.putMax + 1, newGetMax, 1);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"moveUpUsingGetMinMax, exit point 2");
                    }
                    return;
                }
                if (returnNow) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"moveUpUsingGetMinMax, exit point 3");
                    }
                    return;
                }
            }
            if (newGetMax <= this.wsBBRoot.getMax && newGetMin >= this.wsBBRoot.getMin) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"new get is inside getMin/getMax, nothing done", (Object[])new Object[0]);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"moveUpUsingGetMinMax, exit point 4");
                }
                return;
            }
            if (newGetMax < this.wsBBRoot.getMin || newGetMin > this.wsBBRoot.getMax) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"new get ends outside getMin/getMax, move up to NonDirect this data", (Object[])new Object[0]);
                }
                this.copyRangeFromDirectBuffer(newGetMin, newGetMax);
                this.wsBBRoot.getMin = newGetMin;
                this.wsBBRoot.getMax = newGetMax;
                this.reduceReadMinMax(newGetMin, newGetMax);
            } else if (newGetMax <= this.wsBBRoot.getMax) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"new get runs into getMin/getMax, move up new data only", (Object[])new Object[0]);
                }
                newGetMax = this.wsBBRoot.getMin - 1;
                this.copyRangeFromDirectBuffer(newGetMin, newGetMax);
                this.wsBBRoot.getMin = newGetMin;
                this.reduceReadMinMax(this.wsBBRoot.getMin, this.wsBBRoot.getMax);
            } else if (newGetMin >= this.wsBBRoot.getMin) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"new get runs out of getMin/getMax, move up new data only", (Object[])new Object[0]);
                }
                newGetMin = this.wsBBRoot.getMax + 1;
                this.copyRangeFromDirectBuffer(newGetMin, newGetMax);
                this.wsBBRoot.getMax = newGetMax;
                this.reduceReadMinMax(this.wsBBRoot.getMin, this.wsBBRoot.getMax);
            } else {
                this.copyRangeFromDirectBuffer(newGetMin, this.wsBBRoot.getMin - 1);
                this.copyRangeFromDirectBuffer(this.wsBBRoot.getMax + 1, newGetMax);
                this.wsBBRoot.getMin = newGetMin;
                this.wsBBRoot.getMax = newGetMax;
                this.reduceReadMinMax(newGetMin, newGetMax);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"actionState is invalid, continuing on.", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"moveUpUsingGetMinMax, exit point 5");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte get() {
        if (!this.trusted) {
            this.checkValidity();
        }
        byte b = 0;
        if (this.quickBufferAction == 0) {
            b = this.oByteBuffer.get();
        } else {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (this.wsBBRoot.actionState == 1 || this.wsBBRoot.actionState == 2) {
                    int min = this.oByteBuffer.position();
                    this.moveUpUsingGetMinMax(min, min, 0);
                    b = this.oByteBuffer.get();
                } else {
                    this.quickBufferAction = 0;
                    b = this.oByteBuffer.get();
                }
            }
        }
        return b;
    }

    @Override
    public int position() {
        return this.oByteBuffer.position();
    }

    @Override
    public WsByteBuffer position(int p) {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.position(p);
        return this;
    }

    @Override
    public WsByteBuffer limit(int l) {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.limit(l);
        return this;
    }

    @Override
    public int limit() {
        return this.oByteBuffer.limit();
    }

    @Override
    public int remaining() {
        return this.oByteBuffer.remaining();
    }

    @Override
    public WsByteBuffer mark() {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.mark();
        return this;
    }

    @Override
    public WsByteBuffer reset() {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.reset();
        return this;
    }

    @Override
    public WsByteBuffer rewind() {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.rewind();
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.oByteBuffer.isReadOnly();
    }

    @Override
    public boolean hasRemaining() {
        return this.oByteBuffer.hasRemaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WsByteBuffer get(byte[] dst) {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 0) {
            this.oByteBuffer.get(dst);
        } else {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (this.wsBBRoot.actionState == 1 || this.wsBBRoot.actionState == 2) {
                    int min = this.oByteBuffer.position();
                    int max = min + dst.length - 1;
                    if (max >= this.oByteBuffer.limit()) {
                        this.oByteBuffer.get(dst);
                    } else {
                        this.moveUpUsingGetMinMax(min, max, 0);
                        this.oByteBuffer.get(dst);
                    }
                } else {
                    this.quickBufferAction = 0;
                    this.oByteBuffer.get(dst);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WsByteBuffer get(byte[] dst, int offset, int length) {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 0) {
            this.oByteBuffer.get(dst, offset, length);
        } else {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("wsBBRoot.actionState: " + this.wsBBRoot.actionState), (Object[])new Object[0]);
                }
                if (this.wsBBRoot.actionState == 1 || this.wsBBRoot.actionState == 2) {
                    int min = this.oByteBuffer.position();
                    int max = min + length - 1;
                    if (max >= this.oByteBuffer.limit()) {
                        this.oByteBuffer.get(dst, offset, length);
                    } else {
                        this.moveUpUsingGetMinMax(min, max, 0);
                        this.oByteBuffer.get(dst, offset, length);
                    }
                } else {
                    this.quickBufferAction = 0;
                    this.oByteBuffer.get(dst, offset, length);
                }
            }
        }
        return this;
    }

    @Override
    public byte get(int index) {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer.get(index);
    }

    @Override
    public boolean isDirect() {
        return this.oByteBuffer.isDirect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WsByteBuffer put(byte b) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 0) {
            this.oByteBuffer.put(b);
        } else {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (this.wsBBRoot.actionState == 1 || this.wsBBRoot.actionState == 2) {
                    int min = this.oByteBuffer.position();
                    this.moveDownUsingPutMinMax(min, min);
                    this.oByteBuffer.put(b);
                } else {
                    this.quickBufferAction = 0;
                    this.oByteBuffer.put(b);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WsByteBuffer put(byte[] src) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 0) {
            this.oByteBuffer.put(src);
        } else {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (this.wsBBRoot.actionState == 1 || this.wsBBRoot.actionState == 2) {
                    int min = this.oByteBuffer.position();
                    int max = min + src.length - 1;
                    if (max >= this.oByteBuffer.limit()) {
                        this.oByteBuffer.put(src);
                    } else {
                        this.moveDownUsingPutMinMax(min, max);
                        this.oByteBuffer.put(src);
                    }
                } else {
                    this.quickBufferAction = 0;
                    this.oByteBuffer.put(src);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WsByteBuffer put(byte[] src, int offset, int length) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 0) {
            this.oByteBuffer.put(src, offset, length);
        } else {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (this.wsBBRoot.actionState == 1 || this.wsBBRoot.actionState == 2) {
                    int min = this.oByteBuffer.position();
                    int max = min + length - 1;
                    if (max >= this.oByteBuffer.limit()) {
                        this.oByteBuffer.put(src, offset, length);
                    } else {
                        this.moveDownUsingPutMinMax(min, max);
                        this.oByteBuffer.put(src, offset, length);
                    }
                } else {
                    this.quickBufferAction = 0;
                    this.oByteBuffer.put(src, offset, length);
                }
            }
        }
        return this;
    }

    @Override
    public WsByteBuffer put(int index, byte b) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.put(index, b);
        return this;
    }

    @Override
    public WsByteBuffer put(ByteBuffer src) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.put(src);
        return this;
    }

    @Override
    public WsByteBuffer put(WsByteBuffer src) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer.put(src.getWrappedByteBuffer());
        return this;
    }

    @Override
    public WsByteBuffer put(WsByteBuffer[] src) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        for (int i = 0; i < src.length && src[i] != null; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    @Override
    public ByteBuffer getWrappedByteBuffer() {
        if (!this.trusted) {
            this.checkValidity();
        }
        return this.getWrappedByteBufferCommon(false);
    }

    @Override
    public ByteBuffer getWrappedByteBufferNonSafe() {
        return this.getWrappedByteBufferCommon(true);
    }

    private ByteBuffer getWrappedByteBufferCommon(boolean internal) {
        if (!internal && this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        return this.oByteBuffer;
    }

    @Override
    public WsByteBuffer duplicate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"duplicate", (Object[])new Object[0]);
        }
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.oWsByteBufferPoolManager != null) {
            return this.oWsByteBufferPoolManager.duplicate(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Did not find pool manager, returning null", (Object[])new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDuplicate(WsByteBufferImpl wsbytebufferNew) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateDuplicate", (Object[])new Object[0]);
        }
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.readOnly) {
            wsbytebufferNew.setReadOnly(true);
        }
        wsbytebufferNew.setByteBufferNonSafe(this.oByteBuffer.duplicate());
        wsbytebufferNew.quickBufferAction = this.quickBufferAction;
        if (!this.oByteBuffer.isDirect() && this.quickBufferAction == 1) {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (this.wsBBRoot.actionState == 1 || this.wsBBRoot.actionState == 2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"buffer optimization on, duplicating shadow direct buffer", (Object[])new Object[0]);
                    }
                    int savedPosition = this.oWsBBDirect.position();
                    this.oWsBBDirect.position(this.oByteBuffer.position());
                    wsbytebufferNew.setDirectShadowBuffer(this.oWsBBDirect.duplicate());
                    this.oWsBBDirect.position(savedPosition);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateDuplicate");
        }
    }

    @Override
    public WsByteBuffer slice() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"slice", (Object[])new Object[0]);
        }
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.oWsByteBufferPoolManager != null) {
            return this.oWsByteBufferPoolManager.slice(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Did not find pool manager, returning null", (Object[])new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSlice(WsByteBufferImpl wsbytebufferNew) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateSlice", (Object[])new Object[0]);
        }
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.readOnly) {
            wsbytebufferNew.setReadOnly(true);
        }
        wsbytebufferNew.setByteBufferNonSafe(this.oByteBuffer.slice());
        wsbytebufferNew.quickBufferAction = this.quickBufferAction;
        if (!this.oByteBuffer.isDirect() && this.quickBufferAction == 1) {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (this.wsBBRoot.actionState == 1 || this.wsBBRoot.actionState == 2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"buffer optomization on, slicing shadow direct buffer", (Object[])new Object[0]);
                    }
                    int savedPosition = this.oWsBBDirect.position();
                    this.oWsBBDirect.position(this.oByteBuffer.position());
                    wsbytebufferNew.setDirectShadowBuffer(this.oWsBBDirect.slice());
                    this.oWsBBDirect.position(savedPosition);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateSlice");
        }
    }

    protected void resetReleaseCalled() {
        this.booleanReleaseCalled.set(false);
        this.readOnly = false;
    }

    public void printStackToDebug() {
        int start;
        for (int i = start = (ste = (t = new Throwable()).getStackTrace()).length > 6 ? 6 : ste.length; i >= 1; --i) {
            StackTraceElement[] ste;
            Tr.debug((TraceComponent)tc, (String)("Calling Stack Element[" + i + "]: " + ste[i]), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        WsByteBufferImpl wsByteBufferImpl;
        Throwable t;
        StackTraceElement[] ste;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && (ste = (t = new Throwable()).getStackTrace()).length >= 2) {
            if (this.wsBBRoot == null || this.wsBBRoot.pool == null) {
                Tr.debug((TraceComponent)tc, (String)("BUFFER RELEASED: Calling Element: " + ste[1] + " Main ID: none " + this), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)("BUFFER RELEASED: Calling Element: " + ste[1] + " Main ID: " + this.wsBBRoot.getID() + " " + this), (Object[])new Object[0]);
            }
        }
        if (this.wsBBRoot == null || this.wsBBRoot.pool == null) {
            if (this.wsBBRefRoot != null) {
                wsByteBufferImpl = this.wsBBRefRoot;
                synchronized (wsByteBufferImpl) {
                    this.checkValidity();
                    --this.wsBBRefRoot.intReferenceCount;
                    if (this.wsBBRefRoot.intReferenceCount == 0) {
                        this.oWsByteBufferPoolManager.releasing(this.wsBBRefRoot.getWrappedByteBuffer());
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Marking wsBBRefRoot as released", (Object[])new Object[0]);
                        }
                        this.wsBBRefRoot.booleanReleaseCalled.set(true);
                    }
                    if (this.wsBBRefRoot != this) {
                        this.booleanReleaseCalled.set(true);
                    }
                }
            }
            return;
        }
        wsByteBufferImpl = this.wsBBRoot;
        synchronized (wsByteBufferImpl) {
            this.checkValidity();
            if (this.oWsByteBufferPoolManager.getLeakDetectionInterval() > -1) {
                Object object = this.oWsByteBufferPoolManager.getLeakDetectionSyncObject();
                synchronized (object) {
                    this.booleanReleaseCalled.set(true);
                    --this.wsBBRoot.intReferenceCount;
                    this.releaseFromLeakDetection();
                    if (this.wsBBRoot.intReferenceCount == 0) {
                        this.oWsByteBufferPoolManager.release(this.wsBBRoot, this.isDirectPool, this.wsBBRoot.pool);
                    }
                }
            } else {
                this.booleanReleaseCalled.set(true);
                --this.wsBBRoot.intReferenceCount;
                if (this.wsBBRoot.intReferenceCount == 0) {
                    this.oWsByteBufferPoolManager.release(this.wsBBRoot, this.isDirectPool, this.wsBBRoot.pool);
                }
            }
        }
    }

    private void releaseFromLeakDetection() {
        if (this.wsBBRoot != null && this.wsBBRoot.pool != null) {
            this.wsBBRoot.removeWsByteBuffer(this);
        }
        if (this.ownerID != null) {
            this.wsBBRoot.removeOwner(this.ownerID);
        }
    }

    protected void setIsDirectPool(boolean value) {
        this.isDirectPool = value;
    }

    protected boolean getIsDirectPool() {
        return this.isDirectPool;
    }

    @Override
    public void setReadOnly(boolean value) {
        this.readOnly = value;
    }

    @Override
    public boolean getReadOnly() {
        return this.readOnly;
    }

    protected void setOwnerID(String value) {
        this.ownerID = value;
        this.lastAccessTime = System.currentTimeMillis();
    }

    protected String getOwnerID() {
        return this.ownerID;
    }

    protected long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setPoolManagerRef(WsByteBufferPoolManagerImpl oManagerRef) {
        this.oWsByteBufferPoolManager = oManagerRef;
        this.trusted = oManagerRef.isTrustedUsers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setPoolManagerRef:  trusted=" + this.trusted), (Object[])new Object[0]);
        }
    }

    public void setByteBuffer(ByteBuffer buffer) {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.setByteBufferCommon(buffer, false);
    }

    public void setByteBufferNonSafe(ByteBuffer buffer) {
        this.setByteBufferCommon(buffer, true);
    }

    private void setByteBufferCommon(ByteBuffer buffer, boolean internal) {
        if (!internal && this.quickBufferAction == 1) {
            this.setBufferAction(2);
        }
        this.oByteBuffer = buffer;
    }

    public void setDirectShadowBuffer(ByteBuffer buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setDirectShadowBuffer", (Object[])new Object[0]);
        }
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oWsBBDirect = buffer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setDirectShadowBuffer");
        }
    }

    private void checkReadOnly() {
        if (this.readOnly) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                String id = "none";
                if (this.wsBBRoot != null && this.wsBBRoot.pool != null) {
                    id = Integer.toString(this.wsBBRoot.getID());
                }
                Tr.debug((TraceComponent)tc, (String)("Attempt to update a read only WsByteBuffer.\nWsByteBuffer: ID: " + id + "\nBuffer: " + this.oByteBuffer), (Object[])new Object[0]);
            }
            ReadOnlyBufferException robe = new ReadOnlyBufferException();
            FFDCFilter.processException((Throwable)robe, (String)(this.getClass().getName() + ".checkReadOnly"), (String)"1", (Object)this);
            throw robe;
        }
    }

    private void checkValidity() {
        if (this.booleanReleaseCalled.get()) {
            String id = "none";
            if (this.wsBBRoot != null && this.wsBBRoot.pool != null) {
                id = Integer.toString(this.wsBBRoot.getID());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Attempt to access WsByteBuffer that was already released.\nWsByteBuffer: ID: " + id + " Sub ID: " + this.oByteBuffer), (Object[])new Object[0]);
            }
            RuntimeException iae = new RuntimeException("Invalid call to WsByteBuffer method.  Buffer has already been released.\nWsByteBuffer: ID: " + id + "\nBuffer: " + this.oByteBuffer);
            FFDCFilter.processException((Throwable)iae, (String)(this.getClass().getName() + ".checkValidity"), (String)"1", (Object)this);
            throw iae;
        }
        if (this.ownerID != null) {
            this.lastAccessTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToDirectBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"copyToDirectBuffer", (Object[])new Object[0]);
        }
        if (this.oByteBuffer.isDirect()) {
            this.oWsBBDirect = this.oByteBuffer;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"copyToDirectBuffer, exit point 1");
            }
            return;
        }
        if (this.quickBufferAction == 1) {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (this.wsBBRoot.actionState == 1) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"bufferAction in STATE1, do not copy", (Object[])new Object[0]);
                    }
                    this.oWsBBDirect.limit(this.oByteBuffer.limit());
                    this.oWsBBDirect.position(this.oByteBuffer.position());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"copyToDirectBuffer, exit point 2");
                    }
                    return;
                }
                if (this.wsBBRoot.actionState == 2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"bufferAction in STATE2, copy only changed data", (Object[])new Object[0]);
                    }
                    if (this.wsBBRoot.putMin != -1 && this.wsBBRoot.putMax != -1) {
                        this.copyRangeToDirectBuffer(this.wsBBRoot.putMin, this.wsBBRoot.putMax);
                        this.wsBBRoot.putMin = -1;
                        this.wsBBRoot.putMax = -1;
                    }
                    this.oWsBBDirect.limit(this.oByteBuffer.limit());
                    this.oWsBBDirect.position(this.oByteBuffer.position());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"copyToDirectBuffer, exit point 3");
                    }
                    return;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"buffer optimization is off, copy all data", (Object[])new Object[0]);
        }
        if (this.oWsBBDirect == null) {
            this.oWsBBDirect = ByteBuffer.allocateDirect(this.oByteBuffer.capacity());
        }
        int cachePosition = this.oByteBuffer.position();
        int cacheLimit = this.oByteBuffer.limit();
        int offset = this.oByteBuffer.arrayOffset();
        this.oWsBBDirect.limit(cacheLimit);
        this.oWsBBDirect.position(cachePosition);
        this.oWsBBDirect.put(this.oByteBuffer.array(), cachePosition + offset, cacheLimit - cachePosition);
        this.oWsBBDirect.position(cachePosition);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"copyToDirectBuffer, exit point 4");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFromDirectBuffer(int bytesRead) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("copyFromDirectBuffer: " + bytesRead), (Object[])new Object[0]);
        }
        int newPosition = this.oWsBBDirect.position();
        int cachePosition = this.oByteBuffer.position();
        if (this.quickBufferAction == 0) {
            this.oWsBBDirect.position(cachePosition);
            if (bytesRead == -1) {
                this.oWsBBDirect.get(this.oByteBuffer.array(), cachePosition + this.oByteBuffer.arrayOffset(), this.oByteBuffer.remaining());
            } else if (bytesRead > 0) {
                this.oWsBBDirect.get(this.oByteBuffer.array(), cachePosition + this.oByteBuffer.arrayOffset(), bytesRead);
            }
            this.oByteBuffer.position(newPosition);
        } else {
            Object object = this.wsBBRoot.actionAccess;
            synchronized (object) {
                if (this.wsBBRoot.actionState == 1) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"actionState: STATE1 - nothing will be copied", (Object[])new Object[0]);
                    }
                    this.oByteBuffer.position(newPosition);
                    int min = cachePosition;
                    int max = newPosition - 1;
                    if (this.wsBBRoot.readMin == -1 || min < this.wsBBRoot.readMin) {
                        this.wsBBRoot.readMin = min;
                    }
                    if (this.wsBBRoot.readMax == -1 || max > this.wsBBRoot.readMax) {
                        this.wsBBRoot.readMax = max;
                    }
                    if (this.wsBBRoot.getMax >= this.wsBBRoot.readMin && this.wsBBRoot.getMin <= this.wsBBRoot.readMax) {
                        this.wsBBRoot.getMax = -1;
                        this.wsBBRoot.getMin = -1;
                    }
                } else {
                    if (this.wsBBRoot.actionState == 2) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"actionState: STATE2, first copy up any previously read data", (Object[])new Object[0]);
                        }
                        if (this.wsBBRoot.readMin != -1 && this.wsBBRoot.readMax != -1) {
                            this.moveUpUsingGetMinMax(this.wsBBRoot.readMin, this.wsBBRoot.readMax, 0);
                        }
                    }
                    this.wsBBRoot.actionState = 4;
                    this.quickBufferAction = 0;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"actionState: COPY_ALL_FINAL, copy currently read data to NonDirect buffer ", (Object[])new Object[0]);
                    }
                    this.oWsBBDirect.position(cachePosition);
                    if (bytesRead == -1) {
                        this.oWsBBDirect.get(this.oByteBuffer.array(), cachePosition + this.oByteBuffer.arrayOffset(), this.oByteBuffer.remaining());
                    } else if (bytesRead > 0) {
                        this.oWsBBDirect.get(this.oByteBuffer.array(), cachePosition + this.oByteBuffer.arrayOffset(), bytesRead);
                    }
                    this.oByteBuffer.position(newPosition);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"copyFromDirectBuffer");
        }
    }

    public void setParmsToDirectBuffer() {
        if (this.oByteBuffer.isDirect()) {
            this.oWsBBDirect = this.oByteBuffer;
            return;
        }
        if (this.oWsBBDirect == null) {
            this.oWsBBDirect = ByteBuffer.allocateDirect(this.oByteBuffer.capacity());
        }
        this.oWsBBDirect.limit(this.oByteBuffer.limit());
        this.oWsBBDirect.position(this.oByteBuffer.position());
    }

    public void setParmsFromDirectBuffer() {
        this.oByteBuffer.position(this.oWsBBDirect.position());
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int value) {
        this.status = value;
    }

    public String toString() {
        if (null == this.oByteBuffer) {
            return "[null]";
        }
        return this.oByteBuffer.toString();
    }

    @Override
    public void removeFromLeakDetection() {
        if (this.ownerID != null) {
            this.releaseFromLeakDetection();
            if (this.wsBBRoot != null && this.wsBBRoot.pool != null) {
                this.wsBBRoot.pool.removeFromInUse(this.wsBBRoot);
            }
        }
        this.removedFromLeakDetection = true;
    }

    @Override
    public void writeExternal(ObjectOutput s) throws IOException {
        if (!this.removedFromLeakDetection && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Buffer being serialized but removeFromLeakDetection has not been called: " + this), (Object[])new Object[0]);
        }
        if (this.oByteBuffer.isDirect()) {
            s.writeObject("D");
        } else {
            s.writeObject("ND");
        }
        if (this.oByteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            s.writeObject("B");
        } else {
            s.writeObject("L");
        }
        int startPosition = this.oByteBuffer.position();
        int startLimit = this.oByteBuffer.limit();
        this.oByteBuffer.position(0);
        this.oByteBuffer.limit(this.oByteBuffer.capacity());
        if (this.oByteBuffer.hasArray() && this.oByteBuffer.arrayOffset() == 0) {
            s.writeObject(this.oByteBuffer.array());
        } else {
            byte[] bytes = new byte[this.oByteBuffer.limit()];
            this.oByteBuffer.get(bytes);
            s.writeObject(bytes);
        }
        this.oByteBuffer.position(startPosition);
        this.oByteBuffer.limit(startLimit);
        s.writeObject(Integer.toString(startPosition));
        s.writeObject(Integer.toString(startLimit));
        if (this.readOnly) {
            s.writeObject("R");
        } else {
            s.writeObject("RW");
        }
    }

    @Override
    public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
        String type = (String)s.readObject();
        String endian = (String)s.readObject();
        byte[] bytes = (byte[])s.readObject();
        if (type.equals("ND")) {
            this.oByteBuffer = ByteBuffer.wrap(bytes);
            if (endian.equals("B")) {
                this.oByteBuffer.order(ByteOrder.BIG_ENDIAN);
            } else {
                this.oByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
        } else {
            this.oByteBuffer = ByteBuffer.allocateDirect(bytes.length);
            if (endian.equals("B")) {
                this.oByteBuffer.order(ByteOrder.BIG_ENDIAN);
            } else {
                this.oByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            this.oByteBuffer.put(bytes);
        }
        this.oByteBuffer.position(Integer.parseInt((String)s.readObject()));
        this.oByteBuffer.limit(Integer.parseInt((String)s.readObject()));
        String rOnly = (String)s.readObject();
        this.readOnly = rOnly.equals("R");
        this.oWsByteBufferPoolManager = (WsByteBufferPoolManagerImpl)WsByteBufferPoolManagerImpl.getRef();
        this.trusted = this.oWsByteBufferPoolManager.isTrustedUsers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("readExternal:  trusted set to: " + this.trusted), (Object[])new Object[0]);
        }
        this.removedFromLeakDetection = true;
    }
}

