/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.websphere;

import com.cognos.cps.common.io.EnhancedIOException;
import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.utils.CookieUtils;
import com.cognos.cps.soap.SOAPObjectHandler;
import com.cognos.cps.soap.helpers.SOAPConnectionImpl;
import com.cognos.cps.wsrp.consumer.HttpSOAPConnection;
import com.cognos.cps.wsrp.consumer.impls.websphere.credentials.ActiveCredentialHelper;
import com.cognos.cps.wsrp.consumer.impls.websphere.credentials.LtpaTokenCredentialHelper;
import com.cognos.cps.wsrp.consumer.impls.websphere.credentials.SiteMinderTokenCredentialHelper;
import com.cognos.cps.wsrp.consumer.impls.websphere.credentials.WebSealTokenCredentialHelper;
import com.ibm.wps.portletservice.credentialvault.CredentialSecretNotSetException;
import com.ibm.wps.portletservice.credentialvault.CredentialVaultService;
import com.ibm.wps.portletservice.credentialvault.credentials.ActiveCredential;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.apache.jetspeed.portlet.PortletConfig;
import org.apache.jetspeed.portlet.PortletContext;
import org.apache.jetspeed.portlet.PortletRequest;
import org.apache.jetspeed.portlet.PortletResponse;
import org.apache.jetspeed.portlet.service.ContentAccessService;
import org.apache.jetspeed.portlet.service.PortletServiceException;

public class HttpSOAPConnectionImpl
extends SOAPConnectionImpl
implements HttpSOAPConnection {
    static final String ACTIVE_CREDENTIAL_TYPE = "Active Credential Type";
    private static final String NO_AUTH = "";
    static final String LTPA_TOKEN = "LtpaToken";
    static final String SITE_MINDER_TOKEN = "SiteMinderToken";
    static final String WEB_SEAL_TOKEN = "WebSealToken";
    private static final Class m_serviceClass = ContentAccessService.class;
    private static ContentAccessService m_accessService = null;
    private static CredentialVaultService m_vaultService = null;
    private static boolean m_initialized = false;
    private PortletRequest m_request = null;
    private PortletResponse m_response = null;
    private String m_namespaceId;
    private static Map m_credentialHelpers = new HashMap();
    private Cookie[] m_requestCookies = null;
    private Cookie[] m_responseCookies = null;

    public static synchronized void init(PortletConfig config, CredentialVaultService vaultService, ServiceLogger logger) {
        if (m_initialized) {
            return;
        }
        logger.debug("HttpSOAPConnectionImpl.init() called.");
        PortletContext context = config.getContext();
        try {
            m_accessService = (ContentAccessService)context.getService(m_serviceClass);
        }
        catch (Exception e) {
            m_accessService = null;
            logger.warn("HttpSOAPConnectionImpl not available.");
        }
        m_vaultService = vaultService;
        m_initialized = true;
    }

    public HttpSOAPConnectionImpl(PortletRequest request, PortletResponse response, SOAPObjectHandler objectHandler, String namespaceId, ServiceLogger logger) {
        super(objectHandler, logger);
        this.m_logger = logger;
        this.m_request = request;
        this.m_response = response;
        this.m_namespaceId = namespaceId;
    }

    public void setRequestCookies(Cookie[] cookies) {
        this.m_requestCookies = cookies;
    }

    public void addRequestCookies(Cookie[] cookies) {
        this.m_requestCookies = CookieUtils.addCookies((Cookie[])this.m_requestCookies, (Cookie[])cookies);
    }

    public void addRequestCookie(Cookie cookie) {
        this.m_requestCookies = CookieUtils.addCookie((Cookie[])this.m_requestCookies, (Cookie)cookie);
    }

    public Cookie[] getResponseCookies() {
        return this.m_responseCookies;
    }

    public HttpURLConnection openConnection(URL url) throws IOException {
        this.m_logger.debug("HttpSOAPConnectionImpl.openConnection(URL) called.");
        ActiveCredentialHelper credentialHelper = this.getCredentialHelper(this.m_request);
        if (credentialHelper == null) {
            this.m_connection = this.getNonAuthenticatedHttpConnection(url.toExternalForm());
        } else {
            ActiveCredential activeCredential = null;
            try {
                activeCredential = credentialHelper.getCredential(this.m_request, m_vaultService);
            }
            catch (PortletServiceException e) {
                this.m_logger.error("HttpSOAPConnectionImpl.getConnection(URL): Exception occurred while retrieving credential.", (Throwable)e);
                throw new EnhancedIOException("cps.ws.failedtoretrievecredential", (Object[])new String[]{url.toExternalForm()}, (Throwable)e);
            }
            catch (CredentialSecretNotSetException e) {
                this.m_logger.error("HttpSOAPConnectionImpl.getConnection(URL): Exception occurred while retrieving credential.", (Throwable)e);
                throw new EnhancedIOException("cps.ws.failedtoretrievecredential", (Object[])new String[]{url.toExternalForm()}, (Throwable)e);
            }
            this.m_connection = credentialHelper.getAuthenticatedConnection(activeCredential, url);
        }
        if (this.m_namespaceId != null && !"(none)".equals(this.m_namespaceId) && this.m_namespaceId.length() > 0) {
            this.m_connection.setRequestProperty("CAM-Namespace", this.m_namespaceId);
        }
        CookieUtils.addCookies((HttpURLConnection)this.m_connection, (Cookie[])this.m_requestCookies);
        this.m_connection.setRequestProperty("Accept-Language", this.m_request.getLocale().toString() + ",en-us;q=0.5");
        return this.m_connection;
    }

    private HttpURLConnection getNonAuthenticatedHttpConnection(String url) throws IOException {
        try {
            if (m_accessService == null) {
                return this.getHttpConnectionFromFactory(new URL(url));
            }
            URL oURL = m_accessService.getURL(url, this.m_request, this.m_response);
            if (oURL == null) {
                return null;
            }
            return (HttpURLConnection)oURL.openConnection();
        }
        catch (PortletServiceException e) {
            this.m_logger.error("Error occurred while retrieving a connection from the ContentAccessService", (Throwable)e);
            throw new EnhancedIOException("cps.ws.failedtoretrieveconnection", (Object[])new String[]{url}, (Throwable)e);
        }
    }

    public void disconnect() {
        this.m_logger.debug("disconnect() called.");
        if (this.m_connection != null) {
            this.m_responseCookies = CookieUtils.getSetCookies((HttpURLConnection)this.m_connection);
            if (this.m_responseCookies != null) {
                this.m_logger.debug("Cookies returned in response: ");
                for (int i = 0; i < this.m_responseCookies.length; ++i) {
                    this.m_logger.debug("Cookie: " + this.m_responseCookies[i].getName());
                }
            } else {
                this.m_logger.debug("No cookies returned in response.");
            }
        }
    }

    private HttpURLConnection getHttpConnectionFromFactory(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    private ActiveCredentialHelper getCredentialHelper(PortletRequest request) throws IOException {
        String activeCredentialType = request.getPortletSettings().getApplicationSettings().getAttribute(ACTIVE_CREDENTIAL_TYPE);
        if (activeCredentialType == null || activeCredentialType.length() == 0 || activeCredentialType.equals("(none)")) {
            activeCredentialType = NO_AUTH;
        } else if (!m_credentialHelpers.containsKey(activeCredentialType)) {
            throw new EnhancedIOException("cps.ws.unsupportedcredentialtype", new Object[]{activeCredentialType});
        }
        return (ActiveCredentialHelper)m_credentialHelpers.get(activeCredentialType);
    }

    static {
        m_credentialHelpers.put(NO_AUTH, null);
        m_credentialHelpers.put(LTPA_TOKEN, new LtpaTokenCredentialHelper(LTPA_TOKEN));
        m_credentialHelpers.put(SITE_MINDER_TOKEN, new SiteMinderTokenCredentialHelper(SITE_MINDER_TOKEN));
        m_credentialHelpers.put(WEB_SEAL_TOKEN, new WebSealTokenCredentialHelper(WEB_SEAL_TOKEN));
    }
}

