/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.websphere;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.utils.Base64;
import com.cognos.cps.common.utils.GetVersion;
import com.cognos.cps.common.utils.XMLUtils;
import com.cognos.cps.services.pagelet.objects.v1.types.PortalContext;
import com.cognos.cps.services.wsrp.v1.types.BlockingInteractionResponse;
import com.cognos.cps.services.wsrp.v1.types.ClientData;
import com.cognos.cps.services.wsrp.v1.types.Extension;
import com.cognos.cps.services.wsrp.v1.types.InteractionParams;
import com.cognos.cps.services.wsrp.v1.types.MarkupParams;
import com.cognos.cps.services.wsrp.v1.types.NamedString;
import com.cognos.cps.services.wsrp.v1.types.PortletContext;
import com.cognos.cps.services.wsrp.v1.types.RuntimeContext;
import com.cognos.cps.services.wsrp.v1.types.StateChange;
import com.cognos.cps.services.wsrp.v1.types.TypeFactory;
import com.cognos.cps.services.wsrp.v1.types.UpdateResponse;
import com.cognos.cps.services.wsrp.v1.types.UserContext;
import com.cognos.cps.wsrp.consumer.ConsumerException;
import com.cognos.cps.wsrp.consumer.ObjectHandlerDefault;
import com.cognos.cps.wsrp.consumer.helpers.ExtensionHelper;
import java.util.Enumeration;
import org.apache.jetspeed.portlet.Portlet;
import org.apache.jetspeed.portlet.PortletApplicationSettings;
import org.apache.jetspeed.portlet.PortletConfig;
import org.apache.jetspeed.portlet.PortletData;
import org.apache.jetspeed.portlet.PortletRequest;
import org.apache.jetspeed.portlet.PortletResponse;
import org.apache.jetspeed.portlet.PortletSettings;
import org.apache.jetspeed.portlet.PortletWindow;
import org.apache.jetspeed.portlet.User;

public class ObjectHandlerImpl
extends ObjectHandlerDefault {
    private static final String SOLO_STATE = "Solo";
    private static final String PORTLET_SETTINGS_PORTLET_STATE = "CPS-PortletState";
    private static final String PORTLET_SETTINGS_PORTLET_HANDLE = "CPS-PortletHandle";
    protected static final String PORTLET_DATA_PORTLET_CONTEXT = "CPS-PortletContext";
    public static final String NAVIGATIONAL_STATE = "NavigationalState";
    private static final String[] m_packages = new String[]{"com.cognos.cps.common", "com.cognos.cps.wsrp.consumer.impls.websphere", "javax.xml.parsers", "javax.xml.transform", "org.xml.sax", "java.lang"};
    private static final String[] m_supportedModes = new String[]{"wsrp:view", "wsrp:edit", "wsrp:preview", "wsrp:help", "cps:config"};
    private static final String[] m_supportedWindowStates = new String[]{"wsrp:normal", "wsrp:maximized", "wsrp:minimized"};
    private PortletRequest m_request = null;
    private MarkupParams m_markupParams = null;

    public ObjectHandlerImpl(PortletRequest request, PortletResponse response, PortletConfig config, ServiceLogger logger) {
        this.m_request = request;
        this.m_logger = logger;
        this.m_includeVersionInfo = this.m_request.getMode() == Portlet.Mode.CONFIGURE;
    }

    public PortletContext getPortletContext(String hashkey, String initialPortletHandle) throws ConsumerException {
        this.m_logger.debug("getPortletContext() called.");
        PortletContext portletContext = null;
        if (this.m_request.getMode() == Portlet.Mode.CONFIGURE) {
            this.m_logger.debug("Returning admin level PortletContext.");
            portletContext = this.getAdminLevelPortletContext(initialPortletHandle);
        } else {
            this.m_logger.debug("Returning user level PortletContext.");
            PortletData portletData = this.m_request.getData();
            portletContext = (PortletContext)portletData.getAttribute(PORTLET_DATA_PORTLET_CONTEXT);
            if (portletContext == null || portletContext.getPortletState() == null || portletContext.getPortletState().length == 0) {
                portletContext = this.getAdminLevelPortletContext(initialPortletHandle);
            }
        }
        return portletContext;
    }

    private PortletContext getAdminLevelPortletContext(String initialPortletHandle) throws ConsumerException {
        PortletContext portletContext = TypeFactory.newInstance().createPortletContext();
        PortletSettings portletSettings = this.m_request.getPortletSettings();
        String portletHandle = portletSettings.getAttribute(PORTLET_SETTINGS_PORTLET_HANDLE);
        if (portletHandle == null) {
            portletContext.setPortletHandle(initialPortletHandle);
            return portletContext;
        }
        portletContext.setPortletHandle(portletHandle);
        String portletState = portletSettings.getAttribute(PORTLET_SETTINGS_PORTLET_STATE);
        if (portletState != null) {
            portletContext.setPortletState(Base64.decode((String)portletState));
        }
        return portletContext;
    }

    public void storePortletContext(String hashkey, PortletContext portletContext) throws ConsumerException {
        this.m_logger.debug("storePortletContext() called.");
        try {
            if (this.m_request.getMode() == Portlet.Mode.CONFIGURE) {
                this.m_logger.debug("Storing admin level PortletContext.");
                PortletSettings portletSettings = this.m_request.getPortletSettings();
                portletSettings.setAttribute(PORTLET_SETTINGS_PORTLET_HANDLE, portletContext.getPortletHandle());
                byte[] portletState = portletContext.getPortletState();
                if (portletState != null) {
                    portletSettings.setAttribute(PORTLET_SETTINGS_PORTLET_STATE, Base64.encode((byte[])portletState));
                }
                portletSettings.store();
            } else if (this.m_request.getMode() == Portlet.Mode.EDIT) {
                this.m_logger.debug("User level PortletContext.");
                PortletData portletData = this.m_request.getData();
                portletData.setAttribute(PORTLET_DATA_PORTLET_CONTEXT, (Object)portletContext);
                portletData.store();
            }
        }
        catch (Exception e) {
            Object[] args = new String[]{"PortletContext"};
            throw new ConsumerException("cps.ws.objectstoragefailed", args, (Throwable)e);
        }
    }

    public RuntimeContext createRuntimeContext(String hashkey) throws ConsumerException {
        this.m_logger.debug("createRuntimeContext() called.");
        RuntimeContext runtimeContext = TypeFactory.newInstance().createRuntimeContext();
        runtimeContext.setUserAuthentication("wsrp:password");
        String portletInstanceKey = this.m_request.getParameter("wsrp-portletInstanceKey");
        if (portletInstanceKey != null) {
            runtimeContext.setPortletInstanceKey(portletInstanceKey);
        } else {
            runtimeContext.setPortletInstanceKey("p" + Integer.toString(new Object().hashCode()));
        }
        runtimeContext.setNamespacePrefix("p" + Integer.toString(new Object().hashCode()));
        return runtimeContext;
    }

    public UserContext createUserContext(String hashkey) throws ConsumerException {
        this.m_logger.debug("createUserContext() called.");
        UserContext userContext = TypeFactory.newInstance().createUserContext();
        User user = this.m_request.getUser();
        if (user != null) {
            String userId = user.getUserID();
            if (userId == null) {
                userId = user.getFullName();
            }
            userContext.setUserContextKey(userId);
        }
        return userContext;
    }

    public MarkupParams createMarkupParams(String hashkey) throws ConsumerException {
        UpdateResponse updateResponse;
        BlockingInteractionResponse blockingInteractionResponse;
        this.m_logger.debug("createMarkupParams() called.");
        if (this.m_markupParams != null) {
            return this.m_markupParams;
        }
        this.m_markupParams = TypeFactory.newInstance().createMarkupParams();
        String mode = this.getWSRPMode();
        String windowState = this.getWSRPWindowState();
        if (this.m_request.getParameter("wsrp-mode") != null) {
            mode = this.m_request.getParameter("wsrp-mode");
        }
        if (this.m_request.getParameter("wsrp-windowState") != null) {
            windowState = this.m_request.getParameter("wsrp-windowState");
        }
        if (this.m_request.getParameter("wsrp-navigationalState") != null) {
            this.m_request.getSession(true).setAttribute(NAVIGATIONAL_STATE, (Object)this.m_request.getParameter("wsrp-navigationalState"));
        }
        if ((blockingInteractionResponse = (BlockingInteractionResponse)this.m_request.getAttribute("BlockingInteractionResponse")) != null && (updateResponse = blockingInteractionResponse.getUpdateResponse()) != null) {
            String newWindowState;
            String newMode = updateResponse.getNewMode();
            if (newMode != null) {
                mode = newMode;
            }
            if ((newWindowState = updateResponse.getNewWindowState()) != null) {
                windowState = newWindowState;
            }
            this.m_request.getSession(true).setAttribute(NAVIGATIONAL_STATE, (Object)updateResponse.getNavigationalState());
        }
        String navigationalState = (String)this.m_request.getSession().getAttribute(NAVIGATIONAL_STATE);
        this.m_markupParams.setMode(mode);
        this.m_markupParams.setWindowState(windowState);
        this.m_markupParams.setNavigationalState(navigationalState);
        this.m_markupParams.setLocales(this.convertLocalesEnum(this.m_request.getLocales()));
        this.m_markupParams.addMimeTypes(this.m_request.getClient().getMimeType());
        this.m_markupParams.setSecureClientCommunication(false);
        this.m_markupParams.setMarkupCharacterSets(new String[]{"UTF-8"});
        this.m_markupParams.addValidNewModes("wsrp:view");
        if (!mode.equals("wsrp:view")) {
            this.m_markupParams.addValidNewModes(mode);
        }
        for (int i = 0; i < m_supportedWindowStates.length; ++i) {
            this.m_markupParams.addValidNewWindowStates(m_supportedWindowStates[i]);
        }
        if (this.m_includeVersionInfo) {
            Extension versions = TypeFactory.newInstance().createExtension();
            versions.setAnyW3CElement(XMLUtils.parse((String)GetVersion.getVersion((String[])m_packages, (boolean)false)));
            this.m_markupParams.addExtensions(versions);
        }
        ClientData clientData = TypeFactory.newInstance().createClientData();
        clientData.setUserAgent(this.m_request.getClient().getUserAgent());
        this.m_markupParams.setClientData(clientData);
        Extension portalContextExtension = ExtensionHelper.createPortalContextExtension((PortalContext)this.createPortalContext());
        this.m_markupParams.addExtensions(portalContextExtension);
        return this.m_markupParams;
    }

    public InteractionParams createInteractionParams(String hashkey) throws ConsumerException {
        this.m_logger.debug("createInteractionParams() called.");
        InteractionParams interactionParams = TypeFactory.newInstance().createInteractionParams();
        interactionParams.setPortletStateChange(StateChange.READWRITE);
        String interactionState = this.m_request.getParameter("wsrp-interactionState");
        if (interactionState != null) {
            interactionParams.setInteractionState(this.m_request.getParameter("wsrp-interactionState"));
        }
        NamedString formParameter = null;
        Enumeration paramsEnum = this.m_request.getParameterNames();
        String name = null;
        String[] values = null;
        while (paramsEnum.hasMoreElements()) {
            name = (String)paramsEnum.nextElement();
            if (name.startsWith("wsrp-")) continue;
            values = this.m_request.getParameterValues(name);
            for (int i = 0; i < values.length; ++i) {
                formParameter = TypeFactory.newInstance().createNamedString();
                formParameter.setName(name);
                formParameter.setValue(values[i]);
                interactionParams.addFormParameters(formParameter);
            }
        }
        return interactionParams;
    }

    private String getWSRPMode() throws ConsumerException {
        Portlet.Mode mode = this.m_request.getMode();
        if (mode == Portlet.Mode.VIEW) {
            return "wsrp:view";
        }
        if (mode == Portlet.Mode.EDIT) {
            return "wsrp:edit";
        }
        if (mode == Portlet.Mode.HELP) {
            return "wsrp:help";
        }
        if (mode == Portlet.Mode.CONFIGURE) {
            return "cps:config";
        }
        Object[] args = new String[]{mode.toString()};
        throw new ConsumerException("cps.ws.invalidmode", args);
    }

    private String getWSRPWindowState() throws ConsumerException {
        PortletWindow window = this.m_request.getWindow();
        if (window.getWindowState() == PortletWindow.State.NORMAL) {
            return "wsrp:normal";
        }
        if (window.getWindowState() == PortletWindow.State.MAXIMIZED) {
            return "wsrp:maximized";
        }
        if (window.getWindowState() == PortletWindow.State.MINIMIZED) {
            return "wsrp:minimized";
        }
        if (window.getWindowState() == PortletWindow.State.DETACHED || SOLO_STATE.equals(window.getWindowState().toString())) {
            return "wsrp:solo";
        }
        Object[] args = new String[]{window.getWindowState().toString()};
        throw new ConsumerException("cps.ws.invalidwindowstate", args);
    }

    public String getConfigProperty(String name) {
        PortletApplicationSettings applicationSettings = this.m_request.getPortletSettings().getApplicationSettings();
        return applicationSettings.getAttribute(name);
    }

    protected String getPortalAgent() {
        return "WebSphere";
    }

    protected String getConsumerAgent() {
        return "WebSphere.5.0";
    }

    protected String[] getSupportedModes() {
        return m_supportedModes;
    }

    protected String[] getSupportedWindowStates() {
        return m_supportedWindowStates;
    }

    protected Enumeration getRequestParameterNames() {
        return this.m_request.getParameterNames();
    }

    protected String[] getRequestParameterValues(String name) {
        return this.m_request.getParameterValues(name);
    }
}

