/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.websphere;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.services.wsrp.v1.types.TypeFactory;
import com.cognos.cps.soap.SOAPObjectHandler;
import com.cognos.cps.wsrp.consumer.CSSClassSubstitutionHandler;
import com.cognos.cps.wsrp.consumer.CacheHandler;
import com.cognos.cps.wsrp.consumer.ConsumerException;
import com.cognos.cps.wsrp.consumer.HttpSOAPConnection;
import com.cognos.cps.wsrp.consumer.ObjectHandler;
import com.cognos.cps.wsrp.consumer.PropylaealetSession;
import com.cognos.cps.wsrp.consumer.RequestContextDefault;
import com.cognos.cps.wsrp.consumer.URLRewriteHandler;
import com.cognos.cps.wsrp.consumer.helpers.CacheHandlerImpl;
import com.cognos.cps.wsrp.consumer.helpers.PortletSessionImpl;
import com.cognos.cps.wsrp.consumer.impls.websphere.HttpSOAPConnectionImpl;
import com.cognos.cps.wsrp.consumer.impls.websphere.ObjectHandlerImpl;
import com.cognos.cps.wsrp.consumer.impls.websphere.URLRewriterImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.portlet.PortletConfig;
import org.apache.jetspeed.portlet.PortletRequest;
import org.apache.jetspeed.portlet.PortletResponse;
import org.apache.jetspeed.portlet.User;

public class RequestContextImpl
extends RequestContextDefault {
    private static final String CONFIG_MAX_CACHED_PAGES = "Maximum Cached Pages";
    private static final String CPS_AUTH_COOKIE = "cps_auth_user";
    private static final String CPS_AUTH_SECRET = "cps_auth_secret";
    private static final String CPS_AUTH_NAMESPACE = "cps_auth_namespace";
    private PortletRequest m_request = null;
    private PortletResponse m_response = null;
    private PortletConfig m_config = null;
    private PropylaealetSession session = null;
    private HttpServletResponse servletResponse;
    private String m_gatewayHostSessionKey = null;

    private RequestContextImpl() {
    }

    public RequestContextImpl(PortletRequest request, PortletResponse response, PortletConfig config, ServiceLogger logger, CSSClassSubstitutionHandler cssClassSubstitutionHandler, String wsdlUrl) throws ConsumerException {
        this.m_request = request;
        this.m_response = response;
        this.m_config = config;
        this.m_logger = logger;
        this.m_cssClassSubstitutionHandler = cssClassSubstitutionHandler;
        this.m_wsdlUrl = wsdlUrl;
    }

    public ObjectHandler getObjectHandler() {
        if (this.m_objectHandler == null) {
            this.m_objectHandler = new ObjectHandlerImpl(this.m_request, this.m_response, this.m_config, this.m_logger);
        }
        return this.m_objectHandler;
    }

    public CacheHandler getCacheHandler() {
        if (this.m_cacheHandler == null) {
            int maxCachedPagesInt = 0;
            String maxCachedPages = this.m_request.getPortletSettings().getAttribute(CONFIG_MAX_CACHED_PAGES);
            if (maxCachedPages != null && maxCachedPages.length() > 0) {
                try {
                    maxCachedPagesInt = Integer.parseInt(maxCachedPages);
                }
                catch (NumberFormatException e) {
                    this.m_logger.error("Exception occurred while converting Maximum Cached Pagesto an integer.", (Throwable)e);
                }
            }
            this.m_logger.debug("Cached pages set to: " + maxCachedPagesInt);
            this.m_cacheHandler = new CacheHandlerImpl(this.m_logger, this.getSession(), maxCachedPagesInt);
        }
        return this.m_cacheHandler;
    }

    public URLRewriteHandler getURLRewriteHandler() {
        if (this.m_urlRewriteHandler == null) {
            String gatewayHostKey = this.getGatewayHostSessionKey();
            this.m_urlRewriteHandler = new URLRewriterImpl(this.m_request, this.m_response, gatewayHostKey);
        }
        return this.m_urlRewriteHandler;
    }

    private String getGatewayHostSessionKey() {
        if (this.m_gatewayHostSessionKey == null) {
            String key = this.m_wsdlUrl;
            String gatewayValue = this.getObjectHandler().getConfigProperty(this.getGatewayUrlPropertyName());
            if (gatewayValue != null) {
                key = key + gatewayValue;
            }
            this.m_gatewayHostSessionKey = "gt" + key.hashCode();
        }
        return this.m_gatewayHostSessionKey;
    }

    public Writer getResultWriter() throws IOException {
        if (this.servletResponse != null) {
            return new OutputStreamWriter((OutputStream)this.servletResponse.getOutputStream());
        }
        return this.m_response.getWriter();
    }

    public HttpSOAPConnection createHttpSOAPConnection() {
        String namespaceId = this.m_request.getPortletSettings().getApplicationSettings().getAttribute(CPS_AUTH_NAMESPACE);
        return new HttpSOAPConnectionImpl(this.m_request, this.m_response, (SOAPObjectHandler)TypeFactory.newInstance(), namespaceId, this.m_logger);
    }

    public HttpURLConnection createHttpURLConnection(URL url) throws IOException {
        String namespaceId = this.m_request.getPortletSettings().getApplicationSettings().getAttribute(CPS_AUTH_NAMESPACE);
        HttpSOAPConnectionImpl connectionGenerator = new HttpSOAPConnectionImpl(this.m_request, this.m_response, null, namespaceId, this.m_logger);
        return connectionGenerator.openConnection(url);
    }

    public PropylaealetSession getSession() {
        if (this.session == null) {
            this.session = new PortletSessionImpl(this.m_request.getSession(true));
            String key = this.getGatewayHostSessionKey();
            this.session.applyPropertyByNameAndScope(key, (Object)this.getGatewayHostValue(), 9);
        }
        return this.session;
    }

    public Cookie getAuthCookie() {
        this.m_logger.debug("getAuthCookie() called.");
        Cookie cookie = null;
        User user = this.m_request.getUser();
        if (user != null) {
            String secret;
            String userId = user.getUserID();
            if (userId == null) {
                userId = user.getFullName();
            }
            if ((secret = this.m_request.getPortletSettings().getApplicationSettings().getAttribute(CPS_AUTH_SECRET)) != null && "(none)".equals(secret)) {
                secret = null;
            }
            return this.getAuthCookie(userId, secret, CPS_AUTH_COOKIE);
        }
        return cookie;
    }

    void setHttpServletResponse(HttpServletResponse servletResponse) {
        this.servletResponse = servletResponse;
    }
}

