/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.impls.websphere;

import com.cognos.cps.common.utils.CookieUtils;
import com.cognos.cps.common.utils.EncodingUtils;
import com.cognos.cps.wsrp.consumer.RequestContextDefault;
import com.cognos.cps.wsrp.consumer.helpers.ApplicationSessionManager;
import com.ibm.wps.portletservice.credentialvault.credentials.LtpaTokenCredential;
import com.ibm.wps.portletservice.credentialvault.credentials.SiteMinderTokenCredential;
import com.ibm.wps.portletservice.credentialvault.credentials.WebSealTokenCredential;
import com.ibm.wps.sso.credentialvault.secrets.JaasSubjectCredentialSecret;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ResourceServlet
extends HttpServlet {
    public static final String GATEWAY_HOST_KEY = "cps.gkey";
    public static final String TARGET_PARAMETER = "cps.target";
    public static final String ACTIVE_CREDENTIAL_TYPE_PARAMETER = "cps.actype";
    public static final String COOKIE_KEY_PARAMETER = "cps.ckey";
    private static final long serialVersionUID = -3159236676299663838L;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getSession(false) == null) {
            response.setContentType("text/xml");
            response.getWriter().write("<fragment><error><code>invalidCredentials</code></error></fragment>");
            response.getWriter().close();
            return;
        }
        this.proxyRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proxyRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String url = request.getParameter(TARGET_PARAMETER);
        if (url == null) {
            response.sendError(400);
            return;
        }
        HttpURLConnection connection = null;
        try {
            String method = request.getMethod();
            StringBuilder parameters = new StringBuilder();
            boolean isFirst = true;
            Enumeration enumeration = request.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                if (name.startsWith("cps.")) continue;
                if (!isFirst) {
                    parameters.append('&');
                } else {
                    isFirst = false;
                }
                parameters.append(name);
                parameters.append("=");
                String value = request.getParameter(name);
                if (value == null) continue;
                parameters.append(EncodingUtils.urlEncode((String)value, (String)"UTF-8", (boolean)false));
            }
            String postData = null;
            if ("POST".equalsIgnoreCase(method)) {
                postData = parameters.toString();
            } else {
                url = url.indexOf(63) != -1 ? url + "&" : url + "?";
                url = url + parameters.toString();
            }
            String currentHost = RequestContextDefault.getHostFromUrl((String)url);
            String gatewayHost = null;
            Cookie[] cookies = null;
            Map map = ApplicationSessionManager.getAttributeMap((String)("p" + request.getSession().getId()));
            if (map != null) {
                String cookieKey = request.getParameter(COOKIE_KEY_PARAMETER);
                String gatewayHostKey = request.getParameter(GATEWAY_HOST_KEY);
                gatewayHost = (String)map.get(gatewayHostKey);
                if (cookieKey != null) {
                    cookies = (Cookie[])map.get(cookieKey);
                }
            }
            if (!currentHost.equalsIgnoreCase(gatewayHost)) {
                response.sendError(400, "Target not allowed");
                return;
            }
            connection = this.getConnection(url, request.getParameter(ACTIVE_CREDENTIAL_TYPE_PARAMETER), request.getSession());
            if (cookies != null) {
                CookieUtils.addCookies((HttpURLConnection)connection, cookies);
            }
            connection.setRequestMethod(method);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects(true);
            String userAgent = request.getHeader("User-Agent");
            if (userAgent != null) {
                connection.addRequestProperty("User-Agent", userAgent);
            }
            if (postData != null) {
                connection.setDoOutput(true);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(connection.getOutputStream());
                outputStreamWriter.write(postData);
                outputStreamWriter.flush();
            }
            InputStream input = connection.getInputStream();
            response.setStatus(connection.getResponseCode());
            response.setContentType(connection.getContentType());
            ServletOutputStream output = response.getOutputStream();
            byte[] buf = new byte[4096];
            int bytesRead = input.read(buf, 0, 4096);
            while (bytesRead != -1) {
                output.write(buf, 0, bytesRead);
                bytesRead = input.read(buf, 0, 4096);
            }
            input.close();
            output.close();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    HttpURLConnection getConnection(String url, String credentialType, HttpSession httpSession) throws ServletException {
        try {
            String sessionKey = this.getSessionKey(credentialType);
            HttpURLConnection connection = null;
            if ("LtpaToken".equals(credentialType)) {
                LtpaTokenCredential ltpaTokenCredential = (LtpaTokenCredential)httpSession.getAttribute(sessionKey);
                if (ltpaTokenCredential == null) {
                    HashMap<String, Object> config = new HashMap<String, Object>();
                    config.put("CREDENTIAL_SECRET_KEY", this.getSecret());
                    config.put("LTPA_TOKEN_TYPE", "LtpaToken");
                    ltpaTokenCredential = new LtpaTokenCredential();
                    ltpaTokenCredential.init(config);
                    httpSession.setAttribute(sessionKey, (Object)ltpaTokenCredential);
                }
                connection = ltpaTokenCredential.getAuthenticatedConnection(url);
            } else if ("SiteMinderToken".equals(credentialType)) {
                SiteMinderTokenCredential siteMinderTokenCredential = (SiteMinderTokenCredential)httpSession.getAttribute(sessionKey);
                if (siteMinderTokenCredential == null) {
                    HashMap<String, JaasSubjectCredentialSecret> config = new HashMap<String, JaasSubjectCredentialSecret>();
                    config.put("CREDENTIAL_SECRET_KEY", this.getSecret());
                    siteMinderTokenCredential = new SiteMinderTokenCredential();
                    siteMinderTokenCredential.init(config);
                    httpSession.setAttribute(sessionKey, (Object)siteMinderTokenCredential);
                }
                connection = siteMinderTokenCredential.getAuthenticatedConnection(url);
            } else if ("WebSealToken".equals(credentialType)) {
                WebSealTokenCredential webSealTokenCredential = (WebSealTokenCredential)httpSession.getAttribute(sessionKey);
                if (webSealTokenCredential == null) {
                    HashMap<String, JaasSubjectCredentialSecret> config = new HashMap<String, JaasSubjectCredentialSecret>();
                    config.put("CREDENTIAL_SECRET_KEY", this.getSecret());
                    webSealTokenCredential = new WebSealTokenCredential();
                    webSealTokenCredential.init(config);
                    httpSession.setAttribute(sessionKey, (Object)webSealTokenCredential);
                }
                connection = webSealTokenCredential.getAuthenticatedConnection(url);
            }
            if (connection == null) {
                URL oURL = new URL(url);
                connection = (HttpURLConnection)oURL.openConnection();
            }
            return connection;
        }
        catch (Throwable e) {
            throw new ServletException("Cannot create connection : " + e.getMessage(), e);
        }
    }

    private String getSessionKey(String credentialType) {
        return "cps.resource." + credentialType;
    }

    private JaasSubjectCredentialSecret getSecret() {
        try {
            Class<?> c = ((Object)((Object)this)).getClass().getClassLoader().loadClass("com.ibm.websphere.security.auth.WSSubject");
            Method method = c.getMethod("getRunAsSubject", new Class[0]);
            Subject subject = (Subject)method.invoke(c, new Object[0]);
            JaasSubjectCredentialSecret secret = new JaasSubjectCredentialSecret();
            secret.setSecret(subject);
            return secret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

