/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.utils.Boyer;
import com.cognos.cps.wsrp.consumer.CSSClassSubstitutionException;
import com.cognos.cps.wsrp.consumer.CSSClassSubstitutionHandler;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public final class CSSClassSubstituter {
    private static final String[] SEARCH_PATTERNS = new String[]{"portlet-", "cognos-"};
    private static Map m_wsrpCssClassNames = null;
    private static int m_maxClassNameLength = 0;
    private ServiceLogger m_logger = null;
    private static final String[] CSS_CLASSES = new String[]{"portlet-font", "portlet-font-dim", "portlet-msg-status", "portlet-msg-info", "portlet-msg-error", "portlet-msg-alert", "portlet-msg-success", "portlet-section-header", "portlet-section-body", "portlet-section-alternate", "portlet-section-selected", "portlet-section-subheader", "portlet-section-footer", "portlet-section-text", "portlet-table-header", "portlet-table-body", "portlet-table-alternate", "portlet-table-selected", "portlet-table-subheader", "portlet-table-footer", "portlet-table-text", "portlet-form-label", "portlet-form-input-field", "portlet-form-button", "portlet-icon-label", "portlet-dlg-icon-label", "portlet-form-field-label", "portlet-form-field", "portlet-menu", "portlet-menu-item", "portlet-menu-item-selected", "portlet-menu-item-hover", "portlet-menu-item-hover-selected", "portlet-menu-cascade-item", "portlet-menu-cascade-item-selected", "portlet-menu-description", "portlet-menu-caption", "portlet-path", "portlet-help-link", "portlet-anchor", "cognos-path", "cognos-help-link", "cognos-anchor", "cognos-section-background", "cognos-form-input-field"};
    private CSSClassSubstitutionHandler m_substHandler = null;

    private CSSClassSubstituter() {
    }

    public CSSClassSubstituter(CSSClassSubstitutionHandler substHandler, ServiceLogger logger) {
        this.m_substHandler = substHandler;
        this.m_logger = logger;
    }

    public void substitute(String dataIn, Writer dataOut) throws CSSClassSubstitutionException {
        Writer realDataOut = null;
        long start = 0L;
        if (this.m_logger != null) {
            this.m_logger.debug("Performing CSS class substitution on: " + dataIn);
            realDataOut = dataOut;
            dataOut = new CharArrayWriter();
            if (this.m_logger.isInfoEnabled()) {
                start = System.currentTimeMillis();
            }
        }
        try {
            int currentpos = 0;
            Boyer[] boyer = new Boyer[SEARCH_PATTERNS.length];
            int[] search = new int[SEARCH_PATTERNS.length];
            for (int i = 0; i < boyer.length; ++i) {
                boyer[i] = new Boyer(dataIn);
                search[i] = boyer[i].indexOf(SEARCH_PATTERNS[i]);
            }
            while (true) {
                char x;
                int lastPos;
                int dataLen;
                int curIndex = -1;
                for (int index = 0; index < search.length; ++index) {
                    if (search[index] < 0 || curIndex != -1 && search[index] >= search[curIndex]) continue;
                    curIndex = index;
                }
                if (curIndex < 0) break;
                dataOut.write(dataIn, currentpos, search[curIndex] - currentpos);
                int n = dataLen = search[curIndex] + m_maxClassNameLength > dataIn.length() ? dataIn.length() : search[curIndex] + m_maxClassNameLength;
                for (lastPos = search[curIndex] + SEARCH_PATTERNS[curIndex].length(); lastPos < dataLen && ((x = dataIn.charAt(lastPos)) >= 'a' && x <= 'z' || x == '-'); ++lastPos) {
                }
                String className = dataIn.substring(search[curIndex], lastPos);
                if (m_wsrpCssClassNames.containsKey(className)) {
                    dataOut.write(this.m_substHandler.substituteClass(className));
                    search[curIndex] = lastPos;
                    currentpos = lastPos;
                } else {
                    currentpos = search[curIndex];
                    int n2 = curIndex;
                    search[n2] = search[n2] + SEARCH_PATTERNS[curIndex].length();
                }
                search[curIndex] = boyer[curIndex].indexOf(SEARCH_PATTERNS[curIndex], search[curIndex]);
            }
            dataOut.write(dataIn, currentpos, dataIn.length() - currentpos);
            if (this.m_logger != null) {
                if (this.m_logger.isInfoEnabled()) {
                    long end = System.currentTimeMillis();
                    this.m_logger.info("CSS class substitution took: " + (end - start) + "ms.");
                }
                CharArrayWriter saveCast = (CharArrayWriter)dataOut;
                this.m_logger.debug("Result of CSS class substitution: " + new String(saveCast.toCharArray()));
                realDataOut.write(saveCast.toCharArray());
            }
        }
        catch (IOException e) {
            throw new CSSClassSubstitutionException("cps.consumer.cssclasssubstitution", e);
        }
    }

    public void substitute(char[] dataIn, Writer dataOut) throws CSSClassSubstitutionException {
        String _dataIn = new String(dataIn);
        this.substitute(_dataIn, dataOut);
    }

    public void substitute(char[] dataIn, int offset, int count, Writer dataOut) throws CSSClassSubstitutionException {
        String _dataIn = new String(dataIn, offset, count);
        this.substitute(_dataIn, dataOut);
    }

    static {
        m_wsrpCssClassNames = new HashMap();
        for (int i = 0; i < CSS_CLASSES.length; ++i) {
            m_wsrpCssClassNames.put(CSS_CLASSES[i], "");
            if (CSS_CLASSES[i].length() <= m_maxClassNameLength) continue;
            m_maxClassNameLength = CSS_CLASSES[i].length();
        }
    }
}

