/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer;

import com.cognos.cps.services.wsrp.v1.types.CacheControl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class CachedMarkup
implements Serializable {
    private static final long serialVersionUID = -3340505505971644804L;
    private static final int BUFFER_SIZE = 1024;
    private long m_expires = -1L;
    private CacheControl m_cacheControl;
    private byte[] m_compressedMarkupString;
    private long m_lastAccessTime;

    private CachedMarkup() {
    }

    public CachedMarkup(CacheControl cacheControl, String markupString) throws IOException {
        this.m_cacheControl = cacheControl;
        this.updateExpires();
        byte[] b = markupString.getBytes("UTF-8");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(markupString.length());
        GZIPOutputStream gzos = new GZIPOutputStream(bos);
        gzos.write(b);
        gzos.close();
        this.m_compressedMarkupString = bos.toByteArray();
        this.m_lastAccessTime = System.currentTimeMillis();
    }

    public synchronized void updateExpires() {
        int cacheControlExpires = this.m_cacheControl != null ? this.m_cacheControl.getExpires() : 0;
        this.m_expires = System.currentTimeMillis() + (long)(cacheControlExpires * 1000);
    }

    public synchronized long getExpires() {
        return this.m_expires;
    }

    public synchronized void setCacheControl(CacheControl cacheControl) {
        this.m_cacheControl = cacheControl;
    }

    public synchronized CacheControl getCacheControl() {
        return this.m_cacheControl;
    }

    public String getMarkupString() throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(this.m_compressedMarkupString);
        GZIPInputStream gzis = new GZIPInputStream(bis);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this.m_compressedMarkupString.length);
        int nByteRead = 0;
        byte[] buf = new byte[1024];
        while ((nByteRead = gzis.read(buf, 0, 1024)) != -1) {
            bos.write(buf, 0, nByteRead);
        }
        bos.close();
        gzis.close();
        return bos.toString("UTF-8");
    }

    public void getMarkupString(Writer out) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(this.m_compressedMarkupString);
        GZIPInputStream gzis = new GZIPInputStream(bis);
        int nByteRead = 0;
        byte[] buf = new byte[1024];
        while ((nByteRead = gzis.read(buf, 0, 1024)) != -1) {
            out.write(new String(buf, 0, nByteRead, "UTF-8"));
        }
        gzis.close();
    }

    public synchronized void updateLastAccessTime() {
        this.m_lastAccessTime = System.currentTimeMillis();
    }

    public synchronized long getLastAccessTime() {
        return this.m_lastAccessTime;
    }
}

