/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DetailHandler
extends DefaultHandler {
    private static final String BUS_NAMESPACE = "http://developer.cognos.com/schemas/bibus/3/";
    private static final String BUS_MESSAGE = "message";
    private static final String EMPTY_NAMESPACE = "";
    private static final String MESSAGE_STRING = "messageString";
    private StringBuffer out;
    private boolean captureText;
    private int messageCount;
    private boolean asHTML;
    private int maxMessages;
    private boolean busMessage;

    public DetailHandler(StringBuffer out, boolean asHTML, int maxMessages) {
        this.out = out;
        this.asHTML = asHTML;
        this.maxMessages = maxMessages;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.captureText) {
            this.out.append(ch, start, length);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (BUS_NAMESPACE.equals(uri)) {
            if (BUS_MESSAGE.equals(localName)) {
                ++this.messageCount;
                this.busMessage = true;
            }
        } else if (EMPTY_NAMESPACE.equals(uri) && this.busMessage && this.messageCount <= this.maxMessages && MESSAGE_STRING.equals(localName)) {
            this.captureText = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (BUS_NAMESPACE.equals(uri)) {
            if (BUS_MESSAGE.equals(localName)) {
                this.busMessage = false;
            }
        } else if (EMPTY_NAMESPACE.equals(uri) && this.captureText && MESSAGE_STRING.equals(localName)) {
            this.out.append(this.asHTML ? "<br/>" : "\n");
            this.captureText = false;
        }
    }
}

