/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer;

import com.cognos.cps.common.ExceptionExtension;
import com.cognos.cps.common.message.MessagesManager;
import com.cognos.cps.common.sax.SAXUtils;
import com.cognos.cps.soap.SOAPFault;
import com.cognos.cps.wsrp.consumer.DetailHandler;
import com.cognos.cps.wsrp.consumer.FixHelper;
import com.cognos.cps.wsrp.consumer.FixHelperDefault;
import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class ErrorPage {
    public static FixHelper FIX_HELPER = new FixHelperDefault();

    public static String render(ExceptionExtension exception, Locale locale, String imgBaseURL) throws IOException {
        return ErrorPage.render(exception, locale, imgBaseURL, FIX_HELPER);
    }

    public static String render(ExceptionExtension exception, Locale locale, String imgBaseURL, FixHelper fixHelper) throws IOException {
        String[] fixes;
        ExceptionExtension lastException = exception;
        Throwable rootCause = null;
        while (lastException.getRootCause() != null) {
            if (lastException.getRootCause() instanceof ExceptionExtension) {
                lastException = (ExceptionExtension)lastException.getRootCause();
                continue;
            }
            rootCause = lastException.getRootCause();
            break;
        }
        StringBuffer message = new StringBuffer(lastException.getLocalizedMsgString(locale));
        if (rootCause != null) {
            if (rootCause instanceof SOAPFault) {
                SOAPFault soapFault = (SOAPFault)rootCause;
                if ("urn:oasis:names:tc:wsrp:v1:types".equals(soapFault.getFaultCode().getNamespaceURI())) {
                    message.append("<br/>").append(MessagesManager.getInstance().getMessage(locale, "cps.wsrpfault." + soapFault.getFaultCode().getLocalPart().toLowerCase(), null)).append("<br/>").append(soapFault.getFaultString());
                } else {
                    String detail = soapFault.getDetail();
                    if (detail != null && detail.length() > 0) {
                        if (detail.charAt(0) == '<') {
                            try {
                                DetailHandler detailHandler = new DetailHandler(message, true, 3);
                                XMLReader reader = SAXUtils.getSAXParser().getXMLReader();
                                reader.setContentHandler(detailHandler);
                                message.append("<br/>");
                                reader.parse(new InputSource(new StringReader(detail)));
                            }
                            catch (ParserConfigurationException detailHandler) {
                            }
                            catch (SAXException detailHandler) {}
                        } else {
                            message.append(detail);
                        }
                    }
                }
            } else {
                String msg = rootCause.getLocalizedMessage();
                if (msg != null) {
                    message.append("<br/>").append(msg);
                }
            }
        }
        StringBuffer errorPage = new StringBuffer(1024).append("<table class=\"portlet-table-body\" border=\"0\" cellspacing=\"7\" cellpadding=\"0\" valign=\"top\" width=\"100%\"><tr><td valign=\"top\" width=\"1%\" rowspan=\"4\">").append("<img src=\"").append(imgBaseURL).append("images/dialog_error.gif\" alt=\"").append(MessagesManager.getInstance().getMessage(locale, "cps.errorpage.errorimgalt", null)).append("\"/></td><td valign=\"top\" width=\"98%\" class=\"portlet-table-text\">").append(MessagesManager.getInstance().getMessage(locale, "cps.errorpage.preerrormsg", null)).append("</td></tr><tr><td class=\"portlet-table-text\">").append(message.toString()).append("</td></tr><tr><td class=\"portlet-table-text\">").append(MessagesManager.getInstance().getMessage(locale, "cps.errorpage.posterrormsg", null)).append("</td></tr>");
        if (fixHelper != null && (fixes = fixHelper.getMessageIDs(rootCause)).length > 0) {
            StringBuffer fixesMarkup = new StringBuffer();
            fixesMarkup.append("- ").append(MessagesManager.getInstance().getMessage(locale, fixes[0], null));
            for (int i = 1; i < fixes.length; ++i) {
                fixesMarkup.append("<br>- ").append(MessagesManager.getInstance().getMessage(locale, fixes[i], null));
            }
            String uuid = UUID.randomUUID().toString();
            errorPage.append("<tr><td class=\"portlet-table-text\">").append("<script type=\"text/javascript\" language=\"JavaScript\"> var imgExpand = new Image(); var imgCollapse = new Image(); imgExpand.src = \"").append(imgBaseURL).append("images/prompt_option_expand.gif\"; imgCollapse.src = \"").append(imgBaseURL).append("images/prompt_option_collapse.gif\"; function toggleDynamicSection(name) { var img = document.getElementById(\"img_\" + name); if(document.getElementById(name).style.display == 'none') { document.getElementById(name).style.display = \"\"; img.src = imgCollapse.src; } else { document.getElementById(name).style.display = \"none\"; img.src = imgExpand.src; } } </script>").append("<table><tr><td class=\"formText\" valign=\"bottom\" nowrap><a href=\"javascript:toggleDynamicSection('errorPanel_").append(uuid).append("')\">").append(MessagesManager.getInstance().getMessage(locale, "cps.errorpage.possiblefixes", null)).append("</a><a href=\"javascript:toggleDynamicSection('errorPanel_").append(uuid).append("')\"> <img name=\"img_errorPanel\" id=\"img_errorPanel_").append(uuid).append("\" border=\"0\" src=\"").append(imgBaseURL).append("images/prompt_option_expand.gif\"></a></td></tr><tr><td><div id=\"errorPanel_").append(uuid).append("\" class=\"errorPanel\" style=\"display:none\">").append(fixesMarkup.toString()).append("</div></td></tr></table>").append("</td></tr>");
        }
        errorPage.append("</table>");
        return errorPage.toString();
    }
}

