/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.common.utils.Boyer;
import com.cognos.cps.wsrp.consumer.RequestContext;
import com.cognos.cps.wsrp.consumer.URLRewriteException;
import com.cognos.cps.wsrp.consumer.URLRewriteHandler;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;

public final class URLRewriter {
    private static final String SEARCH_PATTERN = "wsrp_rewrite";
    private RequestContext m_requestContext = null;
    private URLRewriteHandler m_urlHandler = null;
    private ServiceLogger m_logger = null;

    public URLRewriter(RequestContext requestContext) {
        this.m_requestContext = requestContext;
        this.m_urlHandler = requestContext.getURLRewriteHandler();
        this.m_logger = requestContext.getLogger();
    }

    public URLRewriter(URLRewriteHandler urlHandler, ServiceLogger logger) {
        this.m_requestContext = null;
        this.m_urlHandler = urlHandler;
        this.m_logger = logger;
    }

    public void rewrite(String dataIn, Writer dataOut) throws URLRewriteException {
        this.rewrite(dataIn.toCharArray(), dataOut);
    }

    public void rewrite(char[] dataIn, Writer dataOut) throws URLRewriteException {
        this.rewrite(dataIn, 0, dataIn.length, dataOut);
    }

    public void rewrite(char[] dataIn, int offset, int count, Writer dataOut) throws URLRewriteException {
        int search;
        long start = 0L;
        if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
            start = System.currentTimeMillis();
        }
        Boyer boyer = new Boyer(dataIn, count);
        int datalen = count;
        int currentpos = search = offset;
        try {
            while ((search = boyer.indexOf(SEARCH_PATTERN, search)) >= 0) {
                if (search < 0) continue;
                dataOut.write(new String(dataIn, currentpos, search - currentpos));
                int starturlpos = search + SEARCH_PATTERN.length();
                if (dataIn[starturlpos] == '_') {
                    this.m_urlHandler.generateUniquePortletId(dataOut);
                    search = starturlpos + 1;
                } else {
                    int endurlpos = boyer.indexOf(SEARCH_PATTERN, starturlpos);
                    if (endurlpos <= 0) {
                        throw new URLRewriteException("cps.consumer.rewritefailed");
                    }
                    if (dataIn[endurlpos - 1] != '/') {
                        throw new URLRewriteException("cps.consumer.rewritefailed");
                    }
                    this.callConsumerURLHandler(dataIn, starturlpos + 1, endurlpos - starturlpos - 2, dataOut);
                    search = endurlpos + SEARCH_PATTERN.length();
                }
                currentpos = search;
            }
            dataOut.write(new String(dataIn, currentpos, datalen - currentpos));
        }
        catch (IOException e) {
            throw new URLRewriteException("cps.consumer.rewritefailed", e);
        }
        if (this.m_logger != null && this.m_logger.isInfoEnabled()) {
            long end = System.currentTimeMillis();
            this.m_logger.info("URL rewrite took: " + (end - start) + "ms.");
        }
    }

    private void callConsumerURLHandler(char[] dataIn, int offset, int count, Writer dataOut) throws URLRewriteException {
        String replaceMode;
        int currentpos;
        if (this.m_logger != null) {
            this.m_logger.debug("Rewriting URL: " + new String(dataIn, offset, count));
        }
        HashMap<String, String> urlParams = new HashMap<String, String>();
        int equalspos = 0;
        int namestart = currentpos = offset;
        while (currentpos - offset < count) {
            equalspos = namestart;
            while (equalspos - offset < count && dataIn[equalspos] != '=') {
                ++equalspos;
            }
            if (equalspos - offset == count) {
                throw new URLRewriteException("cps.consumer.rewritefailed");
            }
            while (currentpos - offset < count && dataIn[currentpos] != '&') {
                ++currentpos;
            }
            if (currentpos - offset == count) {
                urlParams.put(new String(dataIn, namestart, equalspos - namestart), new String(dataIn, equalspos + 1, currentpos - equalspos - 1));
                if (this.m_logger == null) break;
                this.m_logger.debug("Adding URL param for Consumer URL handler: " + new String(dataIn, namestart, equalspos - namestart) + "=" + new String(dataIn, equalspos + 1, currentpos - equalspos - 1));
                break;
            }
            if (this.m_logger != null) {
                this.m_logger.debug("Adding URL param for Consumer URL handler: " + new String(dataIn, namestart, equalspos - namestart) + "=" + new String(dataIn, equalspos + 1, currentpos - equalspos - 1));
            }
            urlParams.put(new String(dataIn, namestart, equalspos - namestart), new String(dataIn, equalspos + 1, currentpos - equalspos - 1));
            namestart = ++currentpos;
        }
        if (this.m_requestContext != null && (replaceMode = this.m_requestContext.getOverideMode((String)urlParams.get("wsrp-mode"))) != null) {
            urlParams.put("wsrp-mode", replaceMode);
        }
        String cpsRewriteFlags = (String)urlParams.remove("cps-rewrite-flags");
        if (this.m_logger != null && this.m_logger.isDebugEnabled()) {
            CharArrayWriter rewriteResult = new CharArrayWriter();
            this.m_urlHandler.generateURL(urlParams, rewriteResult, cpsRewriteFlags);
            this.m_logger.debug("Rewritten URL:" + new String(rewriteResult.toCharArray()));
            try {
                dataOut.write(rewriteResult.toCharArray());
            }
            catch (IOException e) {
                throw new URLRewriteException("cps.consumer.cssclasssubstitution", e);
            }
        } else {
            this.m_urlHandler.generateURL(urlParams, dataOut, cpsRewriteFlags);
        }
    }
}

