/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.helpers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ApplicationSessionManager {
    private static Map applicationMap = new HashMap();

    public static synchronized void addRef(String identifier) {
        CreationTimeHashMap ctMap = (CreationTimeHashMap)applicationMap.get(identifier);
        if (ctMap == null) {
            ctMap = new CreationTimeHashMap();
            applicationMap.put(identifier, ctMap);
        }
        ++ctMap.refCount;
    }

    public static synchronized void removeRef(String identifier) {
        CreationTimeHashMap ctMap = (CreationTimeHashMap)applicationMap.get(identifier);
        if (ctMap != null) {
            --ctMap.refCount;
            if (ctMap.refCount == 0L) {
                applicationMap.remove(identifier);
            }
        }
    }

    public static synchronized Map getAttributeMap(String identifier) {
        return (Map)applicationMap.get(identifier);
    }

    public static synchronized void synchronizeSessions(List sessions) {
        CreationTimeHashMap oldest = null;
        Iterator it = sessions.iterator();
        while (it.hasNext()) {
            CreationTimeHashMap current = (CreationTimeHashMap)applicationMap.get(it.next());
            if (current == null || oldest != null && current.creationTime >= oldest.creationTime) continue;
            oldest = current;
        }
        if (oldest == null) {
            oldest = new CreationTimeHashMap();
        }
        it = sessions.iterator();
        while (it.hasNext()) {
            applicationMap.put(it.next(), oldest);
        }
    }

    private static class CreationTimeHashMap
    extends HashMap {
        private static final long serialVersionUID = 6342548451254730962L;
        long creationTime = System.currentTimeMillis();
        long refCount = 0L;

        private CreationTimeHashMap() {
        }
    }
}

