/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.wsrp.consumer.helpers;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.wsrp.consumer.CacheHandler;
import com.cognos.cps.wsrp.consumer.CachedMarkup;
import com.cognos.cps.wsrp.consumer.PropylaealetSession;
import java.util.ArrayList;
import java.util.Enumeration;

public class CacheHandlerImpl
implements CacheHandler {
    private static final String KEY_PREFIX = "CPS-cache-";
    private PropylaealetSession m_session;
    private int m_maxCachedPages;
    private ServiceLogger m_logger;
    private String m_cacheKeyPrefix;

    private CacheHandlerImpl() {
    }

    public CacheHandlerImpl(ServiceLogger logger, PropylaealetSession session, int maxCachedPages) {
        this.m_logger = logger;
        this.m_session = session;
        this.m_cacheKeyPrefix = KEY_PREFIX;
        this.m_maxCachedPages = maxCachedPages;
    }

    @Override
    public void putCachedMarkup(String key, CachedMarkup cachedMarkup) {
        this.m_logger.debug("putCachedMarkup() called.");
        if (this.m_maxCachedPages == 0) {
            this.m_logger.debug("caching is currently disabled. ");
            return;
        }
        int cachedPageCount = 0;
        String name = null;
        Enumeration attributeNames = this.m_session.fetchAllMyPropertyNames();
        while (attributeNames.hasMoreElements()) {
            name = (String)attributeNames.nextElement();
            if (!name.startsWith(this.m_cacheKeyPrefix)) continue;
            ++cachedPageCount;
        }
        if (cachedPageCount > this.m_maxCachedPages) {
            this.m_logger.debug("Current cache size exceeds the maximum, purging cache.");
            String keyOfOldestCachedMarkup = null;
            long lruTime = System.currentTimeMillis();
            CachedMarkup previousCachedMarkup = null;
            attributeNames = this.m_session.fetchAllMyPropertyNames();
            while (attributeNames.hasMoreElements()) {
                name = (String)attributeNames.nextElement();
                if (!name.startsWith(this.m_cacheKeyPrefix) || (previousCachedMarkup = (CachedMarkup)this.m_session.fetchPropertyByName(this.m_cacheKeyPrefix + key)) == null || previousCachedMarkup.getLastAccessTime() >= lruTime) continue;
                keyOfOldestCachedMarkup = name;
                lruTime = previousCachedMarkup.getLastAccessTime();
            }
            if (keyOfOldestCachedMarkup != null) {
                this.m_logger.debug("Removing cached object with key: " + keyOfOldestCachedMarkup);
                this.m_session.killPropertyByName(keyOfOldestCachedMarkup);
            }
        }
        this.m_session.applyPropertyByName(this.m_cacheKeyPrefix + key, cachedMarkup);
    }

    @Override
    public void invalidateCachedMarkup() {
        String name = null;
        Enumeration attributeNames = this.m_session.fetchAllMyPropertyNames();
        ArrayList<String> attributeToBeRemoved = new ArrayList<String>();
        while (attributeNames.hasMoreElements()) {
            name = (String)attributeNames.nextElement();
            if (!name.startsWith(this.m_cacheKeyPrefix)) continue;
            attributeToBeRemoved.add(name);
        }
        for (int i = 0; i < attributeToBeRemoved.size(); ++i) {
            name = (String)attributeToBeRemoved.get(i);
            this.m_session.killPropertyByName(name);
        }
    }

    @Override
    public CachedMarkup getCachedMarkup(String key) {
        CachedMarkup cachedMarkup = null;
        try {
            cachedMarkup = (CachedMarkup)this.m_session.fetchPropertyByName(this.m_cacheKeyPrefix + key);
            if (cachedMarkup != null) {
                cachedMarkup.updateLastAccessTime();
            }
        }
        catch (ClassCastException e) {
            this.invalidateCachedMarkup();
        }
        return cachedMarkup;
    }
}

