/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.CMP;
import com.ibm.security.cmp.InfoValue;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public final class ConfirmWaitTimeInfoValue
extends CMPDerObject
implements InfoValue,
Cloneable {
    private static final ObjectIdentifier oid = CMP.confirm_wait_time_oid;
    private Date value;
    private byte[] encodedValue;

    public ConfirmWaitTimeInfoValue(Date date) throws IOException {
        if (date == null) {
            throw new IllegalArgumentException("ConfirmWaitTimeInfoValue error, date not specified");
        }
        this.value = new Date(date.getTime());
        this.setEncodedValue();
    }

    public ConfirmWaitTimeInfoValue(byte[] byArray) throws IOException {
        this.decode(byArray);
    }

    public Object clone() {
        try {
            return new ConfirmWaitTimeInfoValue(this.encodedValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        try {
            this.value = derValue.getData().getGeneralizedTime();
            this.setEncodedValue();
        }
        catch (Exception exception) {
            throw new IOException("ConfirmWaitTimeInfoValue decoding error, " + exception.toString());
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.encodedValue);
    }

    public boolean equals(ConfirmWaitTimeInfoValue confirmWaitTimeInfoValue) {
        DerValue derValue;
        DerValue derValue2;
        if (confirmWaitTimeInfoValue == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            confirmWaitTimeInfoValue.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof ConfirmWaitTimeInfoValue) {
            return this.equals((ConfirmWaitTimeInfoValue)object);
        }
        return false;
    }

    public byte[] getEncodedValue() {
        return (byte[])this.encodedValue.clone();
    }

    public String getName() {
        return "ConfirmWaitTime";
    }

    public ObjectIdentifier getObjectIdentifier() {
        return oid;
    }

    public Object getValue() {
        return new Date(this.value.getTime());
    }

    private void setEncodedValue() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putGeneralizedTime(this.value);
        this.encodedValue = derOutputStream.toByteArray();
    }

    public String toString() {
        String string = "";
        Object object = this.getValue();
        string = String.valueOf(string) + "ConfirmWaitTimeInfoValue:";
        string = String.valueOf(string) + "\r\nobject identifier: " + oid;
        string = String.valueOf(string) + "\r\ngeneralized time:\r\n";
        string = String.valueOf(string) + this.value.toString();
        return string;
    }
}

