/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.crmf;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;

public final class PKMACValue
extends CMPDerObject {
    private AlgorithmId algId;
    private byte[] value;

    public PKMACValue(AlgorithmId algorithmId, byte[] byArray) {
        if (algorithmId == null) {
            throw new IllegalArgumentException("PKMACValue error, algorithm identifier not specified");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("PKMACValue error, value not specified");
        }
        this.algId = algorithmId;
        this.value = byArray;
    }

    public PKMACValue(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            return new PKMACValue(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("PKMACValue parsing error, not a SEQUENCE");
        }
        this.algId = null;
        this.value = null;
        if (derValue.getData().available() == 0) {
            throw new IOException("PKMACValue decoding error, data missing");
        }
        this.algId = AlgorithmId.parse((DerValue)derValue.getData().getDerValue());
        if (derValue.getData().available() == 0) {
            throw new IOException("PKMACValue decoding error, data missing");
        }
        this.value = derValue.getData().getBitString();
        if (derValue.getData().available() != 0) {
            throw new IOException("PKMACValue decoding error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.algId == null) {
            throw new IOException("PKMACValue encoding error, algorithm identifier not specified");
        }
        this.algId.encode(derOutputStream);
        if (this.value == null) {
            throw new IOException("PKMACValue encoding error, value not specified");
        }
        derOutputStream.putBitString(this.value);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(PKMACValue pKMACValue) {
        DerValue derValue;
        DerValue derValue2;
        if (pKMACValue == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            pKMACValue.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof PKMACValue) {
            return this.equals((PKMACValue)object);
        }
        return false;
    }

    public AlgorithmId getAlgId() throws IOException {
        if (this.algId == null) {
            return null;
        }
        return new AlgorithmId(this.algId.getOID(), this.algId.getParameters());
    }

    public byte[] getValue() {
        return (byte[])this.value.clone();
    }

    public String toString() {
        String string = "PKMACValue:";
        string = String.valueOf(string) + "\r\n\talgId: " + this.algId.toString();
        string = String.valueOf(string) + "\r\n\tvalue: " + new String(this.value);
        return string;
    }
}

